/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.ExecutionContextOp;
import org.cf.smalivm.type.UninitializedInstance;
import org.cf.smalivm.type.VirtualClass;
import org.jf.dexlib2.builder.MethodLocation;

public class NewInstanceOp
extends ExecutionContextOp {
    private final VirtualClass virtualClass;
    private final int destRegister;
    private final VirtualMachine vm;
    private SideEffect.Level sideEffectLevel;

    NewInstanceOp(MethodLocation location, MethodLocation child, int destRegister, VirtualClass virtualClass, VirtualMachine vm) {
        super(location, child);
        this.destRegister = destRegister;
        this.virtualClass = virtualClass;
        this.vm = vm;
        this.sideEffectLevel = SideEffect.Level.STRONG;
    }

    @Override
    public void execute(ExecutionNode node, ExecutionContext context) {
        UninitializedInstance instance = new UninitializedInstance(this.virtualClass);
        if (this.vm.isSafe(this.virtualClass)) {
            this.sideEffectLevel = SideEffect.Level.NONE;
        } else {
            context.readClassState(this.virtualClass);
            this.sideEffectLevel = context.getClassSideEffectLevel(this.virtualClass);
        }
        MethodState mState = context.getMethodState();
        HeapItem instanceItem = new HeapItem(instance, this.virtualClass.getName());
        mState.assignRegister(this.destRegister, instanceItem);
    }

    @Override
    public SideEffect.Level getSideEffectLevel() {
        return this.sideEffectLevel;
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", " + this.virtualClass;
    }
}

