/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.type.UnknownValue;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewArrayOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(NewArrayOp.class.getSimpleName());
    private final int destRegister;
    private final int lengthRegister;
    private final String arrayType;
    private final ClassLoader classLoader;

    NewArrayOp(MethodLocation location, MethodLocation child, int destRegister, int lengthRegister, String arrayType, ClassLoader classLoader) {
        super(location, child);
        this.destRegister = destRegister;
        this.lengthRegister = lengthRegister;
        this.arrayType = arrayType;
        this.classLoader = classLoader;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem lengthItem = mState.readRegister(this.lengthRegister);
        Object instance = this.buildInstance(lengthItem);
        if (instance instanceof Throwable) {
            node.setException((Throwable)instance);
            node.clearChildren();
            return;
        }
        node.clearExceptions();
        mState.assignRegister(this.destRegister, instance, this.arrayType);
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", r" + this.lengthRegister + ", " + this.arrayType;
    }

    private Object buildInstance(HeapItem lengthItem) {
        Object instance;
        if (lengthItem.isUnknown()) {
            instance = new UnknownValue();
        } else {
            int length = lengthItem.asInteger();
            try {
                instance = Utils.buildArray(this.arrayType, length, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                return e;
            }
        }
        return instance;
    }

    public int getDestRegister() {
        return this.destRegister;
    }

    public int getLengthRegister() {
        return this.lengthRegister;
    }

    public String getArrayType() {
        return this.arrayType;
    }
}

