/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.jf.dexlib2.builder.MethodLocation;

public class MoveOp
extends MethodStateOp {
    private final MoveType moveType;
    private final int toRegister;
    private int targetRegister;

    MoveOp(MethodLocation location, MethodLocation child, int toRegister, int targetRegister) {
        this(location, child, toRegister, MoveType.REGISTER);
        this.targetRegister = targetRegister;
    }

    MoveOp(MethodLocation location, MethodLocation child, int toRegister, MoveType moveType) {
        super(location, child);
        this.toRegister = toRegister;
        this.moveType = moveType;
    }

    private static void moveException(MethodState mState, int toRegister) {
        HeapItem exception = mState.peekExceptionRegister();
        mState.assignRegister(toRegister, exception);
    }

    private static void moveRegister(MethodState mState, int toRegister, int fromRegister) {
        HeapItem item = mState.readRegister(fromRegister);
        mState.assignRegister(toRegister, item);
    }

    private static void moveResult(MethodState mState, int toRegister) {
        HeapItem item = mState.readResultRegister();
        mState.assignRegister(toRegister, item);
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        switch (this.moveType) {
            case EXCEPTION: {
                MoveOp.moveException(mState, this.toRegister);
                break;
            }
            case RESULT: {
                MoveOp.moveResult(mState, this.toRegister);
                break;
            }
            case REGISTER: {
                MoveOp.moveRegister(mState, this.toRegister, this.targetRegister);
            }
        }
    }

    public MoveType getMoveType() {
        return this.moveType;
    }

    public int getToRegister() {
        return this.toRegister;
    }

    public int getTargetRegister() {
        return this.targetRegister;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" r").append(this.toRegister);
        if (MoveType.REGISTER == this.moveType) {
            sb.append(", r").append(this.targetRegister);
        }
        return sb.toString();
    }

    static enum MoveType {
        EXCEPTION,
        REGISTER,
        RESULT;

    }
}

