/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import gnu.trove.list.linked.TIntLinkedList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.cf.smalivm.MethodExecutor;
import org.cf.smalivm.MethodReflector;
import org.cf.smalivm.ObjectInstantiator;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.emulate.MethodEmulator;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.opcode.ExecutionContextOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.opcode.ReturnOp;
import org.cf.smalivm.opcode.ThrowOp;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.UninitializedInstance;
import org.cf.smalivm.type.UnknownValue;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeOp
extends ExecutionContextOp {
    private static final Logger log = LoggerFactory.getLogger(InvokeOp.class.getSimpleName());
    private final VirtualMethod method;
    private final int[] parameterRegisters;
    private final String[] analyzedParameterTypes;
    private final VirtualMachine vm;
    private final ClassManager classManager;
    private SideEffect.Level sideEffectLevel;
    private boolean debugMode;
    private MethodExecutor debuggedMethodExecutor;
    private ExecutionContext debuggedCallerContext;
    private ExecutionContext debuggedCalleeContext;
    private ExecutionNode debuggedNode;

    InvokeOp(MethodLocation location, MethodLocation child, VirtualMethod method, int[] parameterRegisters, VirtualMachine vm) {
        super(location, child);
        this.method = method;
        this.parameterRegisters = parameterRegisters;
        this.analyzedParameterTypes = new String[method.getParameterTypeNames().size()];
        this.vm = vm;
        this.classManager = vm.getClassManager();
        this.sideEffectLevel = SideEffect.Level.STRONG;
        this.debugMode = false;
    }

    @Override
    public void execute(ExecutionNode node, ExecutionContext context) {
        ExecutionContext calleeContext;
        MethodState callerMethodState = context.getMethodState();
        if (this.method.getSignature().equals("Ljava/lang/Object;-><init>()V")) {
            try {
                this.executeLocalObjectInit(callerMethodState);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                log.error("Unexpected real exception initializing Object", e);
            }
            return;
        }
        if (this.method.getName().equals("clone") && this.parameterRegisters.length == 1) {
            int targetRegister = this.parameterRegisters[0];
            HeapItem item = context.getMethodState().peekRegister(targetRegister);
            String signature = this.method.getSignature();
            if (signature.charAt(0) == '[' || !item.isNull() && item.getValueType().charAt(0) == '[') {
                this.executeArrayClone(callerMethodState, node);
                return;
            }
        }
        this.analyzeParameterTypes(callerMethodState);
        VirtualMethod targetMethod = this.method;
        if (this.getName().startsWith("invoke-virtual") && !this.method.isFinal()) {
            int targetRegister = this.parameterRegisters[0];
            HeapItem item = context.getMethodState().peekRegister(targetRegister);
            targetMethod = this.resolveTargetMethod(item.getValue());
        }
        String targetSignature = targetMethod.getSignature();
        if (this.vm.getConfiguration().isSafe(targetSignature) || MethodEmulator.canEmulate(targetSignature)) {
            calleeContext = this.buildNonLocalCalleeContext(context);
            boolean allArgumentsKnown = this.allArgumentsKnown(calleeContext.getMethodState());
            if (allArgumentsKnown || MethodEmulator.canHandleUnknownValues(targetSignature)) {
                this.executeNonLocalMethod(targetSignature, callerMethodState, calleeContext, node);
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("Not emulating / reflecting {}; not all arguments are known", (Object)targetSignature);
            }
            this.assumeMaximumUnknown(callerMethodState);
            return;
        }
        if (this.classManager.isFrameworkClass(targetMethod.getDefiningClass()) && !this.classManager.isSafeFrameworkClass(targetMethod.getDefiningClass())) {
            if (log.isDebugEnabled()) {
                log.debug("Not executing unsafe framework method: {}. Assuming maximum ambiguity.", (Object)targetSignature);
            }
            this.assumeMaximumUnknown(callerMethodState);
            return;
        }
        if (!targetMethod.hasImplementation()) {
            if (log.isWarnEnabled()) {
                if (!targetMethod.isNative()) {
                    log.warn("Attempting to execute local native method without implementation: {}. Assuming maximum ambiguity.", (Object)targetSignature);
                } else {
                    log.warn("Cannot execute local native method: {}. Assuming maximum ambiguity.", (Object)targetSignature);
                }
            }
            this.assumeMaximumUnknown(callerMethodState);
            return;
        }
        calleeContext = this.buildLocalCalleeContext(context, targetMethod);
        this.executeLocalMethod(calleeContext, context, node);
    }

    public int[] getParameterRegisters() {
        return this.parameterRegisters;
    }

    public String getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public SideEffect.Level getSideEffectLevel() {
        return this.sideEffectLevel;
    }

    public VirtualMethod getMethod() {
        return this.method;
    }

    public String[] getAnalyzedParameterTypes() {
        return this.analyzedParameterTypes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" {");
        if (this.getName().contains("/range")) {
            sb.append('r').append(this.parameterRegisters[0]).append(" .. r").append(this.parameterRegisters[this.parameterRegisters.length - 1]);
        } else if (this.parameterRegisters.length > 0) {
            for (int register : this.parameterRegisters) {
                sb.append('r').append(register).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append("}, ").append(this.method);
        return sb.toString();
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private void executeArrayClone(MethodState callerMethodState, ExecutionNode node) {
        int instanceRegister = this.parameterRegisters[0];
        HeapItem arrayItem = callerMethodState.peekRegister(instanceRegister);
        if (arrayItem.isUnknown()) {
            callerMethodState.assignResultRegister(new UnknownValue(), arrayItem.getType());
        } else if (arrayItem.isNull()) {
            NullPointerException exception = new NullPointerException();
            this.addException(exception);
            node.clearChildren();
        } else {
            Method m3 = null;
            try {
                m3 = Object.class.getDeclaredMethod("clone", new Class[0]);
                m3.setAccessible(true);
                Object clone = m3.invoke(arrayItem.getValue(), new Object[0]);
                callerMethodState.assignResultRegister(clone, arrayItem.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean allArgumentsKnown(MethodState mState) {
        String type;
        for (int parameterRegister = mState.getParameterStart(); parameterRegister < mState.getRegisterCount(); parameterRegister += Utils.getRegisterSize(type)) {
            HeapItem item = mState.peekParameter(parameterRegister);
            if (item.isUnknown()) {
                return false;
            }
            type = item.getType();
        }
        return true;
    }

    private void analyzeParameterTypes(MethodState callerState) {
        List<String> parameterTypes = this.method.getParameterTypeNames();
        for (int i = 0; i < this.parameterRegisters.length; ++i) {
            String type;
            int callerRegister = this.parameterRegisters[i];
            HeapItem item = callerState.readRegister(callerRegister);
            String parameterTypeName = parameterTypes.get(i);
            String baseTypeName = item.getComponentBase();
            if (item.isPrimitive() || ClassNameUtils.isPrimitive(baseTypeName)) {
                type = parameterTypeName;
            } else {
                VirtualType baseType = this.vm.getClassManager().getVirtualType(baseTypeName);
                VirtualType parameterType = this.vm.getClassManager().getVirtualType(parameterTypeName);
                type = baseType.getAncestors().contains(parameterType) ? item.getType() : parameterTypeName;
            }
            this.analyzedParameterTypes[i] = type;
        }
    }

    private void assignCalleeMethodArguments(MethodState callerState, MethodState calleeState) {
        int parameterRegister = calleeState.getParameterStart();
        for (int i = 0; i < this.parameterRegisters.length; ++i) {
            int callerRegister = this.parameterRegisters[i];
            HeapItem item = callerState.readRegister(callerRegister);
            String parameterType = this.analyzedParameterTypes[i];
            Object value = item.getValue();
            if (item.isPrimitive() && !item.isUnknown()) {
                boolean hasNullByteValue = item.getType().equals("I") && value instanceof Number && item.asInteger() == 0;
                value = hasNullByteValue && ClassNameUtils.isObject(parameterType) ? null : Utils.castToPrimitive(value, parameterType);
            }
            HeapItem parameterItem = new HeapItem(value, parameterType);
            calleeState.assignParameter(parameterRegister, parameterItem);
            parameterRegister += Utils.getRegisterSize(parameterType);
        }
    }

    private void assumeMaximumUnknown(MethodState callerMethodState) {
        boolean isInitializing = this.method.getSignature().contains(";-><init>(");
        for (int i = 0; i < this.method.getParameterTypeNames().size(); ++i) {
            String type;
            int register = this.parameterRegisters[i];
            HeapItem item = callerMethodState.readRegister(register);
            Object value = item.getValue();
            if (null == value) continue;
            if (item.isUnknown()) {
                VirtualType argumentType;
                VirtualType parameterType;
                type = this.analyzedParameterTypes[i];
                if (!type.equals(item.getType()) && (parameterType = this.vm.getClassManager().getVirtualType(type)).isAncestorOf(argumentType = this.vm.getClassManager().getVirtualType(item.getType()))) {
                    type = item.getType();
                }
            } else {
                type = item.getType();
            }
            if (!isInitializing && this.vm.getConfiguration().isImmutable(type)) {
                if (!log.isTraceEnabled()) continue;
                log.trace("{} is immutable", (Object)type);
                continue;
            }
            item = HeapItem.newUnknown(type);
            if (log.isDebugEnabled()) {
                log.debug("{} is mutable and passed into unresolvable method execution, making Unknown", (Object)type);
            }
            callerMethodState.pokeRegister(register, item);
        }
        if (isInitializing) {
            // empty if block
        }
        if (!this.method.returnsVoid()) {
            HeapItem item = HeapItem.newUnknown(this.method.getReturnType());
            callerMethodState.assignResultRegister(item);
        }
    }

    private ExecutionContext buildLocalCalleeContext(ExecutionContext callerContext, VirtualMethod method) {
        ExecutionContext calleeContext = this.vm.spawnRootContext(method, callerContext, this.getAddress());
        MethodState callerMethodState = callerContext.getMethodState();
        MethodState calleeMethodState = calleeContext.getMethodState();
        this.assignCalleeMethodArguments(callerMethodState, calleeMethodState);
        return calleeContext;
    }

    private ExecutionContext buildNonLocalCalleeContext(ExecutionContext callerContext) {
        int parameterSize;
        ExecutionContext calleeContext = new ExecutionContext(this.vm, this.method);
        int registerCount = parameterSize = this.method.getParameterSize();
        MethodState calleeMethodState = new MethodState(calleeContext, registerCount, this.method.getParameterTypeNames().size(), parameterSize);
        this.assignCalleeMethodArguments(callerContext.getMethodState(), calleeMethodState);
        calleeContext.setMethodState(calleeMethodState);
        calleeContext.registerCaller(callerContext, this.getAddress());
        return calleeContext;
    }

    private void finishLocalMethodExecution(ExecutionContext calleeContext, ExecutionContext callerContext, ExecutionNode node, ExecutionGraph graph) {
        if (graph == null) {
            log.info("Problem executing {}, propagating ambiguity.", (Object)calleeContext.getMethod());
            this.assumeMaximumUnknown(callerContext.getMethodState());
            return;
        }
        boolean hasOneNonThrow = false;
        for (int endAddress : graph.getConnectedTerminatingAddresses()) {
            Op endOp = graph.getTemplateNode(endAddress).getOp();
            if (endOp instanceof ThrowOp) {
                Set<HeapItem> items = graph.getRegisterItems(endAddress, -4);
                for (HeapItem item : items) {
                    if (item.getValue() instanceof Throwable) {
                        Throwable exception = (Throwable)item.getValue();
                        this.addException(exception);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    if (item.isUnknown()) {
                        log.warn("Method had possible execution path which throws an exception but cannot instantiate it because the value is unknown. Exception item: {}", (Object)item);
                        continue;
                    }
                    log.warn("Refusing to instantiate potentially unsafe thrown exception: {}.", (Object)item);
                }
                continue;
            }
            hasOneNonThrow = true;
        }
        if (!hasOneNonThrow) {
            node.clearChildren();
        } else if (!this.method.getReturnType().equals("V")) {
            TIntLinkedList returnOpAddresses = new TIntLinkedList();
            for (int address : graph.getConnectedTerminatingAddresses()) {
                if (!(graph.getOp(address) instanceof ReturnOp)) continue;
                returnOpAddresses.add(address);
            }
            HeapItem consensus = graph.getRegisterConsensus(returnOpAddresses.toArray(), -2);
            callerContext.getMethodState().assignResultRegister(consensus);
        } else if (calleeContext.getMethod().getDescriptor().startsWith("<init>(")) {
            int calleeInstanceRegister = calleeContext.getMethodState().getParameterStart();
            HeapItem newInstance = graph.getTerminatingRegisterConsensus(calleeInstanceRegister);
            int instanceRegister = this.parameterRegisters[0];
            callerContext.getMethodState().assignRegisterAndUpdateIdentities(instanceRegister, newInstance);
        }
        this.sideEffectLevel = graph.getHighestSideEffectLevel();
    }

    private void executeLocalMethod(ExecutionContext calleeContext, ExecutionContext callerContext, ExecutionNode node) {
        if (this.isDebugMode()) {
            this.startDebugLocalMethod(calleeContext, callerContext, node);
        } else {
            ExecutionGraph graph = null;
            try {
                graph = this.vm.execute(calleeContext, callerContext, this.parameterRegisters);
            }
            catch (VirtualMachineException e) {
                log.warn(e.toString());
                if (e instanceof UnhandledVirtualException) {
                    // empty if block
                }
            }
            this.finishLocalMethodExecution(calleeContext, callerContext, node, graph);
        }
    }

    public void startDebugLocalMethod(ExecutionContext calleeContext, ExecutionContext callerContext, ExecutionNode node) {
        this.debuggedMethodExecutor = this.vm.startDebug(calleeContext, callerContext);
        this.debuggedCalleeContext = calleeContext;
        this.debuggedCallerContext = callerContext;
        this.debuggedNode = node;
    }

    public void finishDebugLocalMethod(ExecutionGraph graph) {
        this.finishLocalMethodExecution(this.debuggedCalleeContext, this.debuggedCallerContext, this.debuggedNode, graph);
    }

    public MethodExecutor getDebuggedMethodExecutor() {
        return this.debuggedMethodExecutor;
    }

    private void executeLocalObjectInit(MethodState callerMethodState) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int instanceRegister = this.parameterRegisters[0];
        HeapItem instanceItem = callerMethodState.peekRegister(instanceRegister);
        UninitializedInstance uninitializedInstance = (UninitializedInstance)instanceItem.getValue();
        VirtualType instanceType = uninitializedInstance.getType();
        Class<?> klazz = this.vm.getClassLoader().loadClass(instanceType.getBinaryName());
        Object newInstance = ObjectInstantiator.newInstance(klazz);
        HeapItem newInstanceItem = new HeapItem(newInstance, instanceType.getName());
        callerMethodState.assignRegisterAndUpdateIdentities(instanceRegister, newInstanceItem);
    }

    private void executeNonLocalMethod(String methodDescriptor, MethodState callerMethodState, ExecutionContext calleeContext, ExecutionNode node) {
        if (MethodEmulator.canEmulate(methodDescriptor)) {
            MethodEmulator emulator = new MethodEmulator(this.vm, calleeContext, methodDescriptor);
            emulator.emulate(this);
            this.sideEffectLevel = emulator.getSideEffectLevel();
            if (emulator.getExceptions().size() > 0) {
                node.clearChildren();
                node.setExceptions(emulator.getExceptions());
                return;
            }
        } else if (this.vm.getConfiguration().isSafe(methodDescriptor)) {
            MethodReflector reflector = new MethodReflector(this.vm, this.method);
            try {
                reflector.reflect(calleeContext.getMethodState());
            }
            catch (Exception e) {
                node.setException(e);
                node.clearChildren();
                return;
            }
            this.sideEffectLevel = SideEffect.Level.NONE;
        }
        if (!this.method.isStatic()) {
            HeapItem originalInstanceItem = callerMethodState.peekRegister(this.parameterRegisters[0]);
            HeapItem newInstanceItem = calleeContext.getMethodState().peekParameter(0);
            if (originalInstanceItem.getValue() != newInstanceItem.getValue()) {
                callerMethodState.assignRegisterAndUpdateIdentities(this.parameterRegisters[0], newInstanceItem);
            } else {
                boolean isMutable;
                boolean bl = isMutable = !this.vm.getConfiguration().isImmutable(newInstanceItem.getType());
                if (isMutable) {
                    callerMethodState.assignRegister(this.parameterRegisters[0], newInstanceItem);
                }
            }
        }
        if (!this.method.returnsVoid()) {
            HeapItem returnItem = calleeContext.getMethodState().readReturnRegister();
            callerMethodState.assignResultRegister(returnItem);
        }
    }

    @Nullable
    private VirtualMethod resolveTargetMethod(Object virtualReference) {
        VirtualType referenceType;
        if (virtualReference == null || virtualReference instanceof UnknownValue) {
            return this.method;
        }
        if (virtualReference instanceof UninitializedInstance) {
            UninitializedInstance instance = (UninitializedInstance)virtualReference;
            referenceType = instance.getType();
        } else {
            String targetType = ClassNameUtils.toInternal(virtualReference.getClass());
            referenceType = this.classManager.getVirtualType(targetType);
        }
        VirtualMethod targetMethod = referenceType.getMethod(this.method.getDescriptor());
        if (targetMethod != null && targetMethod.hasImplementation()) {
            return targetMethod;
        }
        return this.method;
    }
}

