/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceOfOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(InstanceOfOp.class.getSimpleName());
    private final VirtualType referenceType;
    private final int destRegister;
    private final int arg1Register;
    private final VirtualMachine vm;

    InstanceOfOp(MethodLocation location, MethodLocation child, int destRegister, int arg1Register, VirtualType referenceType, VirtualMachine vm) {
        super(location, child);
        this.destRegister = destRegister;
        this.arg1Register = arg1Register;
        this.referenceType = referenceType;
        this.vm = vm;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem item = mState.readRegister(this.arg1Register);
        Object value = item.getValue();
        if (value == null) {
            mState.assignRegister(this.destRegister, new HeapItem(false, "Z"));
            return;
        }
        ClassManager classManager = this.vm.getClassManager();
        for (String typeName : Utils.getDeclaredAndValueTypeNames(item)) {
            VirtualType itemType = classManager.getVirtualType(typeName);
            if (!itemType.instanceOf(this.referenceType)) continue;
            mState.assignRegister(this.destRegister, new HeapItem(true, "Z"));
            return;
        }
        if (item.isUnknown()) {
            mState.assignRegister(this.destRegister, HeapItem.newUnknown("Z"));
        } else {
            mState.assignRegister(this.destRegister, new HeapItem(false, "Z"));
        }
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", " + this.arg1Register + ", " + this.referenceType;
    }
}

