/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import gnu.trove.map.TIntObjectMap;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.opcode.IfOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.opcode.OpFactory;
import org.cf.util.Utils;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;

public class IfOpFactory
implements OpFactory {
    private static IfOp.IfType getIfType(String opName) {
        IfOp.IfType result = null;
        if (opName.contains("-eq")) {
            result = IfOp.IfType.EQUAL;
        } else if (opName.contains("-ne")) {
            result = IfOp.IfType.NOT_EQUAL;
        } else if (opName.contains("-lt")) {
            result = IfOp.IfType.LESS;
        } else if (opName.contains("-le")) {
            result = IfOp.IfType.LESS_OR_EQUAL;
        } else if (opName.contains("-gt")) {
            result = IfOp.IfType.GREATER;
        } else if (opName.contains("-ge")) {
            result = IfOp.IfType.GREATER_OR_EQUAL;
        }
        return result;
    }

    @Override
    public Op create(MethodLocation location, TIntObjectMap<MethodLocation> addressToLocation, VirtualMachine vm) {
        BuilderInstruction instruction = (BuilderInstruction)location.getInstruction();
        int address = instruction.getLocation().getCodeAddress();
        int branchOffset = ((OffsetInstruction)((Object)instruction)).getCodeOffset();
        int targetAddress = address + branchOffset;
        MethodLocation child = Utils.getNextLocation(location, addressToLocation);
        MethodLocation target = addressToLocation.get(targetAddress);
        String opName = instruction.getOpcode().name;
        IfOp.IfType ifType = IfOpFactory.getIfType(opName);
        int register1 = ((OneRegisterInstruction)((Object)instruction)).getRegisterA();
        if (instruction instanceof Instruction22t) {
            Instruction22t instr = (Instruction22t)location.getInstruction();
            return new IfOp(location, child, ifType, target, register1, instr.getRegisterB());
        }
        return new IfOp(location, child, ifType, target, register1);
    }
}

