/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilledNewArrayOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(FilledNewArrayOp.class.getSimpleName());
    private final int[] dimensionRegisters;
    private final String typeReference;

    FilledNewArrayOp(MethodLocation location, MethodLocation child, int[] dimensionRegisters, String typeReference) {
        super(location, child);
        this.dimensionRegisters = dimensionRegisters;
        this.typeReference = typeReference;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        int[] dimensions = new int[this.dimensionRegisters.length];
        boolean foundUnknown = false;
        for (int i = 0; i < this.dimensionRegisters.length; ++i) {
            int register = this.dimensionRegisters[i];
            HeapItem item = mState.readRegister(register);
            if (foundUnknown) continue;
            Object value = item.getValue();
            if (value instanceof Number) {
                dimensions[i] = ((Number)value).intValue();
                continue;
            }
            if (!item.isUnknown() && log.isWarnEnabled()) {
                log.warn("Unexpected value virtual for {}: {}", (Object)this.toString(), (Object)item);
            }
            foundUnknown = true;
        }
        if (foundUnknown) {
            mState.assignResultRegister(HeapItem.newUnknown("[I"));
        } else {
            mState.assignResultRegister(dimensions, "[I");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" {");
        if (this.dimensionRegisters.length > 5) {
            sb.append('r').append(this.dimensionRegisters[0]).append(" .. r").append(this.dimensionRegisters[this.dimensionRegisters.length - 1]);
        } else {
            for (int dimensionRegister : this.dimensionRegisters) {
                sb.append('r').append(dimensionRegister).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append("}, ").append(this.typeReference);
        return sb.toString();
    }
}

