/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import org.apache.commons.lang3.ClassUtils;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(ConstOp.class.getSimpleName());
    private final ConstantType constantType;
    private final int destRegister;
    private final Object literal;
    private final ClassLoader classLoader;

    ConstOp(MethodLocation location, MethodLocation child, int destRegister, ConstantType constantType, Object literal, ClassLoader classLoader, ExceptionFactory exceptionFactory) {
        super(location, child);
        this.destRegister = destRegister;
        this.constantType = constantType;
        this.literal = literal;
        this.classLoader = classLoader;
        if (ConstantType.CLASS.equals((Object)constantType)) {
            this.addException(exceptionFactory.build((Op)this, ClassNotFoundException.class, (String)literal));
        }
    }

    public ConstantType getConstantType() {
        return this.constantType;
    }

    public int getDestRegister() {
        return this.destRegister;
    }

    public Object getLiteral() {
        return this.literal;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        Object constant = this.buildConstant();
        if (constant instanceof Throwable) {
            node.setException((Throwable)constant);
            node.clearChildren();
            return;
        }
        node.clearExceptions();
        mState.assignRegister(this.destRegister, constant, this.getConstantTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" r").append(this.destRegister).append(", ");
        switch (this.constantType) {
            case CLASS: {
                sb.append(this.literal);
                break;
            }
            case NARROW: {
                String val = Integer.toString((Integer)this.literal, 16);
                if (val.startsWith("-")) {
                    sb.append('-');
                    val = val.substring(1);
                }
                sb.append("0x").append(val);
                break;
            }
            case STRING: {
                sb.append('\"').append((String)this.literal).append('\"');
                break;
            }
            case WIDE: {
                String val = Long.toString((Long)this.literal, 16);
                if (val.startsWith("-")) {
                    sb.append('-');
                    val = val.substring(1);
                }
                sb.append("0x").append(val);
                break;
            }
        }
        return sb.toString();
    }

    private Object buildConstant() {
        Class<?> constant;
        if (ConstantType.CLASS == this.constantType) {
            String className = (String)this.literal;
            try {
                String binaryClassName = ClassNameUtils.internalToBinary(className);
                constant = ClassUtils.getClass(this.classLoader, binaryClassName);
            }
            catch (ClassNotFoundException e) {
                return e;
            }
        } else {
            constant = this.literal;
        }
        return constant;
    }

    private String getConstantTypeString() {
        String type;
        switch (this.constantType) {
            case CLASS: {
                type = "Ljava/lang/Class;";
                break;
            }
            case NARROW: {
                type = "I";
                break;
            }
            case STRING: {
                type = "Ljava/lang/String;";
                break;
            }
            case WIDE: {
                if ("const-wide".equals(this.getName())) {
                    type = "D";
                    break;
                }
                type = "J";
                break;
            }
            default: {
                if (log.isWarnEnabled()) {
                    log.warn("Unexpected constant class (should never happen): {}", (Object)this.constantType);
                }
                type = "?";
            }
        }
        return type;
    }

    public static enum ConstantType {
        CLASS,
        NARROW,
        STRING,
        WIDE;

    }
}

