/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.lang.reflect.Array;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.UnknownValue;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayLengthOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(ArrayLengthOp.class.getSimpleName());
    private final int arrayRegister;
    private final int destRegister;

    ArrayLengthOp(MethodLocation location, MethodLocation child, int destRegister, int arrayRegister, ExceptionFactory exceptionFactory) {
        super(location, child);
        this.destRegister = destRegister;
        this.arrayRegister = arrayRegister;
        this.addException(exceptionFactory.build((Op)this, NullPointerException.class, "Attempt to get length of null array"));
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem arrayItem = mState.readRegister(this.arrayRegister);
        Object array = arrayItem.getValue();
        Object lengthValue = null;
        if (arrayItem.isUnknown()) {
            lengthValue = new UnknownValue();
        } else {
            if (array == null) {
                node.clearChildren();
                return;
            }
            if (array.getClass().isArray()) {
                lengthValue = Array.getLength(array);
                node.clearExceptions();
            } else if (log.isErrorEnabled()) {
                log.error("Unexpected non-array class: {}, {}", (Object)array.getClass(), array);
            }
        }
        mState.assignRegister(this.destRegister, lengthValue, "I");
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.destRegister + ", r" + this.arrayRegister;
    }
}

