/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.lang.reflect.Array;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGetOp
extends MethodStateOp {
    private static final Logger log = LoggerFactory.getLogger(AGetOp.class.getSimpleName());
    private final int valueRegister;
    private final int arrayRegister;
    private final int indexRegister;
    private final ExceptionFactory exceptionFactory;

    AGetOp(MethodLocation location, MethodLocation child, int valueRegister, int arrayRegister, int indexRegister, ExceptionFactory exceptionFactory) {
        super(location, child);
        this.valueRegister = valueRegister;
        this.arrayRegister = arrayRegister;
        this.indexRegister = indexRegister;
        this.exceptionFactory = exceptionFactory;
        this.addException(exceptionFactory.build((Op)this, NullPointerException.class));
        this.addException(exceptionFactory.build((Op)this, ArrayIndexOutOfBoundsException.class));
    }

    private static String getUnknownArrayInnerType(HeapItem array) {
        String outerType = array.getType();
        String result = "?".equals(outerType) ? "?" : outerType.replaceFirst("\\[", "");
        return result;
    }

    @Override
    public void execute(ExecutionNode node, MethodState mState) {
        HeapItem getItem;
        HeapItem arrayItem = mState.readRegister(this.arrayRegister);
        HeapItem indexItem = mState.readRegister(this.indexRegister);
        if (arrayItem.isUnknown()) {
            String innerType = AGetOp.getUnknownArrayInnerType(arrayItem);
            getItem = HeapItem.newUnknown(innerType);
        } else {
            Object array = arrayItem.getValue();
            if (indexItem.isUnknown()) {
                String innerType = arrayItem.getType().replaceFirst("\\[", "");
                getItem = HeapItem.newUnknown(innerType);
            } else {
                node.clearExceptions();
                if (null == array) {
                    Throwable exception = this.exceptionFactory.build((Op)this, NullPointerException.class);
                    node.setException(exception);
                    node.clearChildren();
                    return;
                }
                int index = indexItem.asInteger();
                String innerType = arrayItem.getType().replaceFirst("\\[", "");
                if (index >= Array.getLength(array)) {
                    Throwable exception = this.exceptionFactory.build((Op)this, ArrayIndexOutOfBoundsException.class);
                    node.setException(exception);
                    node.clearChildren();
                    return;
                }
                Object value = Array.get(array, index);
                getItem = new HeapItem(value, innerType);
                node.clearExceptions();
            }
        }
        mState.assignRegister(this.valueRegister, getItem);
    }

    @Override
    public String toString() {
        return this.getName() + " r" + this.valueRegister + ", r" + this.arrayRegister + ", r" + this.indexRegister;
    }
}

