/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.emulate;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.StaticFieldAccessor;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.emulate.ExecutionContextMethod;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.ClassNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class java_lang_reflect_Field_get
extends ExecutionContextMethod {
    private static final Logger log = LoggerFactory.getLogger(java_lang_reflect_Field_get.class.getSimpleName());

    java_lang_reflect_Field_get() {
    }

    @Override
    public void execute(VirtualMachine vm, Op op, ExecutionContext context) {
        ClassManager classManager;
        VirtualClass fieldClass;
        VirtualType callingClass;
        boolean hasAccess;
        MethodState mState = context.getMethodState();
        HeapItem fieldItem = mState.peekParameter(0);
        HeapItem instanceItem = mState.peekParameter(1);
        Field field = (Field)fieldItem.getValue();
        int accessFlags = field.getModifiers();
        String fieldClassName = ClassNameUtils.toInternal(field.getDeclaringClass());
        if (!field.isAccessible() && !(hasAccess = this.checkAccess(callingClass = context.getCallerContext().getMethod().getDefiningClass(), fieldClass = (classManager = vm.getClassManager()).getVirtualClass(fieldClassName), accessFlags, op, vm.getExceptionFactory()))) {
            return;
        }
        Object instance = instanceItem.getValue();
        HeapItem getItem = this.get(field, instance, fieldClassName, accessFlags, context, vm, op);
        mState.assignReturnRegister(getItem);
    }

    private boolean checkAccess(VirtualType callingClass, VirtualType fieldClass, int accessFlags, Op op, ExceptionFactory exceptionFactory) {
        boolean isPackagePrivate;
        boolean isPublic = Modifier.isPublic(accessFlags);
        if (isPublic) {
            return true;
        }
        if (callingClass.equals(fieldClass)) {
            return true;
        }
        if (callingClass.isInnerClassOf(fieldClass)) {
            return true;
        }
        boolean isPrivate = Modifier.isPrivate(accessFlags);
        boolean isProtected = Modifier.isProtected(accessFlags);
        boolean bl = isPackagePrivate = !isProtected && !isPrivate;
        if (isPrivate || isProtected && !callingClass.instanceOf(fieldClass) || isPackagePrivate && !callingClass.isSamePackageOf(fieldClass)) {
            String error = callingClass.getBinaryName() + " can't access a member of " + fieldClass.getBinaryName() + " with modifiers \"" + Modifier.toString(accessFlags) + "\"";
            Throwable exception = exceptionFactory.build(op, IllegalAccessException.class, error);
            this.setException(exception);
            return false;
        }
        return true;
    }

    private HeapItem get(Field field, Object instance, String className, int accessFlags, ExecutionContext context, VirtualMachine vm, Op op) {
        if (vm.getConfiguration().isSafe(className)) {
            return this.getSafeField(field, instance, context, op, vm.getExceptionFactory());
        }
        boolean isStatic = Modifier.isStatic(accessFlags);
        if (!isStatic) {
            String internalName = ClassNameUtils.toInternal(field.getType());
            return HeapItem.newUnknown(internalName);
        }
        return this.getVirtualField(field, vm, context);
    }

    private HeapItem getSafeField(Field field, Object instance, ExecutionContext context, Op op, ExceptionFactory exceptionFactory) {
        HeapItem item = null;
        try {
            Object getObject = field.get(instance);
            String type = ClassNameUtils.toInternal(field.getType());
            item = new HeapItem(getObject, type);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String message = e.getMessage();
            VirtualMethod callingMethod = context.getCallerContext().getMethod();
            VirtualType callingClass = callingMethod.getDefiningClass();
            message = message.replace(java_lang_reflect_Field_get.class.getName(), callingClass.getBinaryName());
            Throwable exception = exceptionFactory.build(op, e.getClass(), message);
            this.setException(exception);
        }
        return item;
    }

    private HeapItem getVirtualField(Field field, VirtualMachine vm, ExecutionContext context) {
        String className = ClassNameUtils.toInternal(field.getDeclaringClass());
        VirtualClass fieldClass = vm.getClassManager().getVirtualClass(className);
        VirtualField virtualField = fieldClass.getField(field.getName());
        StaticFieldAccessor accessor = vm.getStaticFieldAccessor();
        return accessor.getField(context, virtualField);
    }
}

