/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cf.smalivm.configuration.ConfigurationLoader;
import org.cf.smalivm.dex.SmaliFile;
import org.cf.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliFileFactory {
    private static final Logger log = LoggerFactory.getLogger(SmaliFileFactory.class.getSimpleName());
    private static Map<String, SmaliFile> frameworkClassNameToSmaliFile;

    private static synchronized void cacheFramework() {
        if (frameworkClassNameToSmaliFile != null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        frameworkClassNameToSmaliFile = SmaliFileFactory.parseFramework();
        if (log.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            log.debug("Cached {} framework classes in {} seconds.", (Object)frameworkClassNameToSmaliFile.size(), (Object)(totalTime / 1000L));
        }
    }

    private static Map<String, SmaliFile> parseFramework() {
        HashMap<String, SmaliFile> frameworkFiles = new HashMap<String, SmaliFile>();
        List<String> frameworkClassesCfg = ConfigurationLoader.load("framework_classes.cfg");
        HashSet<String> safeFrameworkClasses = new HashSet<String>(ConfigurationLoader.load("safe_framework_classes.cfg"));
        for (String line : frameworkClassesCfg) {
            String[] parts = line.split(":");
            String className = parts[0];
            String path = parts[1];
            SmaliFile smaliFile = new SmaliFile(path, className);
            smaliFile.setIsResource(true);
            smaliFile.setIsSafeFramework(safeFrameworkClasses.contains(className));
            frameworkFiles.put(smaliFile.getClassName(), smaliFile);
        }
        return frameworkFiles;
    }

    public Set<SmaliFile> getSmaliFiles(File file) {
        return this.getSmaliFiles(new File[]{file});
    }

    public Set<SmaliFile> getSmaliFiles(File[] files) {
        Set<SmaliFile> smaliFiles = this.getSmaliFiles();
        for (File file : files) {
            List<File> matches = Utils.getFilesWithSmaliExtension(file);
            matches.parallelStream().forEach(match -> {
                SmaliFile smaliFile = new SmaliFile((File)match);
                String className = smaliFile.getClassName();
                if (this.isFrameworkClass(className) && !className.startsWith("Landroid/support/")) {
                    log.warn("Input class '{}' has an earlier definition; ignoring", (Object)className);
                } else {
                    smaliFiles.add(smaliFile);
                }
            });
        }
        return smaliFiles;
    }

    public Set<SmaliFile> getSmaliFiles() {
        SmaliFileFactory.cacheFramework();
        HashSet<SmaliFile> smaliFiles = new HashSet<SmaliFile>();
        smaliFiles.addAll(frameworkClassNameToSmaliFile.values());
        return smaliFiles;
    }

    public boolean isFrameworkClass(String className) {
        return frameworkClassNameToSmaliFile.containsKey(className);
    }

    public Set<SmaliFile> getSmaliFiles(String path) {
        return this.getSmaliFiles(new String[]{path});
    }

    public Set<SmaliFile> getSmaliFiles(String[] paths) {
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
        }
        return this.getSmaliFiles(files);
    }

    public boolean isSafeFrameworkClass(String className) {
        SmaliFile smaliFile = frameworkClassNameToSmaliFile.get(className);
        return null != smaliFile && smaliFile.isSafeFrameworkClass();
    }
}

