/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.cf.smalivm.dex.ClassBuilder;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.ClassManagerFactory;
import org.cf.smalivm.type.VirtualClass;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(SmaliClassLoader.class.getSimpleName());
    public static final String FRAMEWORK_STUBS_JAR = "/framework/android-framework.jar";
    private final Map<String, Class<?>> cachedClasses = new HashMap();
    private final ClassBuilder classBuilder;
    private final ClassManager classManager;

    public SmaliClassLoader(ClassManager classManager) {
        super(new URL[]{SmaliClassLoader.class.getResource(FRAMEWORK_STUBS_JAR)});
        this.classBuilder = new ClassBuilder(classManager);
        this.classManager = classManager;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String smaliPath = args[0];
        String className = args[1];
        ClassManager classManager = new ClassManagerFactory().build(smaliPath);
        VirtualClass virtualClass = classManager.getVirtualClass(className);
        SmaliClassLoader classLoader = new SmaliClassLoader(classManager);
        Class<?> klazz = classLoader.loadClass(virtualClass.getSourceName());
    }

    private static String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i > 0) {
            return className.substring(0, i);
        }
        return null;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String internalName = ClassNameUtils.binaryToInternal(name);
        if (this.classManager.getFrameworkClassNames().contains(internalName)) {
            Class<?> klazz = this.cachedClasses.get(name);
            if (klazz != null) {
                return klazz;
            }
            klazz = this.findClass(name);
            this.cachedClasses.put(name, klazz);
            return klazz;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.")) {
            try {
                return super.loadClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.warn("Unable to build and load prohibited class name: {}\nThis error is likely the result of using a class which references a java.* class only available on Android. There's no work-around at this time since loading protected classes is a huge pain.", (Object)name);
                throw new ClassNotFoundException(name);
            }
        }
        Class<?> klazz = this.cachedClasses.get(name);
        if (klazz != null) {
            return klazz;
        }
        try {
            klazz = super.findClass(name);
            this.cachedClasses.put(name, klazz);
            return klazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String internalName = ClassNameUtils.binaryToInternal(name);
            if (!this.classManager.getClassNames().contains(internalName)) {
                throw new ClassNotFoundException(name);
            }
            VirtualClass virtualClass = this.classManager.getVirtualClass(internalName);
            BuilderClassDef classDef = virtualClass.getClassDef();
            byte[] b = this.classBuilder.build(classDef);
            klazz = this.defineClass(name, b, 0, b.length);
            this.cachedClasses.put(name, klazz);
            String packageName = SmaliClassLoader.getPackageName(name);
            if (packageName != null && this.getPackage(packageName) == null) {
                this.definePackage(SmaliClassLoader.getPackageName(name), null, null, null, null, null, null, null);
            }
            return klazz;
        }
    }
}

