/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.dex;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.cf.smalivm.dex.ClassBuilder;
import org.cf.smalivm.dex.SmaliParser;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.ClassManagerFactory;
import org.cf.smalivm.type.VirtualClass;
import org.cf.util.Utils;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.DexBuilder;

public class FrameworkJarBuilder {
    private static final String FRAMEWORK_ROOT = "/framework/smali";

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: frameworkJarBuilder <framework resource path (e.g. android-25)> <output jar path>");
            System.exit(-1);
        }
        String resPath = "/framework/smali/" + args[0];
        System.out.println("Building framework cache from " + resPath);
        String cache = FrameworkJarBuilder.buildFrameworkCache(resPath);
        String cacheFileName = "src/main/resources/framework_classes.cfg";
        Files.asCharSink(new File(cacheFileName), Charset.forName("UTF-8"), new FileWriteMode[0]).write(cache);
        System.out.println("Saved cache to " + cacheFileName + " (" + cache.getBytes().length + " bytes)");
        String outPath = args[1];
        System.out.println("Building framework JAR");
        ClassManager classManager = new ClassManagerFactory().build();
        ClassBuilder builder = new ClassBuilder(classManager);
        Set<String> classNames = FrameworkJarBuilder.buildJar(classManager, builder, outPath);
        System.out.println("Saved " + classNames.size() + " classes to " + outPath);
    }

    private static String buildFrameworkCache(String resPath) throws Exception {
        LinkedList<File> resFiles = new LinkedList<File>();
        try {
            URL url = FrameworkJarBuilder.class.getResource(resPath);
            File file = new File(url.toURI());
            resFiles.addAll(Utils.getFilesWithSmaliExtension(file));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        DexBuilder dexBuilder = new DexBuilder(Opcodes.getDefault());
        StringBuilder sb = new StringBuilder();
        for (File resFile : resFiles) {
            String absPath = resFile.getAbsolutePath();
            String path = absPath.substring(absPath.lastIndexOf(FRAMEWORK_ROOT));
            InputStream is = FrameworkJarBuilder.class.getResourceAsStream(path);
            BuilderClassDef classDef = SmaliParser.parse(path, is, dexBuilder);
            sb.append(ReferenceUtil.getReferenceString(classDef));
            sb.append(':').append(path.substring(1)).append('\n');
        }
        return sb.toString();
    }

    private static Set<String> buildJar(ClassManager classManager, ClassBuilder builder, String outPath) throws IOException {
        Set<String> classNames = classManager.getFrameworkClassNames();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(outPath));
        for (String className : classNames) {
            VirtualClass virtualClass = classManager.getVirtualClass(className);
            BuilderClassDef classDef = virtualClass.getClassDef();
            byte[] b = builder.build(classDef);
            String entryName = className.substring(1, className.length() - 1);
            out.putNextEntry(new ZipEntry(entryName + ".class"));
            out.write(b);
            out.closeEntry();
        }
        out.close();
        return classNames;
    }
}

