/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import com.rits.cloning.Cloner;
import com.rits.cloning.ObjenesisInstantiationStrategy;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.cf.smalivm.configuration.Configuration;
import org.cf.smalivm.type.UnknownValue;
import org.cf.util.ClassNameUtils;
import org.cf.util.Utils;

public class HeapItem {
    private static final Cloner cloner = new Cloner(new ObjenesisInstantiationStrategy());
    private String type;
    private Object value;

    public HeapItem(Object value, String type) {
        this.value = value;
        this.type = type.intern();
    }

    public HeapItem(Object value) {
        this(value, ClassNameUtils.toInternal(value.getClass()));
    }

    HeapItem(HeapItem other) {
        this.value = cloner.deepClone(other.getValue());
        this.type = other.getType();
    }

    public static HeapItem newUnknown(String type) {
        return new HeapItem(new UnknownValue(), type);
    }

    public double asDouble() {
        return Utils.getDoubleValue(this.getValue());
    }

    public float asFloat() {
        return Utils.getFloatValue(this.getValue()).floatValue();
    }

    public int asInteger() {
        return Utils.getIntegerValue(this.getValue());
    }

    public long asLong() {
        return Utils.getLongValue(this.getValue());
    }

    public String getComponentBase() {
        return ClassNameUtils.getComponentBase(this.getType());
    }

    public String getType() {
        return this.type;
    }

    public String getUnboxedType() {
        String unboxedType = ClassNameUtils.getPrimitive(this.type);
        if (unboxedType == null) {
            unboxedType = this.type;
        }
        return unboxedType;
    }

    public String getUnboxedValueType() {
        String valueType = this.getValueType();
        String unboxedType = ClassNameUtils.getPrimitive(valueType);
        if (unboxedType == null) {
            unboxedType = valueType;
        }
        return unboxedType;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public String getValueType() {
        return ClassNameUtils.toInternal(this.getValue().getClass());
    }

    public int hashCode() {
        return new HashCodeBuilder(123, 51).append(this.getType()).append(this.getValue()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HeapItem rhs = (HeapItem)obj;
        return new EqualsBuilder().append(this.getType(), rhs.getType()).append(this.getValue(), rhs.getValue()).isEquals();
    }

    public String toString() {
        Object value = this.getValue();
        StringBuilder sb = new StringBuilder("type=");
        sb.append(this.getType()).append(", value=");
        if (value == null) {
            sb.append("null");
        } else if (value.getClass().isArray()) {
            Object[] objArray;
            if (value.getClass().getComponentType().isPrimitive()) {
                int arrayLen = Array.getLength(value);
                objArray = new Object[arrayLen];
                for (int i = 0; i < arrayLen; ++i) {
                    objArray[i] = Array.get(value, i);
                }
            } else {
                objArray = (Object[])value;
            }
            String arrayString = Arrays.deepToString(objArray);
            sb.append(arrayString);
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public boolean isImmutable() {
        return Configuration.instance().isImmutable(this.getType());
    }

    @Nonnull
    public boolean isNull() {
        return this.getValue() == null;
    }

    public boolean isObject() {
        return ClassNameUtils.isObject(this.getType());
    }

    public boolean isPrimitive() {
        return ClassNameUtils.isPrimitive(this.getType());
    }

    public boolean isPrimitiveOrWrapper() {
        return ClassNameUtils.isPrimitiveOrWrapper(this.getType());
    }

    public boolean isPrimitiveWrapper() {
        return ClassNameUtils.isWrapper(this.getType());
    }

    public boolean isUnknown() {
        return this.getValue() instanceof UnknownValue;
    }

    public boolean isKnown() {
        return !this.isUnknown();
    }

    public boolean valueIdentity(HeapItem other) {
        return this.getValue() == other.getValue();
    }
}

