/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.ExecutionContextOp;
import org.cf.smalivm.opcode.MethodStateOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.VirtualMethod;
import org.jf.dexlib2.builder.MethodLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionNode {
    private static Logger log = LoggerFactory.getLogger(ExecutionNode.class.getSimpleName());
    private final List<ExecutionNode> children;
    private Op op;
    private ExecutionContext context;
    private ExecutionNode parent;
    private Set<Throwable> exceptions;
    private MethodLocation[] childLocations;

    public ExecutionNode(ExecutionNode other) {
        this.op = other.op;
        this.children = new ArrayList<ExecutionNode>(other.getChildren());
    }

    public ExecutionNode(Op op) {
        this.op = op;
        this.children = new ArrayList<ExecutionNode>(op.getChildren().length);
    }

    public void clearChildren() {
        this.setChildLocations(new MethodLocation[0]);
    }

    public void clearExceptions() {
        this.exceptions = new HashSet<Throwable>();
    }

    public void execute() {
        ExecutionContext context = this.getContext();
        if (this.op instanceof MethodStateOp) {
            MethodState mState = context.getMethodState();
            ((MethodStateOp)this.op).execute(this, mState);
        } else {
            ((ExecutionContextOp)this.op).execute(this, context);
        }
        if (this.childLocations == null) {
            this.setChildLocations(this.op.getChildren());
        }
        if (this.exceptions == null) {
            this.setExceptions(this.op.getExceptions());
        }
    }

    public int getAddress() {
        return this.op.getAddress();
    }

    public int getIndex() {
        return this.op.getIndex();
    }

    public VirtualMethod getMethod() {
        return this.context.getMethod();
    }

    public int getCallDepth() {
        return this.context.getCallDepth();
    }

    public MethodLocation[] getChildLocations() {
        return this.childLocations;
    }

    public void setChildLocations(MethodLocation ... childLocations) {
        this.childLocations = childLocations;
    }

    public List<ExecutionNode> getChildren() {
        return this.children;
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public Set<Throwable> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(Set<Throwable> exceptions) {
        this.exceptions = exceptions;
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public ExecutionNode getParent() {
        return this.parent;
    }

    public void setParent(@Nonnull ExecutionNode parent) {
        this.parent = parent;
        parent.addChild(this);
        this.getContext().setParent(parent.getContext());
    }

    public boolean mayThrowException() {
        return this.exceptions != null && this.exceptions.size() > 0;
    }

    public void removeChild(ExecutionNode child) {
        this.children.remove(child);
        this.rebuildChildLocationsFromChildren();
    }

    public void replaceChild(ExecutionNode oldChild, ExecutionNode newChild) {
        this.removeChild(oldChild);
        newChild.setParent(this);
    }

    public void setException(Throwable exception) {
        this.exceptions = new HashSet<Throwable>();
        this.exceptions.add(exception);
    }

    public void setMethodState(MethodState mState) {
        this.context.setMethodState(mState);
    }

    public ExecutionNode spawnChild(Op childOp) {
        ExecutionNode child = new ExecutionNode(childOp);
        child.setContext(this.context.spawnChild());
        child.setParent(this);
        return child;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExecutionNode{");
        if (this.context != null) {
            sb.append("signature=").append(this.context.getMethod()).append(", ");
        }
        sb.append("op=").append(this.op.toString()).append(", ");
        sb.append("@=").append(this.op.getAddress()).append('}');
        return sb.toString();
    }

    private void addChild(ExecutionNode child) {
        this.children.add(child);
        this.rebuildChildLocationsFromChildren();
    }

    private void rebuildChildLocationsFromChildren() {
        this.childLocations = new MethodLocation[this.children.size()];
        for (int i = 0; i < this.childLocations.length; ++i) {
            this.childLocations[i] = this.children.get(i).getOp().getLocation();
        }
    }
}

