/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import java.util.ArrayList;
import java.util.List;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.MethodState;

public class ExecutionGrapher {
    private static final String DOT = "[^a-zA-Z\u0080-\u00ff_0-9\\s\\p{Punct}]";

    public static String graph(ExecutionGraph graph) {
        ExecutionNode node = graph.getRoot();
        StringBuilder sb = new StringBuilder("digraph {\n");
        ExecutionGrapher.getGraph(node, graph, sb, new ArrayList<ExecutionNode>());
        sb.append("labelloc=\"t\"\n");
        sb.append("label=\"").append(graph.getMethod()).append("\";\n");
        sb.append('}');
        return sb.toString();
    }

    private static void getGraph(ExecutionNode node, ExecutionGraph graph, StringBuilder sb, List<ExecutionNode> visitedNodes) {
        if (visitedNodes.contains(node)) {
            return;
        }
        visitedNodes.add(node);
        StringBuilder nodeState = ExecutionGrapher.getNodeState(node, graph);
        for (ExecutionNode child : node.getChildren()) {
            sb.append((CharSequence)nodeState).append(" -> ").append((CharSequence)ExecutionGrapher.getNodeState(child, graph)).append('\n');
            ExecutionGrapher.getGraph(child, graph, sb, visitedNodes);
        }
    }

    private static StringBuilder getNodeState(ExecutionNode node, ExecutionGraph graph) {
        MethodState state = node.getContext().getMethodState();
        String op = node.toString().replaceAll(DOT, "?").replace("\"", "\\\"");
        String stateStr = state.toString().replaceAll(DOT, "?").replace("\"", "\\\"").trim();
        int nodeIndex = graph.getNodeIndex(node);
        StringBuilder sb = new StringBuilder();
        sb.append("\"@").append(node.getAddress()).append('.').append(nodeIndex).append(" :: ");
        sb.append(op).append('\n').append(stateStr).append('\"');
        return sb;
    }
}

