/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionGraphIterator;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.opcode.OpCreator;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionGraph
implements Iterable<ExecutionNode> {
    protected static final int TEMPLATE_NODE_INDEX = 0;
    protected static final int METHOD_ROOT_ADDRESS = 0;
    private static final Logger log = LoggerFactory.getLogger(ExecutionGraph.class.getSimpleName());
    protected final Map<MethodLocation, List<ExecutionNode>> locationToNodePile;
    protected final TIntObjectMap<MethodLocation> addressToLocation;
    private final VirtualMachine vm;
    private final VirtualMethod method;
    private final int[] terminatingAddresses;

    public ExecutionGraph(ExecutionGraph other) {
        this.method = other.method;
        this.locationToNodePile = new HashMap<MethodLocation, List<ExecutionNode>>();
        for (MethodLocation location : other.locationToNodePile.keySet()) {
            List<ExecutionNode> otherNodePile = other.locationToNodePile.get(location);
            ArrayList nodePile = new ArrayList(otherNodePile.size());
            nodePile.addAll(otherNodePile.stream().map(ExecutionNode::new).collect(Collectors.toList()));
            this.locationToNodePile.put(location, nodePile);
        }
        this.terminatingAddresses = other.terminatingAddresses;
        this.addressToLocation = other.addressToLocation;
        this.vm = other.vm;
    }

    public ExecutionGraph(ExecutionGraph other, boolean wrap) {
        this.method = other.method;
        this.locationToNodePile = other.locationToNodePile;
        this.terminatingAddresses = other.terminatingAddresses;
        this.addressToLocation = other.addressToLocation;
        this.vm = other.vm;
    }

    public ExecutionGraph(VirtualMachine vm, VirtualMethod method) {
        this.method = method;
        MutableMethodImplementation implementation = method.getImplementation();
        this.addressToLocation = ExecutionGraph.buildAddressToLocation(implementation);
        this.locationToNodePile = ExecutionGraph.buildLocationToNodePile(vm, this.addressToLocation);
        Iterable instructions = implementation.getInstructions();
        this.terminatingAddresses = ExecutionGraph.buildTerminatingAddresses((List<BuilderInstruction>)instructions);
        this.vm = vm;
    }

    protected static TIntObjectMap<MethodLocation> buildAddressToLocation(MutableMethodImplementation implementation) {
        Iterable instructions = implementation.getInstructions();
        TIntObjectHashMap<MethodLocation> addressToLocation = new TIntObjectHashMap<MethodLocation>(instructions.size());
        for (BuilderInstruction instruction : instructions) {
            MethodLocation location = instruction.getLocation();
            int address = location.getCodeAddress();
            addressToLocation.put(address, location);
        }
        return addressToLocation;
    }

    protected static OpCreator getOpCreator(VirtualMachine vm, TIntObjectMap<MethodLocation> addressToLocation) {
        return new OpCreator(vm, addressToLocation);
    }

    private static Map<MethodLocation, List<ExecutionNode>> buildLocationToNodePile(VirtualMachine vm, TIntObjectMap<MethodLocation> addressToLocation) {
        OpCreator opCreator = ExecutionGraph.getOpCreator(vm, addressToLocation);
        HashMap<MethodLocation, List<ExecutionNode>> locationToNodePile = new HashMap<MethodLocation, List<ExecutionNode>>();
        for (MethodLocation location : addressToLocation.values((MethodLocation[])new MethodLocation[addressToLocation.size()])) {
            Op op = opCreator.create(location);
            ExecutionNode node = new ExecutionNode(op);
            ArrayList<ExecutionNode> pile = new ArrayList<ExecutionNode>(2);
            pile.add(node);
            locationToNodePile.put(location, pile);
        }
        return locationToNodePile;
    }

    private static int[] buildTerminatingAddresses(List<BuilderInstruction> instructions) {
        TIntLinkedList addresses = new TIntLinkedList();
        block3: for (BuilderInstruction instruction : instructions) {
            int address = instruction.getLocation().getCodeAddress();
            Opcode op = instruction.getOpcode();
            switch (op) {
                case RETURN_VOID: 
                case RETURN: 
                case RETURN_WIDE: 
                case RETURN_OBJECT: 
                case THROW: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            addresses.add(address);
        }
        return addresses.toArray();
    }

    private static void collapseTypeHierarchies(Set<String> types, ClassManager classManager) {
        LinkedList<VirtualType> typeList = new LinkedList<VirtualType>();
        for (String type : types) {
            typeList.add(classManager.getVirtualType(type));
        }
        block1: for (int index = 0; index < typeList.size(); ++index) {
            VirtualType currentType = (VirtualType)typeList.get(index);
            for (int i = 0; i < typeList.size(); ++i) {
                VirtualType compareType;
                if (i == index || !currentType.isChildOf(compareType = (VirtualType)typeList.get(i))) continue;
                types.remove(currentType.getName());
                continue block1;
            }
        }
    }

    private String getConsensusType(Set<String> types, Set<HeapItem> items) {
        if (types.size() == 1) {
            return types.toArray(new String[1])[0];
        }
        int newAncestors = 0;
        do {
            ClassManager classManager = this.vm.getClassManager();
            ExecutionGraph.collapseTypeHierarchies(types, classManager);
            if (types.size() == 1) {
                return types.toArray(new String[1])[0];
            }
            if (types.size() == 2 && types.contains("I")) {
                for (String currentType : types) {
                    if (!currentType.startsWith("L") || !items.contains(new HeapItem(0, "I"))) continue;
                    return currentType;
                }
            }
            HashSet<String> newTypes = new HashSet<String>();
            for (String type : types) {
                VirtualType virtualType = classManager.getVirtualType(type);
                for (VirtualType virtualType2 : virtualType.getImmediateAncestors()) {
                    newTypes.add(virtualType2.getName());
                }
            }
            types.addAll(newTypes);
            newAncestors = newTypes.size();
            ExecutionGraph.collapseTypeHierarchies(types, classManager);
        } while (newAncestors > 0);
        return "?";
    }

    public String toString() {
        return "ExecutionGraph{" + this.method + "}";
    }

    public void addNode(ExecutionNode node) {
        MethodLocation location = node.getOp().getInstruction().getLocation();
        this.locationToNodePile.get(location).add(node);
    }

    public int[] getAddresses() {
        int[] addresses = this.addressToLocation.keys();
        Arrays.sort(addresses);
        return addresses;
    }

    public Set<VirtualType> getAllPossiblyInitializedClasses(int[] addresses) {
        HashSet<VirtualType> allClasses = new HashSet<VirtualType>();
        for (int address : addresses) {
            List<ExecutionNode> pile = this.getNodePile(address);
            for (ExecutionNode node : pile) {
                allClasses.addAll(node.getContext().getInitializedClasses());
            }
        }
        return allClasses;
    }

    public int[] getConnectedTerminatingAddresses() {
        TIntLinkedList addresses = new TIntLinkedList();
        for (int address : this.terminatingAddresses) {
            if (!this.wasAddressReached(address)) continue;
            addresses.add(address);
        }
        return addresses.toArray();
    }

    public HeapItem getFieldConsensus(int[] addresses, VirtualField field) {
        VirtualType virtualClass = field.getDefiningClass();
        HashSet<HeapItem> items = new HashSet<HeapItem>();
        for (int address : addresses) {
            for (ExecutionNode node : this.getNodePile(address)) {
                if (node.getContext().isClassInitialized(virtualClass)) continue;
                String type = field.getType();
                return HeapItem.newUnknown(type);
            }
            items.addAll(this.getFieldItems(address, field));
            if (1 == items.size()) continue;
            if (log.isTraceEnabled()) {
                log.trace("No consensus for {}, returning Unknown.", (Object)field);
            }
            return HeapItem.newUnknown(field.getType());
        }
        return items.toArray(new HeapItem[items.size()])[0];
    }

    public Set<HeapItem> getFieldItems(int address, VirtualField field) {
        List<ExecutionNode> nodePile = this.getNodePile(address);
        HashSet<HeapItem> items = new HashSet<HeapItem>(nodePile.size());
        for (ExecutionNode node : nodePile) {
            ExecutionContext context = node.getContext();
            ClassState cState = context.peekClassState(field.getDefiningClass());
            HeapItem item = cState.peekField(field);
            items.add(item);
        }
        return items;
    }

    public SideEffect.Level getHighestClassSideEffectLevel(VirtualType virtualClass) {
        int[] addresses = this.getConnectedTerminatingAddresses();
        SideEffect.Level result = SideEffect.Level.NONE;
        for (int address : addresses) {
            List<ExecutionNode> pile = this.getNodePile(address);
            for (ExecutionNode node : pile) {
                SideEffect.Level level = node.getContext().getClassSideEffectLevel(virtualClass);
                if (level == null) continue;
                switch (level) {
                    case STRONG: {
                        return level;
                    }
                    case WEAK: {
                        result = level;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public SideEffect.Level getHighestMethodSideEffectLevel() {
        SideEffect.Level result = SideEffect.Level.NONE;
        for (ExecutionNode node : this) {
            Op op = node.getOp();
            SideEffect.Level level = op.getSideEffectLevel();
            switch (level) {
                case STRONG: {
                    return level;
                }
                case WEAK: {
                    result = level;
                    break;
                }
            }
        }
        return result;
    }

    public SideEffect.Level getHighestSideEffectLevel() {
        SideEffect.Level result = this.getHighestMethodSideEffectLevel();
        if (result == SideEffect.Level.STRONG) {
            return result;
        }
        int[] addresses = this.getConnectedTerminatingAddresses();
        Set<VirtualType> allClasses = this.getAllPossiblyInitializedClasses(addresses);
        for (VirtualType virtualClass : allClasses) {
            SideEffect.Level level = this.getHighestClassSideEffectLevel(virtualClass);
            switch (level) {
                case STRONG: {
                    return level;
                }
                case WEAK: {
                    result = level;
                    break;
                }
            }
        }
        return result;
    }

    public Collection<MethodLocation> getLocations() {
        return this.addressToLocation.valueCollection();
    }

    public VirtualMethod getMethod() {
        return this.method;
    }

    public int getNodeCount() {
        int totalSize = this.locationToNodePile.size();
        int templateCount = this.locationToNodePile.keySet().size();
        return totalSize - templateCount;
    }

    public List<ExecutionNode> getNodePile(int address) {
        List<ExecutionNode> nodePile = this.getNodePileByAddress(address);
        nodePile = nodePile.subList(1, nodePile.size());
        return nodePile;
    }

    @Nullable
    public Op getOp(int address) {
        return this.getTemplateNode(address).getOp();
    }

    public HeapItem getRegisterConsensus(int address, int register) {
        return this.getRegisterConsensus(new int[]{address}, register);
    }

    @Nullable
    public HeapItem getRegisterConsensus(int[] addresses, int register) {
        HashSet<HeapItem> items = new HashSet<HeapItem>();
        for (int address : addresses) {
            items.addAll(this.getRegisterItems(address, register));
        }
        if (items.size() == 1) {
            return items.toArray(new HeapItem[1])[0];
        }
        log.trace("No consensus value for register {}; returning UnknownValue", (Object)register);
        HashSet<String> types = new HashSet<String>(items.size());
        for (HeapItem item : items) {
            if (item == null) continue;
            types.add(item.getType());
        }
        if (types.size() == 0) {
            log.warn("No types for consensus; using *unknown* type! method={}, addresses={}, register={}", this.getMethod().getSignature(), addresses, register, types);
            return HeapItem.newUnknown("?");
        }
        String type = this.getConsensusType(types, items);
        if (type.equals("?")) {
            if (register == -2) {
                log.warn("Strange: No consensus type for return register; using method return type, method={}, addresses={}, register={}, types={}", this.getMethod().getSignature(), addresses, register, types);
                type = this.method.getReturnType();
            } else {
                log.warn("No consensus type; using *unknown* type! method={}, addresses={}, register={}, types={}", this.getMethod().getSignature(), addresses, register, types);
            }
        }
        return HeapItem.newUnknown(type);
    }

    public Object getRegisterConsensusValue(int address, int register) {
        HeapItem item = this.getRegisterConsensus(address, register);
        return item.getValue();
    }

    @Nullable
    public Object getRegisterConsensusValue(int[] addresses, int register) {
        HeapItem item = this.getRegisterConsensus(addresses, register);
        return item.getValue();
    }

    public Set<HeapItem> getRegisterItems(int address, int register) {
        List<ExecutionNode> nodePile = this.getNodePile(address);
        HashSet<HeapItem> items = new HashSet<HeapItem>(nodePile.size());
        for (ExecutionNode node : nodePile) {
            MethodState mState = node.getContext().getMethodState();
            HeapItem item = mState.peekRegister(register);
            items.add(item);
        }
        return items;
    }

    public ExecutionNode getRoot() {
        boolean nodePileInitialized;
        List<ExecutionNode> pile = this.getNodePileByAddress(0);
        boolean bl = nodePileInitialized = pile.size() > 1;
        if (nodePileInitialized) {
            return pile.get(1);
        }
        return pile.get(0);
    }

    @Nullable
    public ExecutionNode getTemplateNode(int address) {
        List<ExecutionNode> nodePile = this.getNodePileByAddress(address);
        return nodePile.get(0);
    }

    public int[] getTerminatingAddresses() {
        return this.terminatingAddresses;
    }

    public List<ExecutionContext> getTerminatingContexts() {
        int[] addresses;
        LinkedList<ExecutionContext> contexts = new LinkedList<ExecutionContext>();
        for (int address : addresses = this.getConnectedTerminatingAddresses()) {
            contexts.addAll(this.getNodePile(address).stream().map(ExecutionNode::getContext).collect(Collectors.toList()));
        }
        return contexts;
    }

    public HeapItem getTerminatingFieldConsensus(VirtualField field) {
        Map<VirtualField, HeapItem> items = this.getTerminatingFieldConsensus(new VirtualField[]{field});
        return items.get(field);
    }

    public Map<VirtualField, HeapItem> getTerminatingFieldConsensus(VirtualField[] fields) {
        int[] addresses = this.getConnectedTerminatingAddresses();
        HashMap<VirtualField, HeapItem> result = new HashMap<VirtualField, HeapItem>();
        for (VirtualField field : fields) {
            HeapItem item = this.getFieldConsensus(addresses, field);
            result.put(field, item);
        }
        return result;
    }

    @Nullable
    public HeapItem getTerminatingRegisterConsensus(int register) {
        Map<Integer, HeapItem> items = this.getTerminatingRegisterConsensus(new int[]{register});
        return items.get(register);
    }

    @Nullable
    public Map<Integer, HeapItem> getTerminatingRegisterConsensus(int[] registers) {
        int[] addresses = this.getConnectedTerminatingAddresses();
        HashMap<Integer, HeapItem> result = new HashMap<Integer, HeapItem>(registers.length);
        for (int register : registers) {
            HeapItem item = this.getRegisterConsensus(addresses, register);
            result.put(register, item);
        }
        return result;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    @Override
    public Iterator<ExecutionNode> iterator() {
        return new ExecutionGraphIterator(this);
    }

    public boolean wasAddressReached(int address) {
        if (0 == address) {
            return true;
        }
        List<ExecutionNode> nodePile = this.getNodePileByAddress(address);
        if (nodePile == null || 1 > nodePile.size()) {
            log.warn("Node pile @{} has no template node.", (Object)address);
            return false;
        }
        return nodePile.size() > 1;
    }

    public String toSmali() {
        return this.toSmali(false);
    }

    public String toSmali(boolean includeAddress) {
        int[] addresses = this.getAddresses();
        StringBuilder sb = new StringBuilder();
        for (int address : addresses) {
            Op op = this.getOp(address);
            sb.append(op.toString());
            if (includeAddress) {
                sb.append(" # @").append(address);
            }
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected int getNodeIndex(ExecutionNode node) {
        return this.getNodePile(node.getAddress()).indexOf(node);
    }

    @Nullable
    private List<ExecutionNode> getNodePileByAddress(int address) {
        MethodLocation location = this.addressToLocation.get(address);
        return this.locationToNodePile.get(location);
    }
}

