/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.context;

import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import java.util.LinkedList;
import java.util.List;

public class CallStack {
    private List<String> methodStack;
    private TIntList addressStack;

    CallStack() {
        this.methodStack = new LinkedList<String>();
        this.addressStack = new TIntLinkedList();
    }

    CallStack(String methodDescriptor, int address) {
        this();
        this.push(methodDescriptor, address);
    }

    CallStack(CallStack callerStack) {
        this.methodStack = new LinkedList<String>(callerStack.methodStack);
        this.addressStack = new TIntLinkedList(callerStack.addressStack);
    }

    void push(String methodDescriptor, int address) {
        this.methodStack.add(methodDescriptor);
        this.addressStack.add(address);
    }

    String peekMethodDescriptor() {
        return this.methodStack.get(this.size() - 1);
    }

    int size() {
        return this.methodStack.size();
    }

    void pokeAddress(int address) {
        this.addressStack.set(this.size() - 1, address);
    }
}

