/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.cf.smalivm.ExceptionFactory;
import org.cf.smalivm.MethodExecutor;
import org.cf.smalivm.MethodExecutorFactory;
import org.cf.smalivm.StaticFieldAccessor;
import org.cf.smalivm.TemplateStateFactory;
import org.cf.smalivm.configuration.Configuration;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.dex.SmaliClassLoader;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualMachine {
    private static final Logger log = LoggerFactory.getLogger(VirtualMachine.class.getSimpleName());
    private final ClassManager classManager;
    private final MethodExecutorFactory methodExecutorFactory;
    private final SmaliClassLoader classLoader;
    private final Map<VirtualMethod, ExecutionGraph> methodToTemplateExecutionGraph;
    private final StaticFieldAccessor staticFieldAccessor;
    private final Configuration configuration;
    private final ExceptionFactory exceptionFactory;

    VirtualMachine(ClassManager manager, int maxAddressVisits, int maxCallDepth, int maxMethodVisits, int maxExecutionTime) {
        this.classManager = manager;
        this.methodExecutorFactory = new MethodExecutorFactory(this).setMaxAddressVisits(maxAddressVisits).setMaxCallDepth(maxCallDepth).setMaxMethodVisits(maxMethodVisits).setMaxExecutionTime(maxExecutionTime);
        this.classLoader = new SmaliClassLoader(this.classManager);
        this.methodToTemplateExecutionGraph = new HashMap<VirtualMethod, ExecutionGraph>();
        this.staticFieldAccessor = new StaticFieldAccessor(this);
        this.configuration = Configuration.instance();
        this.exceptionFactory = new ExceptionFactory(this);
    }

    public ExecutionGraph execute(String methodSignature) throws VirtualMachineException {
        VirtualMethod method = this.classManager.getMethod(methodSignature);
        if (method == null) {
            throw new RuntimeException("Method signature not found: " + methodSignature);
        }
        return this.execute(method);
    }

    public ExecutionGraph execute(String className, String methodDescriptor) throws VirtualMachineException {
        return this.execute(className + "->" + methodDescriptor);
    }

    public ExecutionGraph execute(VirtualMethod virtualMethod) throws VirtualMachineException {
        ExecutionContext calleeContext = this.spawnRootContext(virtualMethod);
        return this.execute(calleeContext);
    }

    public ExecutionGraph execute(ExecutionContext context) throws VirtualMachineException {
        return this.execute(context, null, null);
    }

    public ExecutionGraph execute(ExecutionContext calleeContext, ExecutionContext callerContext, int[] parameterRegisters) throws VirtualMachineException {
        VirtualMethod virtualMethod = calleeContext.getMethod();
        if (virtualMethod == null) {
            throw new RuntimeException("Method not found: " + virtualMethod);
        }
        if (!virtualMethod.hasImplementation()) {
            log.warn("Attempting to execute method without implementation: {}", (Object)virtualMethod);
            return null;
        }
        MethodExecutor methodExecutor = this.methodExecutorFactory.build(calleeContext, callerContext);
        methodExecutor.execute();
        return this.finishExecution(methodExecutor, callerContext, parameterRegisters);
    }

    private ExecutionGraph finishExecution(MethodExecutor methodExecutor, ExecutionContext callerContext, int[] parameterRegisters) {
        if (methodExecutor.getExecutionGraph() != null && callerContext != null) {
            this.collapseMultiverse(methodExecutor.getVirtualMethod(), methodExecutor.getExecutionGraph(), callerContext, parameterRegisters);
        }
        return methodExecutor.getExecutionGraph();
    }

    public MethodExecutor startDebug(ExecutionContext calleeContext, ExecutionContext callerContext) {
        VirtualMethod virtualMethod = calleeContext.getMethod();
        if (!virtualMethod.hasImplementation()) {
            log.warn("Attempting to execute method without implementation: {}", (Object)virtualMethod);
            return null;
        }
        return this.methodExecutorFactory.build(calleeContext, callerContext);
    }

    public ExecutionGraph finishDebug(MethodExecutor methodExecutor, ExecutionContext callerContext, int[] parameterRegisters) {
        return this.finishExecution(methodExecutor, callerContext, parameterRegisters);
    }

    public SmaliClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public StaticFieldAccessor getStaticFieldAccessor() {
        return this.staticFieldAccessor;
    }

    public boolean isSafe(VirtualType virtualClass) {
        return this.getConfiguration().isSafe(virtualClass.toString());
    }

    public ExecutionGraph spawnInstructionGraph(String className, String methodDescriptor) {
        VirtualMethod method = this.getClassManager().getVirtualClass(className).getMethod(methodDescriptor);
        return this.spawnInstructionGraph(method);
    }

    public ExecutionGraph spawnInstructionGraph(VirtualMethod method) {
        if (!this.methodToTemplateExecutionGraph.containsKey(method)) {
            this.updateInstructionGraph(method);
        }
        ExecutionGraph graph = this.methodToTemplateExecutionGraph.get(method);
        return new ExecutionGraph(graph);
    }

    public ExecutionContext spawnRootContext(String methodSignature) {
        String[] parts = methodSignature.split("->");
        String className = parts[0];
        String methodDescriptor = parts[1];
        return this.spawnRootContext(className, methodDescriptor);
    }

    public ExecutionContext spawnRootContext(String className, String methodDescriptor) {
        VirtualMethod method = this.getClassManager().getVirtualClass(className).getMethod(methodDescriptor);
        if (method == null) {
            throw new RuntimeException("Method signature not found: " + className + "->" + methodDescriptor);
        }
        return this.spawnRootContext(method);
    }

    public ExecutionContext spawnRootContext(VirtualMethod method) {
        return this.spawnRootContext(method, null, 0);
    }

    public ExecutionContext spawnRootContext(VirtualMethod method, @Nullable ExecutionContext callerContext, int callerAddress) {
        if (!method.hasImplementation()) {
            throw new IllegalArgumentException("No implementation for " + method);
        }
        ExecutionContext spawnedContext = new ExecutionContext(this, method);
        ClassState templateClassState = TemplateStateFactory.forClass(spawnedContext, method.getDefiningClass());
        spawnedContext.setClassState(templateClassState);
        MethodState templateMethodState = TemplateStateFactory.forMethod(spawnedContext);
        spawnedContext.setMethodState(templateMethodState);
        if (callerContext != null) {
            spawnedContext.registerCaller(callerContext, callerAddress);
        }
        return spawnedContext;
    }

    public void updateInstructionGraph(VirtualMethod method) {
        ExecutionGraph graph = new ExecutionGraph(this, method);
        this.methodToTemplateExecutionGraph.put(method, graph);
    }

    public MethodExecutorFactory getMethodExecutorFactory() {
        return this.methodExecutorFactory;
    }

    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    private static String getClassNameFromMethodSignature(String methodSignature) {
        return methodSignature.split("->", 2)[0];
    }

    private static HeapItem getMutableParameterConsensus(int[] addresses, ExecutionGraph graph, int parameterRegister) {
        ExecutionNode firstNode = graph.getNodePile(addresses[0]).get(0);
        HeapItem item = firstNode.getContext().getMethodState().peekParameter(parameterRegister);
        for (int address : addresses) {
            List<ExecutionNode> nodes = graph.getNodePile(address);
            for (ExecutionNode node : nodes) {
                HeapItem otherItem = node.getContext().getMethodState().peekParameter(parameterRegister);
                if (item.getValue() == otherItem.getValue()) continue;
                log.trace("No consensus value for r{}. Returning unknown.", (Object)parameterRegister);
                return HeapItem.newUnknown(item.getType());
            }
        }
        return item;
    }

    /*
     * Unable to fully structure code
     */
    private void collapseMultiverse(VirtualMethod calledMethod, ExecutionGraph graph, ExecutionContext callerContext, int[] parameterRegisters) {
        terminatingAddresses = graph.getConnectedTerminatingAddresses();
        if (parameterRegisters != null) {
            callerMethodState = callerContext.getMethodState();
            parameterTypes = calledMethod.getParameterTypeNames();
            parameterRegister = graph.getNodePile(0).get(0).getContext().getMethodState().getParameterStart();
            for (parameterIndex = 0; parameterIndex < parameterTypes.size(); ++parameterIndex) {
                type = parameterTypes.get(parameterIndex);
                if (this.configuration.isMutable(type)) {
                    item = VirtualMachine.getMutableParameterConsensus(terminatingAddresses, graph, parameterRegister);
                    register = parameterRegisters[parameterIndex];
                    callerMethodState.assignRegisterAndUpdateIdentities(register, item);
                }
                parameterRegister += Utils.getRegisterSize(type);
            }
        }
        terminatingContexts = graph.getTerminatingContexts();
        block1: for (VirtualClass virtualClass : this.classManager.getLoadedClasses()) {
            isInitializedInCaller = callerContext.isClassInitialized(virtualClass);
            if (isInitializedInCaller) ** GOTO lbl20
            for (ExecutionContext context : terminatingContexts) {
                if (!context.isClassInitialized(virtualClass)) continue;
lbl20:
                // 2 sources

                if (isInitializedInCaller) {
                    cState = callerContext.peekClassState(virtualClass);
                } else {
                    cState = new ClassState(virtualClass, callerContext);
                    level = graph.getHighestClassSideEffectLevel(virtualClass);
                    callerContext.initializeClass(cState, level);
                }
                for (VirtualField field : virtualClass.getFields()) {
                    item = graph.getFieldConsensus(terminatingAddresses, field);
                    if (item.isPrimitive()) {
                        cState.pokeField(field, item);
                        continue;
                    }
                    cState.updateIdentities(field, item);
                }
                continue block1;
            }
        }
    }
}

