/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.util.List;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.type.UninitializedInstance;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.cf.util.Utils;

public class TemplateStateFactory {
    public static MethodState forMethod(ExecutionContext context) {
        int firstParameter;
        VirtualMethod method = context.getMethod();
        int registerCount = method.getRegisterCount();
        List<String> parameterTypes = method.getParameterTypeNames();
        int parameterSize = Utils.getRegisterSize(parameterTypes);
        MethodState mState = new MethodState(context, registerCount, parameterTypes.size(), parameterSize);
        int parameterRegister = firstParameter = mState.getParameterStart();
        for (String type : parameterTypes) {
            HeapItem item;
            if (parameterRegister == firstParameter && !method.isStatic() && method.getName().equals("<init>")) {
                UninitializedInstance instance = new UninitializedInstance(method.getDefiningClass());
                item = new HeapItem(instance, type);
            } else {
                item = HeapItem.newUnknown(type);
            }
            mState.assignParameter(parameterRegister, item);
            parameterRegister += Utils.getRegisterSize(type);
        }
        return mState;
    }

    public static ClassState forClass(ExecutionContext context, VirtualType virtualClass) {
        ClassState cState = new ClassState(virtualClass, context);
        for (VirtualField field : virtualClass.getFields()) {
            Object value = field.getInitialValue();
            String type = field.getType();
            cState.pokeField(field, new HeapItem(value, type));
        }
        return cState;
    }
}

