/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.stream.Collectors;
import org.cf.smalivm.MethodExecutor;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.exception.MaxAddressVisitsExceededException;
import org.cf.smalivm.exception.MaxCallDepthExceededException;
import org.cf.smalivm.exception.MaxExecutionTimeExceededException;
import org.cf.smalivm.exception.MaxMethodVisitsExceededException;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonInteractiveMethodExecutor
extends MethodExecutor {
    private static Logger log = LoggerFactory.getLogger(NonInteractiveMethodExecutor.class.getSimpleName());
    private final int maxCallDepth;
    private final int maxAddressVisits;
    private final int maxMethodVisits;
    private final int maxExecutionTime;
    private int totalVisits;

    NonInteractiveMethodExecutor(ClassManager classManager, ExecutionGraph graph, int maxCallDepth, int maxAddressVisits, int maxMethodVisits, int maxExecutionTime) {
        super(classManager, graph);
        this.maxCallDepth = maxCallDepth;
        this.maxAddressVisits = maxAddressVisits;
        this.maxMethodVisits = maxMethodVisits;
        this.maxExecutionTime = maxExecutionTime;
        this.totalVisits = 0;
    }

    @Override
    public ExecutionGraph execute() throws VirtualMachineException {
        boolean isRootMethod;
        ExecutionNode rootNode = this.getExecutionGraph().getRoot();
        VirtualMethod method = this.getExecutionGraph().getMethod();
        int callDepth = rootNode.getCallDepth();
        log.info("Executing {}, depth={}", (Object)method, (Object)callDepth);
        boolean bl = isRootMethod = callDepth == 0;
        if (isRootMethod) {
            this.resetTotalVisits();
        } else if (callDepth > this.getMaxCallDepth()) {
            throw new MaxCallDepthExceededException(method.getSignature());
        }
        TIntIntHashMap addressToVisitCount = new TIntIntHashMap();
        long endTime = System.currentTimeMillis() + (long)(this.maxExecutionTime * 1000);
        boolean warnedMultipleExecutionPaths = false;
        while (!this.isFinished()) {
            ++this.totalVisits;
            this.checkMaxVisits(rootNode, method, addressToVisitCount);
            ExecutionNode node = this.step();
            if (!warnedMultipleExecutionPaths && node.getChildren().size() > 1) {
                warnedMultipleExecutionPaths = true;
                String children = node.getChildren().stream().map(ExecutionNode::toString).collect(Collectors.joining(", "));
                log.debug("{} has multiple execution paths starting at {}: {}", method, node, children);
            }
            this.checkMaxExecutionTime(endTime, method);
        }
        return this.getExecutionGraph();
    }

    private void checkMaxExecutionTime(long endTime, VirtualMethod localMethod) throws MaxExecutionTimeExceededException {
        if (this.maxExecutionTime == 0) {
            return;
        }
        if (System.currentTimeMillis() >= endTime) {
            throw new MaxExecutionTimeExceededException(localMethod.getSignature());
        }
    }

    private void checkMaxVisits(ExecutionNode node, VirtualMethod localMethod, TIntIntMap addressToVisitCount) throws MaxAddressVisitsExceededException, MaxMethodVisitsExceededException {
        if (this.totalVisits > this.getMaxMethodVisits()) {
            throw new MaxMethodVisitsExceededException(node, localMethod.getSignature());
        }
        int address = node.getAddress();
        int visitCount = addressToVisitCount.get(address);
        if (visitCount > this.getMaxAddressVisits()) {
            throw new MaxAddressVisitsExceededException(node, localMethod.getSignature());
        }
        boolean adjusted = addressToVisitCount.adjustValue(address, 1);
        if (!adjusted) {
            addressToVisitCount.put(address, 1);
        }
    }

    private int getMaxAddressVisits() {
        return this.maxAddressVisits;
    }

    private int getMaxCallDepth() {
        return this.maxCallDepth;
    }

    private int getMaxMethodVisits() {
        return this.maxMethodVisits;
    }

    private void resetTotalVisits() {
        this.totalVisits = 0;
    }
}

