/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import org.cf.smalivm.MethodExecutor;
import org.cf.smalivm.NonInteractiveMethodExecutor;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.VirtualMachine;
import org.cf.smalivm.context.ClassState;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;

public class MethodExecutorFactory {
    private final VirtualMachine vm;
    private int maxAddressVisits = 10000;
    private int maxCallDepth = 50;
    private int maxExecutionTime = 300;
    private int maxMethodVisits = 1000000;
    private boolean interactive = false;

    public MethodExecutorFactory(VirtualMachine vm) {
        this.vm = vm;
    }

    public MethodExecutorFactory setMaxAddressVisits(int maxAddressVisits) {
        this.maxAddressVisits = maxAddressVisits;
        return this;
    }

    public MethodExecutorFactory setMaxCallDepth(int maxCallDepth) {
        this.maxCallDepth = maxCallDepth;
        return this;
    }

    public MethodExecutorFactory setMaxExecutionTime(int maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
        return this;
    }

    public MethodExecutorFactory setMaxMethodVisits(int maxMethodVisits) {
        this.maxMethodVisits = maxMethodVisits;
        return this;
    }

    public MethodExecutorFactory setInteractive() {
        this.interactive = true;
        return this;
    }

    public MethodExecutor build(VirtualMethod virtualMethod) {
        ExecutionContext calleeContext = this.vm.spawnRootContext(virtualMethod);
        return this.build(calleeContext);
    }

    public MethodExecutor build(ExecutionContext calleeContext) {
        return this.build(calleeContext, null);
    }

    public MethodExecutor build(ExecutionContext calleeContext, ExecutionContext callerContext) {
        if (callerContext != null) {
            this.inheritClassStates(callerContext, calleeContext);
        }
        VirtualMethod virtualMethod = calleeContext.getMethod();
        calleeContext.staticallyInitializeClassIfNecessary(virtualMethod.getDefiningClass());
        ExecutionGraph graph = this.vm.spawnInstructionGraph(virtualMethod);
        ExecutionNode rootNode = new ExecutionNode(graph.getRoot());
        rootNode.setContext(calleeContext);
        graph.addNode(rootNode);
        if (this.interactive) {
            return new MethodExecutor(this.vm.getClassManager(), graph);
        }
        return new NonInteractiveMethodExecutor(this.vm.getClassManager(), graph, this.maxCallDepth, this.maxAddressVisits, this.maxMethodVisits, this.maxExecutionTime);
    }

    private void inheritClassStates(ExecutionContext parentContext, ExecutionContext childContext) {
        for (VirtualClass virtualClass : this.vm.getClassManager().getLoadedClasses()) {
            if (!parentContext.isClassInitialized(virtualClass)) continue;
            ClassState fromClassState = parentContext.peekClassState(virtualClass);
            ClassState toClassState = fromClassState.getChild(childContext);
            for (VirtualField field : fromClassState.getVirtualClass().getFields()) {
                HeapItem item = fromClassState.peekField(field);
                toClassState.pokeField(field, item);
            }
            SideEffect.Level level = parentContext.getClassSideEffectLevel(virtualClass);
            childContext.initializeClass(toClassState, level);
        }
    }
}

