/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.util.ArrayDeque;
import java.util.Deque;
import org.cf.smalivm.NodeExecutor;
import org.cf.smalivm.context.ExecutionGraph;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.exception.UnhandledVirtualException;
import org.cf.smalivm.exception.VirtualMachineException;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodExecutor {
    private static Logger log = LoggerFactory.getLogger(MethodExecutor.class.getSimpleName());
    private final Deque<ExecutionNode> stack;
    private final NodeExecutor nodeExecutor;
    private final ExecutionGraph graph;

    public MethodExecutor(ClassManager classManager, ExecutionGraph graph) {
        this.graph = graph;
        this.nodeExecutor = new NodeExecutor(graph, classManager);
        this.stack = new ArrayDeque<ExecutionNode>();
        ExecutionNode rootNode = graph.getRoot();
        this.stack.push(rootNode);
    }

    public boolean isFinished() {
        return this.getStack().isEmpty();
    }

    public ExecutionGraph execute() throws VirtualMachineException {
        VirtualMethod method = this.getExecutionGraph().getMethod();
        int callDepth = this.getCurrentNode().getCallDepth();
        log.info("Executing {}, depth={}", (Object)method, (Object)callDepth);
        while (!this.isFinished()) {
            this.step();
        }
        return this.getExecutionGraph();
    }

    public ExecutionNode step() throws UnhandledVirtualException {
        ExecutionNode node = this.getStack().poll();
        this.nodeExecutor.execute(node);
        this.getStack().addAll(node.getChildren());
        return node;
    }

    public ExecutionNode getCurrentNode() {
        return this.getStack().peek();
    }

    public VirtualMethod getVirtualMethod() {
        return this.getExecutionGraph().getMethod();
    }

    public ExecutionGraph getExecutionGraph() {
        return this.graph;
    }

    public Deque<ExecutionNode> getStack() {
        return this.stack;
    }
}

