/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm;

import java.util.LinkedList;
import java.util.List;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.builder.BuilderTryBlock;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.TryBlock;

public class ExceptionHandlerAddressResolver {
    private final ClassManager classManager;
    private final List<BuilderTryBlock> tryBlocks;

    ExceptionHandlerAddressResolver(ClassManager classManager, VirtualMethod localMethod) {
        this.classManager = classManager;
        this.tryBlocks = localMethod.getTryBlocks();
    }

    int resolve(String className, int address) {
        VirtualClass exceptionClass = this.classManager.getVirtualClass(className);
        return this.resolve(exceptionClass, address);
    }

    int resolve(Throwable ex, int address) {
        String className = ClassNameUtils.binaryToInternal(ex.getClass().getName());
        return this.resolve(className, address);
    }

    int resolve(VirtualClass exceptionClass, int address) {
        int handlerAddress = this.findHandlerCodeAddress(exceptionClass, address, false);
        if (handlerAddress != -1) {
            return handlerAddress;
        }
        handlerAddress = this.findHandlerCodeAddress(exceptionClass, address, true);
        return handlerAddress;
    }

    private int findHandlerCodeAddress(VirtualClass exceptionClass, int address, boolean catchAll) {
        LinkedList<VirtualClass> lineage = new LinkedList<VirtualClass>();
        lineage.add(exceptionClass);
        lineage.addAll(exceptionClass.getAncestors());
        for (VirtualClass currentExceptionClass : lineage) {
            String className = currentExceptionClass.getName();
            for (TryBlock tryBlock : this.tryBlocks) {
                boolean inTryBlock;
                int startAddress = tryBlock.getStartCodeAddress();
                int endAddress = tryBlock.getStartCodeAddress() + tryBlock.getCodeUnitCount();
                boolean bl = inTryBlock = address >= startAddress && address < endAddress;
                if (!inTryBlock) continue;
                List handlers = tryBlock.getExceptionHandlers();
                if (catchAll) {
                    ExceptionHandler handler = (ExceptionHandler)handlers.get(handlers.size() - 1);
                    if (null != handler.getExceptionType()) continue;
                    return handler.getHandlerCodeAddress();
                }
                for (ExceptionHandler handler : handlers) {
                    String handlerType = handler.getExceptionType();
                    if (!className.equals(handlerType)) continue;
                    return handler.getHandlerCodeAddress();
                }
            }
            if (!catchAll) continue;
            return -1;
        }
        return -1;
    }
}

