/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify.strategy;

import com.google.common.primitives.Ints;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cf.simplify.ConstantBuilder;
import org.cf.simplify.ExecutionGraphManipulator;
import org.cf.simplify.strategy.OptimizationStrategy;
import org.cf.smalivm.opcode.InvokeOp;
import org.cf.smalivm.opcode.Op;
import org.cf.smalivm.type.UnknownValue;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.util.ClassNameUtils;
import org.cf.util.Utils;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.instruction.BuilderInstruction11x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction23x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction32x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction35c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction3rc;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodReference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnreflectionStrategy
implements OptimizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(UnreflectionStrategy.class.getSimpleName());
    private static final String METHOD_INVOKE_SIGNATURE = "Ljava/lang/reflect/Method;->invoke(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String FIELD_GET_SIGNATURE = "Ljava/lang/reflect/Field;->get(Ljava/lang/Object;)Ljava/lang/Object;";
    private final ExecutionGraphManipulator manipulator;
    private int unreflectedMethodCount;
    private int unreflectedFieldCount;
    private int[] addresses;
    private boolean madeChanges;

    public UnreflectionStrategy(ExecutionGraphManipulator manipulator) {
        this.manipulator = manipulator;
        this.unreflectedMethodCount = 0;
        this.unreflectedFieldCount = 0;
    }

    static Opcode getGetOpcode(String type, boolean isStatic) {
        Opcode op = isStatic ? (ClassNameUtils.isPrimitive(type) ? ("J".equals(type) || "D".equals(type) ? Opcode.SGET_WIDE : ("Z".equals(type) ? Opcode.SGET_BOOLEAN : ("B".equals(type) ? Opcode.SGET_BYTE : ("C".equals(type) ? Opcode.SGET_CHAR : ("S".equals(type) ? Opcode.SGET_SHORT : Opcode.SGET))))) : Opcode.SGET_OBJECT) : (ClassNameUtils.isPrimitive(type) ? ("J".equals(type) || "D".equals(type) ? Opcode.IGET_WIDE : ("Z".equals(type) ? Opcode.IGET_BOOLEAN : ("B".equals(type) ? Opcode.IGET_BYTE : ("C".equals(type) ? Opcode.IGET_CHAR : ("S".equals(type) ? Opcode.IGET_SHORT : Opcode.IGET))))) : Opcode.IGET_OBJECT);
        return op;
    }

    private static Integer[] getFourBitValues(List<Integer> values) {
        return (Integer[])values.stream().filter(v -> v <= 15).toArray(Integer[]::new);
    }

    private static void setRegisterCount(BuilderMethod method, int registerCount) throws Exception {
        MethodImplementation implementation = method.getImplementation();
        Field f = implementation.getClass().getDeclaredField("registerCount");
        f.setAccessible(true);
        f.set(implementation, registerCount);
    }

    @Override
    public Map<String, Integer> getOptimizationCounts() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("unreflected methods", this.unreflectedMethodCount);
        result.put("unreflected fields", this.unreflectedFieldCount);
        return result;
    }

    @Override
    public boolean perform() {
        this.madeChanges = false;
        this.addresses = this.getValidAddresses(this.manipulator);
        this.replaceMethodInvoke();
        this.addresses = this.getValidAddresses(this.manipulator);
        this.replaceFieldGet();
        return this.madeChanges;
    }

    List<BuilderInstruction> buildMethodInvokeReplacement(int address) throws Exception {
        BuilderInstruction invoke;
        Op op = this.manipulator.getOp(address);
        int[] parameterRegisters = ((InvokeOp)op).getParameterRegisters();
        int methodRegister = parameterRegisters[0];
        int targetRegister = parameterRegisters[1];
        int parametersRegister = parameterRegisters[2];
        int[] parentAddresses = this.manipulator.getParentAddresses(address);
        Object methodValue = this.manipulator.getRegisterConsensusValue(parentAddresses, methodRegister);
        Method method = (Method)methodValue;
        int methodAccessFlags = method.getModifiers();
        int classAccessFlags = method.getDeclaringClass().getModifiers();
        List<String> parameterTypes = ClassNameUtils.toInternal(method.getParameterTypes());
        int parameterRegisterCount = Utils.getRegisterSize(parameterTypes);
        MethodReference methodRef = this.buildMethodReference(method);
        boolean isStatic = Modifier.isStatic(methodAccessFlags);
        int invokeRegisterCount = parameterRegisterCount + (isStatic ? 0 : 1);
        boolean isRange = 5 < parameterRegisterCount;
        LinkedList<Integer> registers = new LinkedList<Integer>();
        if (invokeRegisterCount > 0) {
            Integer[] fourBitRegisters;
            Integer n;
            Integer n2;
            Integer register;
            int registerCount;
            int oldRegisterCount;
            List<Integer> availableRegisters1 = IntStream.of(this.manipulator.getAvailableRegisters(address)).boxed().sorted().collect(Collectors.toList());
            if (parameterTypes.size() > 0) {
                availableRegisters1.remove((Object)parametersRegister);
            }
            if (availableRegisters1.size() < parameterRegisterCount) {
                VirtualMethod virtualMethod = this.manipulator.getMethod();
                BuilderMethod builderMethod = virtualMethod.getMethodDefinition();
                oldRegisterCount = builderMethod.getImplementation().getRegisterCount();
                registerCount = oldRegisterCount + invokeRegisterCount;
                UnreflectionStrategy.setRegisterCount(builderMethod, registerCount);
                availableRegisters1.clear();
                register = oldRegisterCount;
                while (register < registerCount) {
                    availableRegisters1.add(register);
                    n2 = register;
                    n = register = Integer.valueOf(register + 1);
                }
            }
            if ((fourBitRegisters = UnreflectionStrategy.getFourBitValues(availableRegisters1)).length < parameterRegisterCount) {
                isRange = true;
            }
            if (!isRange) {
                registers.addAll(Arrays.asList(fourBitRegisters).subList(0, parameterRegisterCount));
            } else {
                for (int i = 0; i < availableRegisters1.size() && registers.size() < invokeRegisterCount; ++i) {
                    Integer nextRegister;
                    Integer register2 = availableRegisters1.get(i);
                    registers.add(register2);
                    if (i + 1 >= availableRegisters1.size() || (nextRegister = availableRegisters1.get(i + 1)) - register2 == 1) continue;
                    registers.clear();
                }
                if (registers.size() < invokeRegisterCount) {
                    registers.clear();
                    BuilderMethod builderMethod = this.manipulator.getMethod().getMethodDefinition();
                    oldRegisterCount = builderMethod.getImplementation().getRegisterCount();
                    registerCount = oldRegisterCount + invokeRegisterCount;
                    UnreflectionStrategy.setRegisterCount(builderMethod, registerCount);
                    register = oldRegisterCount;
                    while (register < registerCount) {
                        registers.add(register);
                        n2 = register;
                        n = register = Integer.valueOf(register + 1);
                    }
                }
            }
        }
        LinkedList<BuilderInstruction> instructions = new LinkedList<BuilderInstruction>();
        if (!isStatic && isRange) {
            int instanceRegister = (Integer)registers.get(0);
            BuilderInstruction32x move = new BuilderInstruction32x(Opcode.MOVE_OBJECT_16, instanceRegister, targetRegister);
            instructions.add(move);
            instructions.addAll(this.getArrayAccessorInstructions(parametersRegister, registers.subList(1, registers.size()), parameterTypes));
        } else {
            instructions.addAll(this.getArrayAccessorInstructions(parametersRegister, registers, parameterTypes));
        }
        Opcode invokeOp = this.getInvokeOp(classAccessFlags, methodAccessFlags, isRange);
        if (isRange) {
            int startRegister = (Integer)registers.get(0);
            invoke = new BuilderInstruction3rc(invokeOp, startRegister, invokeRegisterCount, methodRef);
        } else {
            while (registers.size() < 5) {
                registers.add(0);
            }
            invoke = isStatic ? new BuilderInstruction35c(invokeOp, invokeRegisterCount, (Integer)registers.get(0), (Integer)registers.get(1), (Integer)registers.get(2), (Integer)registers.get(3), (Integer)registers.get(4), methodRef) : new BuilderInstruction35c(invokeOp, invokeRegisterCount, targetRegister, (Integer)registers.get(0), (Integer)registers.get(1), (Integer)registers.get(2), (Integer)registers.get(3), methodRef);
        }
        instructions.add(invoke);
        return instructions;
    }

    boolean canReplaceFieldGet(int address) {
        int[] available;
        Op op = this.manipulator.getOp(address);
        if (!(op instanceof InvokeOp)) {
            return false;
        }
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        ReferenceInstruction instr = (ReferenceInstruction)((Object)instruction);
        String methodSignature = ReferenceUtil.getReferenceString(instr.getReference());
        if (!methodSignature.equals(FIELD_GET_SIGNATURE)) {
            return false;
        }
        int[] parameterRegisters = ((InvokeOp)op).getParameterRegisters();
        int fieldRegister = parameterRegisters[0];
        Object fieldValue = this.manipulator.getRegisterConsensusValue(address, fieldRegister);
        if (fieldValue instanceof UnknownValue) {
            return false;
        }
        Field field = (Field)fieldValue;
        boolean isPublic = Modifier.isPublic(field.getModifiers());
        if (!isPublic && field.isAccessible()) {
            return false;
        }
        int nextAddress = address + instruction.getCodeUnits();
        BuilderInstruction nextInstr = this.manipulator.getInstruction(nextAddress);
        String opName = nextInstr.getOpcode().name;
        return opName.startsWith("move-result") || (available = this.manipulator.getAvailableRegisters(address)).length != 0;
    }

    boolean canReplaceMethodInvoke(int address) {
        Op op = this.manipulator.getOp(address);
        if (!(op instanceof InvokeOp)) {
            return false;
        }
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        ReferenceInstruction instr = (ReferenceInstruction)((Object)instruction);
        String methodSignature = ReferenceUtil.getReferenceString(instr.getReference());
        if (!methodSignature.equals(METHOD_INVOKE_SIGNATURE)) {
            return false;
        }
        int[] parameterRegisters = ((InvokeOp)op).getParameterRegisters();
        int methodRegister = parameterRegisters[0];
        int[] parentAddresses = this.manipulator.getParentAddresses(address);
        Object methodValue = this.manipulator.getRegisterConsensusValue(parentAddresses, methodRegister);
        if (methodValue instanceof UnknownValue) {
            return false;
        }
        String className = this.manipulator.getMethod().getClassName();
        Method method = (Method)methodValue;
        int methodAccessFlags = method.getModifiers();
        String declaringClass = ClassNameUtils.toInternal(method.getDeclaringClass());
        boolean isPrivate = Modifier.isPrivate(methodAccessFlags);
        return !isPrivate || declaringClass.equals(className) || method.isAccessible();
    }

    int[] getValidAddresses(ExecutionGraphManipulator manipulator) {
        int[] addresses = manipulator.getAddresses();
        LinkedList<Integer> validAddresses = new LinkedList<Integer>();
        for (int address : addresses) {
            if (!manipulator.wasAddressReached(address)) continue;
            validAddresses.add(address);
        }
        return Ints.toArray(validAddresses);
    }

    private BuilderInstruction buildFieldGetReplacement(int address) {
        int destRegister;
        Op op = this.manipulator.getOp(address);
        int[] parameterRegisters = ((InvokeOp)op).getParameterRegisters();
        int fieldRegister = parameterRegisters[0];
        int targetRegister = parameterRegisters[1];
        Object fieldValue = this.manipulator.getRegisterConsensusValue(address, fieldRegister);
        Field field = (Field)fieldValue;
        String fieldDescriptor = Utils.buildFieldDescriptor(field);
        String[] parts = fieldDescriptor.split("->");
        String className = parts[0];
        String fieldNameAndType = parts[1];
        parts = fieldNameAndType.split(":");
        String fieldName = parts[0];
        String type = parts[1];
        BuilderField builderField = this.manipulator.getDexBuilder().internField(className, fieldName, type, field.getModifiers(), null, new HashSet(), new HashSet<HiddenApiRestriction>());
        BuilderFieldReference fieldRef = this.manipulator.getDexBuilder().internFieldReference(builderField);
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        Opcode newOp = UnreflectionStrategy.getGetOpcode(type, isStatic);
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        int nextAddress = address + instruction.getCodeUnits();
        BuilderInstruction nextInstr = this.manipulator.getInstruction(nextAddress);
        String opName = nextInstr.getOpcode().name;
        if (opName.startsWith("move-result")) {
            BuilderInstruction11x moveInstr = (BuilderInstruction11x)nextInstr;
            destRegister = moveInstr.getRegisterA();
        } else {
            destRegister = this.manipulator.getAvailableRegisters(address)[0];
        }
        BuilderInstruction replacement = isStatic ? new BuilderInstruction21c(newOp, destRegister, fieldRef) : new BuilderInstruction22c(newOp, destRegister, targetRegister, fieldRef);
        return replacement;
    }

    private MethodReference buildMethodReference(Method method) {
        String className = ClassNameUtils.toInternal(method.getDeclaringClass());
        String name = method.getName();
        List<String> parameterTypes = ClassNameUtils.toInternal(method.getParameterTypes());
        String returnType = ClassNameUtils.toInternal(method.getReturnType());
        ImmutableMethodReference immutableMethodRef = new ImmutableMethodReference(className, name, parameterTypes, returnType);
        BuilderMethodReference methodRef = this.manipulator.getDexBuilder().internMethodReference(immutableMethodRef);
        return methodRef;
    }

    private List<BuilderInstruction> getArrayAccessorInstructions(int arrayRegister, List<Integer> registers, List<String> parameterTypes) {
        LinkedList<BuilderInstruction> instructions = new LinkedList<BuilderInstruction>();
        for (int index = 0; index < parameterTypes.size(); ++index) {
            int register = registers.get(index);
            BuilderInstruction constInstruction = ConstantBuilder.buildConstant(index, register);
            BuilderInstruction23x arrayGet = new BuilderInstruction23x(Opcode.AGET_OBJECT, register, arrayRegister, register);
            String typeName = parameterTypes.get(index);
            if (ClassNameUtils.isPrimitive(typeName)) {
                typeName = ClassNameUtils.binaryToInternal(ClassNameUtils.getWrapper(typeName));
            }
            BuilderTypeReference typeRef = this.manipulator.getDexBuilder().internTypeReference(typeName);
            BuilderInstruction21c checkCast = new BuilderInstruction21c(Opcode.CHECK_CAST, register, typeRef);
            instructions.add(constInstruction);
            instructions.add(arrayGet);
            instructions.add(checkCast);
        }
        return instructions;
    }

    private Opcode getInvokeOp(int classAccessFlags, int methodAccessFlags, boolean isRange) {
        boolean isConstructor;
        boolean isInterface = Modifier.isInterface(classAccessFlags);
        if (isInterface) {
            Opcode invokeOp = isRange ? Opcode.INVOKE_INTERFACE_RANGE : Opcode.INVOKE_INTERFACE;
            return invokeOp;
        }
        boolean isStatic = Modifier.isStatic(methodAccessFlags);
        boolean isPrivate = Modifier.isPrivate(methodAccessFlags);
        boolean bl = isConstructor = (methodAccessFlags & AccessFlags.CONSTRUCTOR.getValue()) != 0;
        Opcode invokeOp = isStatic ? (isRange ? Opcode.INVOKE_STATIC_RANGE : Opcode.INVOKE_STATIC) : (isPrivate || isConstructor ? (isRange ? Opcode.INVOKE_DIRECT_RANGE : Opcode.INVOKE_DIRECT) : (isRange ? Opcode.INVOKE_VIRTUAL_RANGE : Opcode.INVOKE_VIRTUAL));
        return invokeOp;
    }

    private void removeMoveResultIfNecessary(int address) {
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        int nextAddress = address + instruction.getCodeUnits();
        BuilderInstruction nextInstr = this.manipulator.getInstruction(nextAddress);
        String opName = nextInstr.getOpcode().name;
        if (opName.startsWith("move-result")) {
            this.manipulator.removeInstruction(nextAddress);
        }
    }

    private void replaceFieldGet() {
        LinkedList<Integer> getAddresses = new LinkedList<Integer>();
        for (int address : this.addresses) {
            if (!this.canReplaceFieldGet(address)) continue;
            getAddresses.add(address);
        }
        if (0 == getAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.unreflectedFieldCount += getAddresses.size();
        Collections.reverse(getAddresses);
        Object object = getAddresses.iterator();
        while (object.hasNext()) {
            int address = (Integer)object.next();
            BuilderInstruction replacement = this.buildFieldGetReplacement(address);
            this.removeMoveResultIfNecessary(address);
            this.manipulator.replaceInstruction(address, replacement);
        }
    }

    private void replaceMethodInvoke() {
        int[] invokeAddresses = Arrays.stream(this.addresses).filter(this::canReplaceMethodInvoke).sorted().toArray();
        int count = invokeAddresses.length;
        if (count == 0) {
            return;
        }
        this.madeChanges = true;
        this.unreflectedMethodCount += count;
        for (int i = count - 1; i >= 0; --i) {
            int address = invokeAddresses[i];
            try {
                List<BuilderInstruction> replacements = this.buildMethodInvokeReplacement(address);
                this.manipulator.replaceInstruction(address, replacements);
                continue;
            }
            catch (Exception e) {
                log.error("Unable to unreflect method invocation @" + address, e);
            }
        }
    }
}

