/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cf.simplify.ConstantBuilder;
import org.cf.simplify.ExecutionGraphManipulator;
import org.cf.simplify.strategy.OptimizationStrategy;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.opcode.InvokeOp;
import org.cf.smalivm.opcode.MoveOp;
import org.cf.smalivm.opcode.Op;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderOffsetInstruction;
import org.jf.dexlib2.builder.Label;
import org.jf.dexlib2.builder.instruction.BuilderInstruction10x;
import org.jf.dexlib2.builder.instruction.BuilderInstruction21c;
import org.jf.dexlib2.builder.instruction.BuilderInstruction30t;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeepholeStrategy
implements OptimizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(PeepholeStrategy.class.getSimpleName());
    private static final String CLASS_FOR_NAME_SIGNATURE = "Ljava/lang/Class;->forName(Ljava/lang/String;)Ljava/lang/Class;";
    private static final String OBJECT_GET_CLASS_SIGNATURE = "Ljava/lang/Object;->getClass()Ljava/lang/Class;";
    private final ExecutionGraphManipulator manipulator;
    private int peepCount;
    private int constantIfCount;
    private List<Integer> addresses;
    private boolean madeChanges;

    public PeepholeStrategy(ExecutionGraphManipulator manipulator) {
        this.manipulator = manipulator;
        this.peepCount = 0;
        this.constantIfCount = 0;
    }

    @Override
    public Map<String, Integer> getOptimizationCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("peephole optmizations", this.peepCount);
        counts.put("constantized ifs", this.constantIfCount);
        return counts;
    }

    @Override
    public boolean perform() {
        this.madeChanges = false;
        this.addresses = this.getValidAddresses(this.manipulator);
        this.peepClassForName();
        this.addresses = this.getValidAddresses(this.manipulator);
        this.peepStringInit();
        this.addresses = this.getValidAddresses(this.manipulator);
        this.peepConstantPredicate();
        this.addresses = this.getValidAddresses(this.manipulator);
        this.peepCheckCast();
        this.addresses = this.getValidAddresses(this.manipulator);
        this.peepUninitializedInstanceThisReference();
        return this.madeChanges;
    }

    BuilderInstruction buildClassForNameReplacement(int address) {
        InvokeOp op = (InvokeOp)this.manipulator.getOp(address);
        int[] parameterRegisters = op.getParameterRegisters();
        int register = parameterRegisters[0];
        String javaClassName = (String)this.manipulator.getRegisterConsensusValue(address, register);
        String smaliClassName = ClassNameUtils.binaryToInternal(javaClassName);
        HeapItem klazz = this.manipulator.getRegisterConsensus(address, -1);
        if (klazz == null) {
            log.warn("Optimizing Class.forName of potentially non-existent class: {}", (Object)smaliClassName);
        }
        BuilderTypeReference classRef = this.manipulator.getDexBuilder().internTypeReference(smaliClassName);
        BuilderInstruction21c constClassInstruction = new BuilderInstruction21c(Opcode.CONST_CLASS, register, classRef);
        return constClassInstruction;
    }

    BuilderInstruction buildUninitializedInstanceReferenceResultReplacement(int address) {
        InvokeOp invokeOp = (InvokeOp)this.manipulator.getOp(address);
        int instanceRegister = invokeOp.getParameterRegisters()[0];
        HeapItem item = this.manipulator.getRegisterConsensus(address, instanceRegister);
        BuilderInstruction original = this.manipulator.getInstruction(address);
        int nextAddress = address + original.getCodeUnits();
        MoveOp moveOp = (MoveOp)this.manipulator.getOp(nextAddress);
        int destRegsiter = moveOp.getToRegister();
        ReferenceInstruction instr = (ReferenceInstruction)((Object)original);
        String methodDescriptor = ReferenceUtil.getReferenceString(instr.getReference());
        BuilderInstruction21c replacementInstruction = null;
        if (methodDescriptor.equals(OBJECT_GET_CLASS_SIGNATURE)) {
            String smaliClassName = item.getType();
            BuilderTypeReference classRef = this.manipulator.getDexBuilder().internTypeReference(smaliClassName);
            replacementInstruction = new BuilderInstruction21c(Opcode.CONST_CLASS, destRegsiter, classRef);
        }
        return replacementInstruction;
    }

    boolean canPeepCheckCast(int address) {
        String preCastType;
        Op op = this.manipulator.getOp(address);
        if (!op.toString().startsWith("check-cast")) {
            return false;
        }
        BuilderInstruction21c original = (BuilderInstruction21c)this.manipulator.getInstruction(address);
        int registerA = original.getRegisterA();
        HashSet ancestorTypes = new HashSet();
        for (int parentAddress : this.manipulator.getParentAddresses(address)) {
            ancestorTypes.addAll(this.manipulator.getRegisterItems(parentAddress, registerA).stream().map(HeapItem::getType).collect(Collectors.toList()));
        }
        if (ancestorTypes.size() > 1) {
            return false;
        }
        if (ancestorTypes.size() > 0) {
            preCastType = ancestorTypes.toArray(new String[1])[0];
        } else {
            ExecutionContext context = this.manipulator.getVM().spawnRootContext(this.manipulator.getMethod());
            HeapItem item = context.getMethodState().peekRegister(registerA);
            preCastType = item.getType();
        }
        String referenceType = ReferenceUtil.getReferenceString(original.getReference());
        return preCastType.equals(referenceType);
    }

    boolean canPeepClassForName(int address) {
        Op op = this.manipulator.getOp(address);
        if (!(op instanceof InvokeOp)) {
            return false;
        }
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        ReferenceInstruction instr = (ReferenceInstruction)((Object)instruction);
        String methodDescriptor = ReferenceUtil.getReferenceString(instr.getReference());
        if (!methodDescriptor.equals(CLASS_FOR_NAME_SIGNATURE)) {
            return false;
        }
        int[] parameterRegisters = ((InvokeOp)op).getParameterRegisters();
        int registerA = parameterRegisters[0];
        HeapItem className = this.manipulator.getRegisterConsensus(address, registerA);
        return !className.isUnknown();
    }

    boolean canPeepStringInit(int address) {
        BuilderInstruction original = this.manipulator.getInstruction(address);
        if (original.getOpcode() != Opcode.INVOKE_DIRECT) {
            return false;
        }
        Instruction35c instr = (Instruction35c)((Object)original);
        MethodReference methodReference = (MethodReference)instr.getReference();
        String methodDescriptor = ReferenceUtil.getMethodDescriptor(methodReference);
        if (!methodDescriptor.startsWith("Ljava/lang/String;-><init>(")) {
            return false;
        }
        int instanceRegister = instr.getRegisterC();
        HeapItem item = this.manipulator.getRegisterConsensus(address, instanceRegister);
        return item.getValue() instanceof String;
    }

    boolean canPeepUninitializedInstanceThisReference(int address) {
        Op op = this.manipulator.getOp(address);
        if (!op.getName().startsWith("invoke-virtual")) {
            return false;
        }
        InvokeOp invokeOp = (InvokeOp)op;
        int instanceRegister = invokeOp.getParameterRegisters()[0];
        HeapItem item = this.manipulator.getRegisterConsensus(address, instanceRegister);
        if (!item.getType().equals(this.manipulator.getMethod().getClassName())) {
            return false;
        }
        String methodSignature = ((InvokeOp)op).getMethod().getSignature();
        if (!methodSignature.equals(OBJECT_GET_CLASS_SIGNATURE)) {
            return false;
        }
        BuilderInstruction original = this.manipulator.getInstruction(address);
        int nextAddress = address + original.getCodeUnits();
        if (!this.addresses.contains(nextAddress)) {
            return false;
        }
        BuilderInstruction nextInstruction = this.manipulator.getInstruction(nextAddress);
        return nextInstruction.getOpcode().name.startsWith("move-result");
    }

    List<Integer> getValidAddresses(ExecutionGraphManipulator manipulator) {
        return IntStream.of(manipulator.getAddresses()).boxed().filter(manipulator::wasAddressReached).collect(Collectors.toList());
    }

    void peepCheckCast() {
        List peepAddresses = this.addresses.stream().filter(this::canPeepCheckCast).collect(Collectors.toList());
        if (0 == peepAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.peepCount += peepAddresses.size();
        Collections.sort(peepAddresses, Collections.reverseOrder());
        Iterator iterator = peepAddresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            log.debug("Removing useless check-cast @{} {}", (Object)address, (Object)this.manipulator.getOp(address));
            this.manipulator.removeInstruction(address);
        }
    }

    void peepClassForName() {
        List peepAddresses = this.addresses.stream().filter(this::canPeepClassForName).collect(Collectors.toList());
        if (0 == peepAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.peepCount += peepAddresses.size();
        Collections.sort(peepAddresses, Collections.reverseOrder());
        Iterator iterator = peepAddresses.iterator();
        while (iterator.hasNext()) {
            BuilderInstruction original;
            int address = (Integer)iterator.next();
            int nextAddress = address + (original = this.manipulator.getInstruction(address)).getCodeUnits();
            if (this.addresses.contains(nextAddress)) {
                BuilderInstruction nextInstruction = this.manipulator.getInstruction(nextAddress);
                if (nextInstruction.getOpcode().name.startsWith("move-result")) {
                    this.manipulator.removeInstruction(nextAddress);
                }
            }
            BuilderInstruction replacement = this.buildClassForNameReplacement(address);
            this.manipulator.replaceInstruction(address, replacement);
        }
    }

    void peepUninitializedInstanceThisReference() {
        List peepAddresses = this.addresses.stream().filter(this::canPeepUninitializedInstanceThisReference).collect(Collectors.toList());
        if (0 == peepAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.peepCount += peepAddresses.size();
        Collections.sort(peepAddresses, Collections.reverseOrder());
        Iterator iterator = peepAddresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            BuilderInstruction replacement = this.buildUninitializedInstanceReferenceResultReplacement(address);
            this.manipulator.replaceInstruction(address, replacement);
            int nextAddress = address + replacement.getCodeUnits();
            this.manipulator.removeInstruction(nextAddress);
        }
    }

    void peepConstantPredicate() {
        LinkedList<Integer> peepAddresses = new LinkedList<Integer>();
        HashSet<Integer> nextAddresses = new HashSet<Integer>();
        for (int address : this.addresses) {
            BuilderInstruction original = this.manipulator.getInstruction(address);
            if (!(original instanceof Instruction22t) && !(original instanceof Instruction21t)) continue;
            HashSet<ExecutionNode> children = new HashSet<ExecutionNode>();
            List<ExecutionNode> pile = this.manipulator.getNodePile(address);
            for (ExecutionNode node : pile) {
                children.addAll(node.getChildren());
            }
            if (children.size() != 1) break;
            ExecutionNode child = pile.get(0).getChildren().get(0);
            boolean isNext = child.getAddress() == original.getLocation().getCodeAddress() + original.getCodeUnits();
            peepAddresses.add(address);
            if (!isNext) continue;
            nextAddresses.add(address);
        }
        if (0 == peepAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.constantIfCount += peepAddresses.size();
        Collections.sort(peepAddresses, Collections.reverseOrder());
        for (int address : peepAddresses) {
            BuilderInstruction replacement;
            if (nextAddresses.contains(address)) {
                replacement = new BuilderInstruction10x(Opcode.NOP);
            } else {
                BuilderOffsetInstruction original = (BuilderOffsetInstruction)this.manipulator.getInstruction(address);
                Label target = original.getTarget();
                replacement = new BuilderInstruction30t(Opcode.GOTO_32, target);
            }
            if (log.isDebugEnabled()) {
                log.debug("Constantizing if @{} {}", (Object)address, (Object)this.manipulator.getOp(address));
            }
            this.manipulator.replaceInstruction(address, replacement);
        }
    }

    void peepStringInit() {
        List peepAddresses = this.addresses.stream().filter(this::canPeepStringInit).collect(Collectors.toList());
        if (0 == peepAddresses.size()) {
            return;
        }
        this.madeChanges = true;
        this.peepCount += peepAddresses.size();
        Collections.sort(peepAddresses, Collections.reverseOrder());
        Iterator iterator = peepAddresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            BuilderInstruction original = this.manipulator.getInstruction(address);
            Instruction35c instr = (Instruction35c)((Object)original);
            int instanceRegister = instr.getRegisterC();
            HeapItem item = this.manipulator.getRegisterConsensus(address, instanceRegister);
            BuilderInstruction replacement = ConstantBuilder.buildConstant(item.getValue(), item.getUnboxedType(), instanceRegister, this.manipulator.getDexBuilder());
            if (log.isDebugEnabled()) {
                log.debug("Peeping string init @{} {}", (Object)address, (Object)this.manipulator.getOp(address));
            }
            this.manipulator.replaceInstruction(address, replacement);
        }
    }
}

