/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify.strategy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cf.simplify.ExecutionGraphManipulator;
import org.cf.simplify.strategy.OptimizationStrategy;
import org.cf.smalivm.SideEffect;
import org.cf.smalivm.context.ExecutionContext;
import org.cf.smalivm.context.ExecutionNode;
import org.cf.smalivm.context.MethodState;
import org.cf.smalivm.opcode.APutOp;
import org.cf.smalivm.opcode.GotoOp;
import org.cf.smalivm.opcode.InvokeOp;
import org.cf.smalivm.opcode.NopOp;
import org.cf.smalivm.opcode.Op;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderExceptionHandler;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.BuilderTryBlock;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadRemovalStrategy
implements OptimizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(DeadRemovalStrategy.class.getSimpleName());
    private final ExecutionGraphManipulator manipulator;
    private List<Integer> addresses;
    private Set<Integer> exceptionHandlingAddresses;
    private int unusedAssignmentCount;
    private int uselessBranchCount;
    private int unvisitedCount;
    private int nopCount;
    private int unusedResultCount;
    private SideEffect.Level sideEffectThreshold = SideEffect.Level.NONE;

    public DeadRemovalStrategy(ExecutionGraphManipulator manipulator) {
        this.manipulator = manipulator;
        this.addresses = this.getValidAddresses(manipulator);
        this.exceptionHandlingAddresses = DeadRemovalStrategy.getExceptionHandlerAddresses(manipulator);
        this.unusedAssignmentCount = 0;
        this.uselessBranchCount = 0;
        this.unvisitedCount = 0;
        this.unusedResultCount = 0;
        this.nopCount = 0;
    }

    private static Set<Integer> getExceptionHandlerAddresses(ExecutionGraphManipulator manipulator) {
        int[] allAddresses = manipulator.getAddresses();
        Arrays.sort(allAddresses);
        int highestAddress = allAddresses[allAddresses.length - 1];
        HashSet<Integer> handlerAddresses = new HashSet<Integer>();
        List<BuilderTryBlock> tryBlocks = manipulator.getTryBlocks();
        for (BuilderTryBlock tryBlock : tryBlocks) {
            List<? extends BuilderExceptionHandler> handlers = tryBlock.getExceptionHandlers();
            block1: for (BuilderExceptionHandler builderExceptionHandler : handlers) {
                int address = builderExceptionHandler.getHandlerCodeAddress();
                BuilderInstruction instruction = manipulator.getInstruction(address);
                while (address < highestAddress) {
                    handlerAddresses.add(address);
                    if ((instruction = manipulator.getInstruction(address += instruction.getCodeUnits())).getOpcode().canContinue()) continue;
                    continue block1;
                }
            }
        }
        return handlerAddresses;
    }

    private static Set<Integer> getNormalRegistersAssigned(MethodState mState) {
        HashSet<Integer> assigned = new HashSet<Integer>();
        for (int register : mState.getRegistersAssigned()) {
            if (register < 0) continue;
            assigned.add(register);
        }
        for (int i = 0; i < mState.getParameterCount(); ++i) {
            int parameterRegister = mState.getParameterStart() + i;
            assigned.remove(parameterRegister);
        }
        return assigned;
    }

    private static boolean isAnyRegisterUsed(int address, Set<Integer> registers, ExecutionGraphManipulator graph) {
        List<ExecutionNode> children = graph.getChildren(address);
        Iterator<ExecutionNode> iterator = children.iterator();
        while (iterator.hasNext()) {
            HashSet<Integer> newRegisters = new HashSet<Integer>(registers);
            ExecutionNode child = iterator.next();
            if (!DeadRemovalStrategy.isAnyRegisterUsed(address, newRegisters, graph, child)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnyRegisterUsed(int address, Set<Integer> usedRegisters, ExecutionGraphManipulator graph, ExecutionNode node) {
        List<ExecutionNode> children;
        ExecutionNode current = node;
        HashSet<Integer> reassignedRegisters = new HashSet<Integer>();
        while (true) {
            MethodState mState = current.getContext().getMethodState();
            for (int register : usedRegisters) {
                if (mState.wasRegisterRead(register)) {
                    if (log.isTraceEnabled()) {
                        log.trace("r{} read after {} @{} with {}", register, address, current.getAddress(), current.getOp());
                    }
                    return true;
                }
                if (!mState.wasRegisterAssigned(register) || current.getOp() instanceof APutOp) continue;
                if (log.isTraceEnabled()) {
                    log.trace("r{} assigned after {} @{} with {}", register, address, current.getAddress(), current.getOp());
                }
                reassignedRegisters.add(register);
            }
            usedRegisters.removeAll(reassignedRegisters);
            if (usedRegisters.isEmpty()) {
                return false;
            }
            children = current.getChildren();
            if (children.size() != 1) break;
            current = children.get(0);
        }
        Iterator<ExecutionNode> iterator = children.iterator();
        while (iterator.hasNext()) {
            HashSet<Integer> newRegisters = new HashSet<Integer>(usedRegisters);
            ExecutionNode child = iterator.next();
            if (!DeadRemovalStrategy.isAnyRegisterUsed(address, newRegisters, graph, child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Integer> getOptimizationCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("dead ops removed", this.unvisitedCount);
        counts.put("dead assignments removed", this.unusedAssignmentCount);
        counts.put("dead results removed", this.unusedResultCount);
        counts.put("useless gotos removed", this.uselessBranchCount);
        counts.put("nops removed", this.nopCount);
        return counts;
    }

    @Override
    public boolean perform() {
        this.addresses = this.getValidAddresses(this.manipulator);
        this.exceptionHandlingAddresses = DeadRemovalStrategy.getExceptionHandlerAddresses(this.manipulator);
        HashSet<Integer> removeSet = new HashSet<Integer>();
        List<Integer> removeAddresses = this.getDeadAddresses();
        this.unvisitedCount += removeAddresses.size();
        removeSet.addAll(removeAddresses);
        removeAddresses = this.getDeadAssignmentAddresses();
        this.unusedAssignmentCount += removeAddresses.size();
        removeSet.addAll(removeAddresses);
        removeAddresses = this.getDeadResultAddresses();
        this.unusedResultCount += removeAddresses.size();
        removeSet.addAll(removeAddresses);
        removeAddresses = this.getUselessBranchAddresses();
        this.uselessBranchCount += removeAddresses.size();
        removeSet.addAll(removeAddresses);
        removeAddresses = this.getNopAddresses();
        this.nopCount += removeAddresses.size();
        removeSet.addAll(removeAddresses);
        LinkedList<Integer> deadAddresses = new LinkedList<Integer>(removeSet);
        if (deadAddresses.size() > 0) {
            this.manipulator.removeInstructions(deadAddresses);
        }
        return !removeSet.isEmpty();
    }

    public void setRemoveWeak(boolean removeWeak) {
        if (removeWeak) {
            this.sideEffectThreshold = SideEffect.Level.WEAK;
        }
    }

    List<Integer> getDeadAddresses() {
        return this.addresses.stream().filter(this::isDead).collect(Collectors.toList());
    }

    List<Integer> getDeadAssignmentAddresses() {
        return this.addresses.stream().filter(this::isDeadAssignment).collect(Collectors.toList());
    }

    List<Integer> getDeadResultAddresses() {
        return this.addresses.stream().filter(this::isDeadResult).collect(Collectors.toList());
    }

    List<Integer> getImpotentMethodInvocations() {
        return this.addresses.stream().filter(this::isImpotentMethodInvocation).collect(Collectors.toList());
    }

    List<Integer> getNopAddresses() {
        return this.addresses.stream().filter(this::isNop).collect(Collectors.toList());
    }

    List<Integer> getUselessBranchAddresses() {
        return this.addresses.stream().filter(this::isUselessBranch).collect(Collectors.toList());
    }

    List<Integer> getValidAddresses(ExecutionGraphManipulator manipulator) {
        List<Integer> validAddresses = IntStream.of(manipulator.getAddresses()).boxed().collect(Collectors.toList());
        LinkedList<Object> invalidAddresses = new LinkedList<Object>();
        invalidAddresses.add(validAddresses.get(validAddresses.size() - 1));
        Iterator iterator = validAddresses.iterator();
        while (iterator.hasNext()) {
            int address = (Integer)iterator.next();
            if (!manipulator.wasAddressReached(address)) continue;
            Op op = manipulator.getOp(address);
            if (this.isSideEffectAboveThreshold(op.getSideEffectLevel())) {
                invalidAddresses.add(address);
                continue;
            }
            if (!op.getName().startsWith("invoke-direct") || !manipulator.getMethod().getSignature().contains(";-><init>(")) continue;
            ExecutionNode node = manipulator.getNodePile(address).get(0);
            ExecutionContext context = node.getContext();
            MethodState mState = context.getMethodState();
            StringBuilder sb = new StringBuilder("invoke-direct {r");
            sb.append(mState.getParameterStart() - 1);
            if (!op.toString().startsWith(sb.toString())) continue;
            invalidAddresses.add(address);
        }
        validAddresses.removeAll(invalidAddresses);
        return validAddresses;
    }

    private boolean isDead(int address) {
        int nextAddress;
        Opcode nextOp;
        Op op = this.manipulator.getOp(address);
        log.debug("Dead test @{} for: {}", (Object)address, (Object)op);
        if (this.exceptionHandlingAddresses.contains(address)) {
            return false;
        }
        if (this.manipulator.wasAddressReached(address)) {
            return false;
        }
        if (op instanceof GotoOp) {
            return false;
        }
        return !(op instanceof NopOp) || (nextOp = this.manipulator.getLocation(nextAddress = address + op.getLocation().getInstruction().getCodeUnits()).getInstruction().getOpcode()) != Opcode.ARRAY_PAYLOAD;
    }

    private boolean isDeadAssignment(int address) {
        String returnType;
        if (!this.manipulator.wasAddressReached(address)) {
            return false;
        }
        ExecutionNode node = this.manipulator.getNodePile(address).get(0);
        ExecutionContext context = node.getContext();
        if (context == null) {
            if (log.isWarnEnabled()) {
                log.warn("Null execution context @{}. This shouldn't happen!", (Object)address);
            }
            return false;
        }
        MethodState mState = context.getMethodState();
        Set<Integer> assigned = DeadRemovalStrategy.getNormalRegistersAssigned(mState);
        if (assigned.isEmpty()) {
            return false;
        }
        Op op = this.manipulator.getOp(address);
        if (this.isSideEffectAboveThreshold(op.getSideEffectLevel())) {
            return false;
        }
        if (op instanceof InvokeOp && !"V".equals(returnType = ((InvokeOp)op).getReturnType())) {
            return false;
        }
        log.debug("Dead assignments test @{} for: {}", (Object)address, (Object)op);
        return !DeadRemovalStrategy.isAnyRegisterUsed(address, assigned, this.manipulator);
    }

    private boolean isDeadResult(int address) {
        if (!this.manipulator.wasAddressReached(address)) {
            return false;
        }
        Op op = this.manipulator.getOp(address);
        if (!(op instanceof InvokeOp)) {
            return false;
        }
        log.debug("Dead result test @{} for: {}", (Object)address, (Object)op);
        if (this.isSideEffectAboveThreshold(op.getSideEffectLevel())) {
            return false;
        }
        String returnType = ((InvokeOp)op).getReturnType();
        if ("V".equals(returnType)) {
            return false;
        }
        BuilderInstruction instruction = this.manipulator.getInstruction(address);
        int nextAddress = address + instruction.getCodeUnits();
        BuilderInstruction nextInstr = this.manipulator.getInstruction(nextAddress);
        if (nextInstr == null) {
            return false;
        }
        if (nextInstr.getOpcode().name.startsWith("move-result")) {
            return false;
        }
        ExecutionNode node = this.manipulator.getNodePile(address).get(0);
        ExecutionContext context = node.getContext();
        MethodState mState = context.getMethodState();
        Set<Integer> assigned = DeadRemovalStrategy.getNormalRegistersAssigned(mState);
        return 0 >= assigned.size() || !DeadRemovalStrategy.isAnyRegisterUsed(address, assigned, this.manipulator);
    }

    private boolean isImpotentMethodInvocation(int address) {
        return false;
    }

    private boolean isNop(int address) {
        if (!this.manipulator.wasAddressReached(address)) {
            return false;
        }
        Op op = this.manipulator.getOp(address);
        return op instanceof NopOp;
    }

    private boolean isSideEffectAboveThreshold(SideEffect.Level level) {
        return level.compareTo(this.sideEffectThreshold) > 0;
    }

    private boolean isUselessBranch(int address) {
        Op op = this.manipulator.getOp(address);
        if (!(op instanceof GotoOp)) {
            return false;
        }
        OffsetInstruction instruction = (OffsetInstruction)((Object)this.manipulator.getInstruction(address));
        int branchOffset = instruction.getCodeOffset();
        return branchOffset == instruction.getCodeUnits();
    }
}

