/*
 * Decompiled with CFR 0.152.
 */
package org.cf.simplify.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cf.simplify.ConstantBuilder;
import org.cf.simplify.Dependency;
import org.cf.simplify.ExecutionGraphManipulator;
import org.cf.simplify.strategy.OptimizationStrategy;
import org.cf.smalivm.context.HeapItem;
import org.cf.smalivm.opcode.Op;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantPropagationStrategy
implements OptimizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(ConstantPropagationStrategy.class.getSimpleName());
    private final ExecutionGraphManipulator manipulator;
    protected ConstantBuilder constantBuilder;
    private int constantCount;
    private boolean madeChanges;

    public ConstantPropagationStrategy(ExecutionGraphManipulator manipulator) {
        this.getDependencies();
        this.manipulator = manipulator;
        this.constantCount = 0;
    }

    @Override
    public Map<String, Integer> getOptimizationCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("constantized ops", this.constantCount);
        return counts;
    }

    @Override
    public boolean perform() {
        this.madeChanges = false;
        List<Integer> addresses = this.getValidAddresses();
        Collections.sort(addresses, Collections.reverseOrder());
        for (int address : addresses) {
            this.madeChanges = true;
            BuilderInstruction original = this.manipulator.getInstruction(address);
            BuilderInstruction constInstruction = ConstantBuilder.buildConstant(address, this.manipulator);
            boolean isReturn = original.getOpcode().name().startsWith("RETURN");
            if (isReturn) {
                this.manipulator.addInstruction(address, constInstruction);
            } else {
                this.manipulator.replaceInstruction(address, constInstruction);
            }
            ++this.constantCount;
        }
        return this.madeChanges;
    }

    protected void getDependencies() {
        if (this.constantBuilder == null) {
            this.constantBuilder = new ConstantBuilder();
        }
    }

    protected void setDependencies(Dependency dependency) {
        this.constantBuilder = (ConstantBuilder)dependency;
    }

    private boolean canConstantizeAddress(int address) {
        String type;
        if (!this.manipulator.wasAddressReached(address)) {
            return false;
        }
        Op op = this.manipulator.getOp(address);
        if (!this.constantBuilder.canConstantizeOp(op)) {
            return false;
        }
        OneRegisterInstruction instruction = (OneRegisterInstruction)((Object)this.manipulator.getInstruction(address));
        if (instruction == null) {
            return false;
        }
        int register = instruction.getRegisterA();
        HeapItem consensus = this.manipulator.getRegisterConsensus(address, register);
        if (consensus == null || consensus.isUnknown()) {
            return false;
        }
        String string = type = consensus.isPrimitive() ? consensus.getType() : consensus.getValueType();
        return this.constantBuilder.canConstantizeType(type);
    }

    private List<Integer> getValidAddresses() {
        return IntStream.of(this.manipulator.getAddresses()).boxed().filter(this::canConstantizeAddress).collect(Collectors.toList());
    }
}

