import hashlib
import pprint
import sys
import time


from pyasn1.codec.der import encoder as der_encoder

import auth_data
import fingerprint
import pecoff_blob
from asn1 import dn

import re
import os
import sys

def main():
	
	print ("SigSpotter 1.0\n")
	print ("Security By Default http://www.securitybydefault.com\n")
	
	if len(sys.argv) < 2:     sys.exit('Usage: %s path' % sys.argv[0]) 
	
	publishers = []
	
	drive = sys.argv[1]
	
	logfile = open("sigspotter.log","w") 
	
	rootdir = sys.argv[1]
	for dirname, dirnames, filenames in os.walk(rootdir):
		 for filename in filenames:
			 filez = os.path.join(dirname, filename)
			 
			 if os.path.isfile(filez):
				
				curFileExtention = filez[-3:]

				if curFileExtention in ['exe', 'dll', 'ocx', 'sys']:
					
					data_file = filez
					
					#print filez
					try:
						with file(data_file, 'rb') as objf:
							fingerprinter = fingerprint.Fingerprinter(objf)
							is_pecoff = fingerprinter.EvalPecoff()
							fingerprinter.EvalGeneric()
							results = fingerprinter.HashIt()
					except:
						continue

					if is_pecoff:
						signed_pecoffs = [x for x in results if x['name'] == 'pecoff' and'SignedData' in x]

						if signed_pecoffs:
	
							signed_pecoff = signed_pecoffs[0]

							signed_datas = signed_pecoff['SignedData']
	
							signed_data = signed_datas[0]
							
							try:
								blob = pecoff_blob.PecoffBlob(signed_data)
							except:
								continue
							
							try:
								auth = auth_data.AuthData(blob.getCertificateBlob())
							except:
								continue
	
							formated= pprint.pformat(auth.signing_cert_id)
	
							for (issuer, serial), cert in auth.certificates.items():
		
								regex = re.compile('.*%s.*'% serial) 
		
								matchObj= regex.search(formated)
		
								if matchObj:
									subject = cert[0][0]['subject']
									subject_dn = str(dn.DistinguishedName.TraverseRdn(subject[0]))
			
									pubsearch =  re.search( r'.*\'CN\': \'(.*)\', \'L\'', subject_dn)
									if pubsearch:
										#print "Publisher:", pubsearch.group(1)
										logfile.write("File: %s --> Publisher: %s\n" % (data_file, pubsearch.group(1)) )
										if pubsearch.group(1) not in publishers:
											publishers.append(pubsearch.group(1))
	logfile.close()
	print ("Publishers found:\n")
	for pub in publishers:
		print pub	
	
if __name__ == '__main__':
	main()
	
	
	
	
	
	
	
	
	