/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.management.transceiver;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import javolution.util.FastSet;
import org.mobicents.ss7.management.transceiver.ChannelProvider;
import org.mobicents.ss7.management.transceiver.ChannelSelectionKey;
import org.mobicents.ss7.management.transceiver.ShellChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelSelector {
    protected Selector selector;
    private FastSet<ChannelSelectionKey> selectedKey = new FastSet();

    protected ChannelSelector(Selector selector) {
        this.selector = selector;
    }

    public static ChannelSelector open() throws IOException {
        return ChannelProvider.provider().openSelector();
    }

    public FastSet<ChannelSelectionKey> selectNow() throws IOException {
        this.selectedKey.clear();
        this.selector.selectNow();
        Set<SelectionKey> selection = this.selector.selectedKeys();
        for (SelectionKey key : selection) {
            ChannelSelectionKey k;
            if (key.isAcceptable()) {
                k = (ChannelSelectionKey)key.attachment();
                this.selectedKey.add(k);
                continue;
            }
            if (key.isReadable()) {
                k = (ChannelSelectionKey)key.attachment();
                ((ShellChannel)k.channel()).doRead();
                if (k.isReadable()) {
                    this.selectedKey.add(k);
                }
            }
            if (!key.isWritable()) continue;
            k = (ChannelSelectionKey)key.attachment();
            ((ShellChannel)k.channel()).doWrite();
            if (!k.isWritable()) continue;
            this.selectedKey.add(k);
        }
        selection.clear();
        return this.selectedKey;
    }

    public void close() throws IOException {
        this.selector.close();
    }
}

