/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.linkset.oam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.ss7.linkset.oam.Layer4;
import org.mobicents.ss7.linkset.oam.Link;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetFactoryFactory;
import org.mobicents.ss7.linkset.oam.LinksetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksetManagerImpl
implements LinksetManager {
    private static final Logger logger = Logger.getLogger(LinksetManagerImpl.class);
    private static final String LINKSET = "linkset";
    private static final String LINK = "link";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String LINKSET_PERSIST_DIR_KEY = "linkset.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "linksetmanager.xml";
    private static final String TAB_INDENT = "\t";
    private static final XMLBinding binding = new XMLBinding();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private String persistDir = null;
    private FastMap<String, Linkset> linksets = new FastMap().shared();
    private LinksetFactoryFactory linksetFactoryFactory = null;
    private Layer4 layer4 = null;
    private Scheduler scheduler;
    private String name;

    public LinksetManagerImpl(String name) {
        this.name = name;
        binding.setAlias(Linkset.class, LINKSET);
        binding.setAlias(Link.class, LINK);
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public LinksetFactoryFactory getLinksetFactoryFactory() {
        return this.linksetFactoryFactory;
    }

    @Override
    public void setLinksetFactoryFactory(LinksetFactoryFactory linksetFactoryFactory) {
        this.linksetFactoryFactory = linksetFactoryFactory;
    }

    @Override
    public FastMap<String, Linkset> getLinksets() {
        return this.linksets;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public Layer4 getLayer4() {
        return this.layer4;
    }

    @Override
    public void setLayer4(Layer4 layer4) {
        this.layer4 = layer4;
    }

    @Override
    public void start() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(LINKSET_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(PERSIST_FILE_NAME);
        }
        logger.info(String.format("SS7 configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        logger.info("Started LinksetManager");
    }

    @Override
    public void stop() {
        this.store();
    }

    @Override
    public String showLinkset(String[] options) throws Exception {
        StringBuffer sb = new StringBuffer();
        FastCollection.Record e = this.linksets.head();
        FastMap.Entry<String, Linkset> end = this.linksets.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Linkset linkset = (Linkset)((FastMap.Entry)e).getValue();
            linkset.print(sb, 0, 4);
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    @Override
    public String createLinkset(String[] options) throws Exception {
        Linkset linkset = null;
        linkset = this.linksetFactoryFactory.createLinkset(options);
        if (linkset == null) {
            return "Invalid Command";
        }
        if (this.linksets.containsKey(linkset.getName())) {
            return "LinkSet already exist";
        }
        this.linksets.put(linkset.getName(), linkset);
        this.store();
        if (this.layer4 != null) {
            this.layer4.add(linkset);
        }
        return "LinkSet successfully added";
    }

    @Override
    public String deleteLinkset(String[] options) throws Exception {
        String linksetName = options[options.length - 1];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        if (linkset.getState() == 3) {
            throw new Exception("Linkset is Available. Can't delete. Please deactivate all links within Linkset and remove each of them before removing this linkset");
        }
        this.linksets.remove(linksetName);
        this.store();
        if (this.layer4 != null) {
            this.layer4.remove(linkset);
        }
        return "LinkSet successfully removed";
    }

    @Override
    public String activateLinkset(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 1];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        linkset.activate();
        return "LinkSet activated  successfully";
    }

    @Override
    public String deactivateLinkset(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 1];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        linkset.deactivate();
        return "Link activated successfully";
    }

    @Override
    public String createLink(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 2];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        linkset.createLink(options);
        this.store();
        return "Link successfully added";
    }

    @Override
    public String deleteLink(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 2];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        linkset.deleteLink(options[options.length - 1]);
        this.store();
        return "Link successfully removed";
    }

    @Override
    public String activateLink(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 2];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        String linkName = options[options.length - 1];
        if (linkName == null) {
            throw new Exception("Invalid Command");
        }
        linkset.activateLink(linkName);
        return "Link activated successfully";
    }

    @Override
    public String deactivateLink(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        String linksetName = options[options.length - 2];
        if (linksetName == null) {
            throw new Exception("Invalid Command");
        }
        Linkset linkset = this.linksets.get(linksetName);
        if (linkset == null) {
            throw new Exception("LinkSet doesn't exist");
        }
        String linkName = options[options.length - 1];
        if (linkName == null) {
            throw new Exception("Invalid Command");
        }
        linkset.deactivateLink(linkName);
        return "Link activated successfully";
    }

    protected void store() {
        this.linksetFactoryFactory.loadBinding(binding);
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            FastCollection.Record e = this.linksets.head();
            FastMap.Entry<String, Linkset> end = this.linksets.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Linkset value = (Linkset)((FastMap.Entry)e).getValue();
                writer.write(value);
            }
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error while persisting the state in file", e);
        }
    }

    protected void load() throws FileNotFoundException {
        this.linksetFactoryFactory.loadBinding(binding);
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            while (reader.hasNext()) {
                Linkset linkset = (Linkset)reader.read();
                linkset.setScheduler(this.scheduler);
                linkset.activateLinks();
                try {
                    linkset.activate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.linksets.put(linkset.getName(), linkset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        LinksetManagerImpl linkSetManager = new LinksetManagerImpl("LinksetManager");
        LinksetFactoryFactory linksetFactoryFactory = new LinksetFactoryFactory();
        linkSetManager.setLinksetFactoryFactory(linksetFactoryFactory);
        linkSetManager.createLinkset("dahdi opc 1 dpc 2 ni 3 linkset1".split(" "));
        linkSetManager.store();
        LinksetManagerImpl linkSetManager1 = new LinksetManagerImpl("LinksetManager");
        linkSetManager1.load();
        System.out.println(linkSetManager1.linksets.size());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

