/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javolution.text.TextBuilder;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPCounterProviderImpl;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;

public class TCAPStackImpl
implements TCAPStack {
    private final Logger logger;
    protected static final String TCAP_MANAGEMENT_PERSIST_DIR_KEY = "tcapmanagement.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    protected static final String PERSIST_FILE_NAME = "management.xml";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final String DIALOG_IDLE_TIMEOUT = "dialogidletimeout";
    private static final String INVOKE_TIMEOUT = "invoketimeout";
    private static final String MAX_DIALOGS = "maxdialogs";
    private static final String DIALOG_ID_RANGE_START = "dialogidrangestart";
    private static final String DIALOG_ID_RANGE_END = "dialogidrangeend";
    private static final String PREVIEW_MODE = "previewmode";
    private static final String DO_NOT_SEND_PROTOCOL_VERSION = "donotsendprotocolversion";
    private static final String STATISTICS_ENABLED = "statisticsenabled";
    private static final XMLBinding binding = new XMLBinding();
    public static final long _DIALOG_TIMEOUT = 60000L;
    public static final long _INVOKE_TIMEOUT = 30000L;
    public static final int _MAX_DIALOGS = 5000;
    public static final long _EMPTY_INVOKE_TIMEOUT = -1L;
    protected TCAPProviderImpl tcapProvider;
    protected TCAPCounterProviderImpl tcapCounterProvider;
    private SccpProvider sccpProvider;
    private SccpAddress address;
    private final String name;
    protected final TextBuilder persistFile = TextBuilder.newInstance();
    protected String persistDir = null;
    private volatile boolean started = false;
    private long dialogTimeout = 60000L;
    private long invokeTimeout = 30000L;
    protected int maxDialogs = 5000;
    private long dialogIdRangeStart = 1L;
    private long dialogIdRangeEnd = Integer.MAX_VALUE;
    private boolean previewMode = false;
    private boolean doNotSendProtocolVersion = false;
    private boolean statisticsEnabled = false;
    private int ssn = -1;

    public TCAPStackImpl(String name) {
        this.name = name;
        this.logger = Logger.getLogger(TCAPStackImpl.class.getCanonicalName() + "-" + this.name);
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        this.setPersistFile();
    }

    public TCAPStackImpl(String name, SccpProvider sccpProvider, int ssn) {
        this(name);
        this.sccpProvider = sccpProvider;
        this.tcapProvider = new TCAPProviderImpl(sccpProvider, this, ssn);
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.ssn = ssn;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public int getSubSystemNumber() {
        return this.ssn;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
        this.setPersistFile();
    }

    private void setPersistFile() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(TCAP_MANAGEMENT_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
    }

    public void start() throws Exception {
        this.logger.info("Starting ..." + this.tcapProvider);
        this.logger.info(String.format("TCAP Management configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            this.logger.warn(String.format("Failed to load the TCAP Management configuration file. \n%s", e.getMessage()));
        }
        if (this.dialogTimeout < 0L) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to zero.");
        }
        if (this.dialogTimeout < this.invokeTimeout) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to invoke timeout.");
        }
        if (this.invokeTimeout < 0L) {
            throw new IllegalArgumentException("InvokeTimeout value must be greater or equal to zero.");
        }
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.tcapProvider.start();
        this.started = true;
    }

    private void checkDialogIdRangeValues(long rangeStart, long rangeEnd) {
        if (rangeStart >= rangeEnd) {
            throw new IllegalArgumentException("Range start value cannot be equal/greater than Range end value");
        }
        if (rangeStart < 1L) {
            throw new IllegalArgumentException("Range start value must be greater or equal 1");
        }
        if (rangeEnd > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range end value must be less or equal 2147483647");
        }
        if (rangeEnd - rangeStart < 10000L) {
            throw new IllegalArgumentException("Range \"end - start\" must has at least 10000 possible dialogs");
        }
        if (rangeEnd - rangeStart <= (long)this.maxDialogs) {
            throw new IllegalArgumentException("MaxDialog must be less than DialogIdRange");
        }
    }

    public void stop() {
        this.tcapProvider.stop();
        this.started = false;
        this.store();
    }

    public boolean isStarted() {
        return this.started;
    }

    public TCAPProvider getProvider() {
        return this.tcapProvider;
    }

    public TCAPCounterProvider getCounterProvider() {
        return this.tcapCounterProvider;
    }

    public TCAPCounterProviderImpl getCounterProviderImpl() {
        return this.tcapCounterProvider;
    }

    public void setDialogIdleTimeout(long v) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdleTimeout parameter can be updated only when TCAP stack is running");
        }
        if (v < 0L) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to zero.");
        }
        if (v < this.invokeTimeout) {
            throw new IllegalArgumentException("DialogIdleTimeout value must be greater or equal to invoke timeout.");
        }
        this.dialogTimeout = v;
        this.store();
    }

    public long getDialogIdleTimeout() {
        return this.dialogTimeout;
    }

    public void setInvokeTimeout(long v) throws Exception {
        if (!this.started) {
            throw new Exception("InvokeTimeout parameter can be updated only when TCAP stack is running");
        }
        if (v < 0L) {
            throw new IllegalArgumentException("InvokeTimeout value must be greater or equal to zero.");
        }
        if (v > this.dialogTimeout) {
            throw new IllegalArgumentException("InvokeTimeout value must be smaller or equal to dialog timeout.");
        }
        this.invokeTimeout = v;
        this.store();
    }

    public long getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public void setMaxDialogs(int v) throws Exception {
        if (!this.started) {
            throw new Exception("MaxDialogs parameter can be updated only when TCAP stack is running");
        }
        if (v < 1) {
            throw new IllegalArgumentException("At least one Dialog must be accepted");
        }
        if ((long)v >= this.dialogIdRangeEnd - this.dialogIdRangeStart) {
            throw new IllegalArgumentException("MaxDialog must be less than DialogIdRange");
        }
        this.maxDialogs = v;
        this.store();
    }

    public int getMaxDialogs() {
        return this.maxDialogs;
    }

    public void setDialogIdRangeStart(long val) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdRangeStart parameter can be updated only when TCAP stack is running");
        }
        this.checkDialogIdRangeValues(val, this.getDialogIdRangeEnd());
        this.dialogIdRangeStart = val;
        this.store();
    }

    public void setDialogIdRangeEnd(long val) throws Exception {
        if (!this.started) {
            throw new Exception("DialogIdRangeEnd parameter can be updated only when TCAP stack is running");
        }
        this.checkDialogIdRangeValues(this.getDialogIdRangeStart(), val);
        this.dialogIdRangeEnd = val;
        this.store();
    }

    public long getDialogIdRangeStart() {
        return this.dialogIdRangeStart;
    }

    public long getDialogIdRangeEnd() {
        return this.dialogIdRangeEnd;
    }

    public void setPreviewMode(boolean val) throws Exception {
        if (this.started) {
            throw new Exception("PreviewMode parameter can be updated only when TCAP stack is NOT running");
        }
        this.previewMode = val;
    }

    public boolean getPreviewMode() {
        return this.previewMode;
    }

    public void setDoNotSendProtocolVersion(boolean val) throws Exception {
        if (!this.started) {
            throw new Exception("DoNotSendProtocolVersion parameter can be updated only when TCAP stack is running");
        }
        this.doNotSendProtocolVersion = val;
        this.store();
    }

    public boolean getDoNotSendProtocolVersion() {
        return this.doNotSendProtocolVersion;
    }

    public void setStatisticsEnabled(boolean val) throws Exception {
        if (!this.started) {
            throw new Exception("StatisticsEnabled parameter can be updated only when TCAP stack is running");
        }
        this.tcapCounterProvider = new TCAPCounterProviderImpl(this.tcapProvider);
        this.statisticsEnabled = val;
        this.store();
    }

    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.dialogTimeout, DIALOG_IDLE_TIMEOUT, Long.class);
            writer.write(this.invokeTimeout, INVOKE_TIMEOUT, Long.class);
            writer.write(this.maxDialogs, MAX_DIALOGS, Integer.class);
            writer.write(this.dialogIdRangeStart, DIALOG_ID_RANGE_START, Long.class);
            writer.write(this.dialogIdRangeEnd, DIALOG_ID_RANGE_END, Long.class);
            writer.write(this.doNotSendProtocolVersion, DO_NOT_SEND_PROTOCOL_VERSION, Boolean.class);
            writer.write(this.statisticsEnabled, STATISTICS_ENABLED, Boolean.class);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error(String.format("Error while persisting the TCAP Resource state in file=%s", this.persistFile.toString()), e);
        }
    }

    protected void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            Integer vali;
            reader = XMLObjectReader.newInstance(new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            Long vall = reader.read(DIALOG_IDLE_TIMEOUT, Long.class);
            if (vall != null) {
                this.dialogTimeout = vall;
            }
            if ((vall = reader.read(INVOKE_TIMEOUT, Long.class)) != null) {
                this.invokeTimeout = vall;
            }
            if ((vali = reader.read(MAX_DIALOGS, Integer.class)) != null) {
                this.maxDialogs = vali;
            }
            if ((vall = reader.read(DIALOG_ID_RANGE_START, Long.class)) != null) {
                this.dialogIdRangeStart = vall;
            }
            if ((vall = reader.read(DIALOG_ID_RANGE_END, Long.class)) != null) {
                this.dialogIdRangeEnd = vall;
            }
            Boolean volb = reader.read(PREVIEW_MODE, Boolean.class);
            volb = reader.read(DO_NOT_SEND_PROTOCOL_VERSION, Boolean.class);
            if (volb != null) {
                this.doNotSendProtocolVersion = volb;
            }
            if ((volb = reader.read(STATISTICS_ENABLED, Boolean.class)) != null) {
                this.statisticsEnabled = volb;
            }
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

