/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.AllocationRetentionPriority;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.EPSQoSSubscribed;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.QoSClassIdentifier;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.AllocationRetentionPriorityImpl;

public class EPSQoSSubscribedImpl
extends SequenceBase
implements EPSQoSSubscribed {
    private static final int _TAG_qoSClassIdentifier = 0;
    private static final int _TAG_allocationRetentionPriority = 1;
    private static final int _TAG_extensionContainer = 2;
    private QoSClassIdentifier qoSClassIdentifier;
    private AllocationRetentionPriority allocationRetentionPriority;
    private MAPExtensionContainer extensionContainer;

    public EPSQoSSubscribedImpl() {
        super("EPSQoSSubscribed");
    }

    public EPSQoSSubscribedImpl(QoSClassIdentifier qoSClassIdentifier, AllocationRetentionPriority allocationRetentionPriority, MAPExtensionContainer extensionContainer) {
        super("EPSQoSSubscribed");
        this.qoSClassIdentifier = qoSClassIdentifier;
        this.allocationRetentionPriority = allocationRetentionPriority;
        this.extensionContainer = extensionContainer;
    }

    public QoSClassIdentifier getQoSClassIdentifier() {
        return this.qoSClassIdentifier;
    }

    public AllocationRetentionPriority getAllocationRetentionPriority() {
        return this.allocationRetentionPriority;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.qoSClassIdentifier = null;
        this.allocationRetentionPriority = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 0 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".qoSClassIdentifier: Parameter bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int qos = (int)ais.readInteger();
                    this.qoSClassIdentifier = QoSClassIdentifier.getInstance(qos);
                    break;
                }
                case 1: {
                    if (tag != 1 || ais.getTagClass() != 2 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".allocationRetentionPriority: Parameter bad tag, tag class or primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.allocationRetentionPriority = new AllocationRetentionPriorityImpl();
                    ((AllocationRetentionPriorityImpl)this.allocationRetentionPriority).decodeAll(ais);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.qoSClassIdentifier == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament qoSClassIdentifier is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.allocationRetentionPriority == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament allocationRetentionPriority is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.qoSClassIdentifier == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter qoSClassIdentifier is not defined");
        }
        if (this.allocationRetentionPriority == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter allocationRetentionPriority is not defined");
        }
        try {
            if (this.qoSClassIdentifier != null) {
                asnOs.writeInteger(2, 0, this.qoSClassIdentifier.getCode());
            }
            ((AllocationRetentionPriorityImpl)this.allocationRetentionPriority).encodeAll(asnOs, 2, 1);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.qoSClassIdentifier != null) {
            sb.append("qoSClassIdentifier=");
            sb.append(this.qoSClassIdentifier.toString());
            sb.append(", ");
        }
        if (this.allocationRetentionPriority != null) {
            sb.append("allocationRetentionPriority=");
            sb.append(this.allocationRetentionPriority.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

