/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.callhandling.MAPDialogCallHandling;
import org.mobicents.protocols.ss7.map.api.service.callhandling.MAPServiceCallHandling;
import org.mobicents.protocols.ss7.map.api.service.callhandling.MAPServiceCallHandlingListener;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.IstCommandRequestImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.IstCommandResponseImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.MAPDialogCallHandlingImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.ProvideRoamingNumberRequestImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.ProvideRoamingNumberResponseImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.SendRoutingInformationRequestImpl;
import org.mobicents.protocols.ss7.map.service.callhandling.SendRoutingInformationResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceCallHandlingImpl
extends MAPServiceBaseImpl
implements MAPServiceCallHandling {
    private static final Logger loger = Logger.getLogger(MAPServiceCallHandlingImpl.class);
    protected static final int version = 3;

    public MAPServiceCallHandlingImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogCallHandling createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogCallHandling createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogRoutingInformation because MAPServiceRoutingInformation is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogCallHandlingImpl dialog = new MAPDialogCallHandlingImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogCallHandlingImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceCallHandlingListener mapServiceListener) {
        super.addMAPServiceListener(mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceCallHandlingListener mapServiceListener) {
        super.removeMAPServiceListener(mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case locationInfoRetrievalContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case roamingNumberEnquiryContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case ServiceTerminationContext: {
                if (vers == 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        switch (operationCode) {
            case 22: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.locationInfoRetrievalContext, MAPApplicationContextVersion.version1);
            }
            case 4: {
                return MAPApplicationContext.getInstance(MAPApplicationContextName.roamingNumberEnquiryContext, MAPApplicationContextVersion.version1);
            }
        }
        return null;
    }

    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        if (compType == ComponentType.Invoke && this.mapProviderImpl.isCongested()) {
            return;
        }
        MAPDialogCallHandlingImpl mapDialogImpl = (MAPDialogCallHandlingImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        int vers = mapDialog.getApplicationContext().getApplicationContextVersion().getVersion();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 22: {
                if (compType == ComponentType.Invoke) {
                    this.sendRoutingInformationRequest(parameter, mapDialogImpl, invokeId);
                    break;
                }
                if (compType != ComponentType.ReturnResult && compType != ComponentType.ReturnResultLast) break;
                this.sendRoutingInformationResponse(parameter, mapDialogImpl, invokeId);
                break;
            }
            case 4: {
                if (compType == ComponentType.Invoke) {
                    this.provideRoamingNumberRequest(parameter, mapDialogImpl, invokeId);
                    break;
                }
                if (compType != ComponentType.ReturnResult && compType != ComponentType.ReturnResultLast) break;
                this.provideRoamingNumberResponse(parameter, mapDialogImpl, invokeId);
                break;
            }
            case 88: {
                if (compType == ComponentType.Invoke) {
                    this.istCommandRequest(parameter, mapDialogImpl, invokeId);
                    break;
                }
                if (compType != ComponentType.ReturnResult && compType != ComponentType.ReturnResultLast) break;
                this.istCommandResponse(parameter, mapDialogImpl, invokeId);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceCallHandling: unknown incoming operation code: " + ocValueInt, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void sendRoutingInformationRequest(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        SendRoutingInformationRequestImpl ind = new SendRoutingInformationRequestImpl(version);
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInformationRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInformationRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onSendRoutingInformationRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing SendRoutingInformationRequestIndication: " + e.getMessage(), e);
            }
        }
    }

    private void sendRoutingInformationResponse(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        SendRoutingInformationResponseImpl ind = new SendRoutingInformationResponseImpl(version);
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInformationResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version >= 3L ? parameter.getTag() != 3 || parameter.getTagClass() != 2 || parameter.isPrimitive() : parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInformationResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onSendRoutingInformationResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing SendRoutingInformationResponseIndication: " + e.getMessage(), e);
            }
        }
    }

    private void provideRoamingNumberRequest(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        ProvideRoamingNumberRequestImpl ind = new ProvideRoamingNumberRequestImpl(version);
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideRoamingNumberRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProvideRoamingNumberRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onProvideRoamingNumberRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing ProvideRoamingNumberRequestIndication: " + e.getMessage(), e);
            }
        }
    }

    private void provideRoamingNumberResponse(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        ProvideRoamingNumberResponseImpl ind = new ProvideRoamingNumberResponseImpl(version);
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideRoamingNumberResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version >= 3L ? parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive() : parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProvideRoamingNumberResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onProvideRoamingNumberResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing ProvideRoamingNumberResponseIndication: " + e.getMessage(), e);
            }
        }
    }

    private void istCommandRequest(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        IstCommandRequestImpl ind = new IstCommandRequestImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding IstCommandRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding IstCommandRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onIstCommandRequest(ind);
            }
            catch (Exception e) {
                loger.error("Error processing IstCommandRequest: " + e.getMessage(), e);
            }
        }
    }

    private void istCommandResponse(Parameter parameter, MAPDialogCallHandlingImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        IstCommandResponseImpl ind = new IstCommandResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding IstCommandResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage(ind);
                ((MAPServiceCallHandlingListener)serLis).onIstCommandResponse(ind);
            }
            catch (Exception e) {
                loger.error("Error processing IstCommandResponse: " + e.getMessage(), e);
            }
        }
    }
}

