/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.PlayAnnouncementRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.InformationToSend;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.InformationToSendImpl;

public class PlayAnnouncementRequestImpl
extends CircuitSwitchedCallMessageImpl
implements PlayAnnouncementRequest {
    public static final int _ID_informationToSend = 0;
    public static final int _ID_disconnectFromIPForbidden = 1;
    public static final int _ID_requestAnnouncementCompleteNotification = 2;
    public static final int _ID_extensions = 3;
    public static final int _ID_callSegmentID = 5;
    public static final int _ID_requestAnnouncementStartedNotification = 51;
    public static final String _PrimitiveName = "PlayAnnouncementRequestIndication";
    private InformationToSend informationToSend;
    private Boolean disconnectFromIPForbidden;
    private Boolean requestAnnouncementCompleteNotification;
    private CAPExtensions extensions;
    private Integer callSegmentID;
    private Boolean requestAnnouncementStartedNotification;

    public PlayAnnouncementRequestImpl() {
    }

    public PlayAnnouncementRequestImpl(InformationToSend informationToSend, Boolean disconnectFromIPForbidden, Boolean requestAnnouncementCompleteNotification, CAPExtensions extensions, Integer callSegmentID, Boolean requestAnnouncementStartedNotification) {
        this.informationToSend = informationToSend;
        this.disconnectFromIPForbidden = disconnectFromIPForbidden;
        this.requestAnnouncementCompleteNotification = requestAnnouncementCompleteNotification;
        this.extensions = extensions;
        this.callSegmentID = callSegmentID;
        this.requestAnnouncementStartedNotification = requestAnnouncementStartedNotification;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.playAnnouncement_Request;
    }

    public int getOperationCode() {
        return 47;
    }

    public InformationToSend getInformationToSend() {
        return this.informationToSend;
    }

    public Boolean getDisconnectFromIPForbidden() {
        return this.disconnectFromIPForbidden;
    }

    public Boolean getRequestAnnouncementCompleteNotification() {
        return this.requestAnnouncementCompleteNotification;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public Integer getCallSegmentID() {
        return this.callSegmentID;
    }

    public Boolean getRequestAnnouncementStartedNotification() {
        return this.requestAnnouncementStartedNotification;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding PlayAnnouncementRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding PlayAnnouncementRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding PlayAnnouncementRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding PlayAnnouncementRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.informationToSend = null;
        this.disconnectFromIPForbidden = null;
        this.requestAnnouncementCompleteNotification = null;
        this.extensions = null;
        this.callSegmentID = null;
        this.requestAnnouncementStartedNotification = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.informationToSend = new InformationToSendImpl();
                        ((InformationToSendImpl)this.informationToSend).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        this.disconnectFromIPForbidden = ais.readBoolean();
                        break;
                    }
                    case 2: {
                        this.requestAnnouncementCompleteNotification = ais.readBoolean();
                        break;
                    }
                    case 3: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 5: {
                        this.callSegmentID = (int)ais.readInteger();
                        break;
                    }
                    case 51: {
                        this.requestAnnouncementStartedNotification = ais.readBoolean();
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.informationToSend == null) {
            throw new CAPParsingComponentException("Error while decoding PlayAnnouncementRequestIndication: parameter informationToSend is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding PlayAnnouncementRequestIndication: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.informationToSend == null) {
            throw new CAPException("Error while encoding PlayAnnouncementRequestIndication: informationToSend must not be null");
        }
        try {
            aos.writeTag(2, false, 0);
            int pos = aos.StartContentDefiniteLength();
            ((InformationToSendImpl)this.informationToSend).encodeAll(aos);
            aos.FinalizeContent(pos);
            if (this.disconnectFromIPForbidden != null) {
                aos.writeBoolean(2, 1, this.disconnectFromIPForbidden);
            }
            if (this.requestAnnouncementCompleteNotification != null) {
                aos.writeBoolean(2, 2, this.requestAnnouncementCompleteNotification);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 3);
            }
            if (this.callSegmentID != null) {
                aos.writeInteger(2, 5, this.callSegmentID.intValue());
            }
            if (this.requestAnnouncementStartedNotification != null) {
                aos.writeBoolean(2, 51, this.requestAnnouncementStartedNotification);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding PlayAnnouncementRequestIndication: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding PlayAnnouncementRequestIndication: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.informationToSend != null) {
            sb.append(", informationToSend=");
            sb.append(this.informationToSend.toString());
        }
        if (this.disconnectFromIPForbidden != null) {
            sb.append(", disconnectFromIPForbidden=");
            sb.append(this.disconnectFromIPForbidden);
        }
        if (this.requestAnnouncementCompleteNotification != null) {
            sb.append(", requestAnnouncementCompleteNotification=");
            sb.append(this.requestAnnouncementCompleteNotification);
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.callSegmentID != null) {
            sb.append(", callSegmentID=");
            sb.append(this.callSegmentID);
        }
        if (this.requestAnnouncementStartedNotification != null) {
            sb.append(", requestAnnouncementStartedNotification=");
            sb.append(this.requestAnnouncementStartedNotification);
        }
        sb.append("]");
        return sb.toString();
    }
}

