/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.EsiGprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.EsiGprs.PDPContextEstablishmentSpecificInformation;
import org.mobicents.protocols.ss7.cap.api.primitives.TimeAndTimezone;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.AccessPointName;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.EndUserAddress;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPInitiationType;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.QualityOfService;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.cap.primitives.TimeAndTimezoneImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.AccessPointNameImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.EndUserAddressImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.QualityOfServiceImpl;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.LocationInformationGPRS;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.LocationInformationGPRSImpl;

public class PDPContextEstablishmentSpecificInformationImpl
extends SequenceBase
implements PDPContextEstablishmentSpecificInformation {
    public static final int _ID_accessPointName = 0;
    public static final int _ID_endUserAddress = 1;
    public static final int _ID_qualityOfService = 2;
    public static final int _ID_locationInformationGPRS = 3;
    public static final int _ID_timeAndTimezone = 4;
    public static final int _ID_pdpInitiationType = 5;
    public static final int _ID_secondaryPDPContext = 6;
    public static final int _ID_PDPContextEstablishmentSpecificInformation = 4;
    private AccessPointName accessPointName;
    private EndUserAddress endUserAddress;
    private QualityOfService qualityOfService;
    private LocationInformationGPRS locationInformationGPRS;
    private TimeAndTimezone timeAndTimezone;
    private PDPInitiationType pdpInitiationType;
    private boolean secondaryPDPContext;

    public PDPContextEstablishmentSpecificInformationImpl() {
        super("PdpContextchangeOfPositionSpecificInformation");
    }

    public PDPContextEstablishmentSpecificInformationImpl(AccessPointName accessPointName, EndUserAddress endUserAddress, QualityOfService qualityOfService, LocationInformationGPRS locationInformationGPRS, TimeAndTimezone timeAndTimezone, PDPInitiationType pdpInitiationType, boolean secondaryPDPContext) {
        super("PdpContextchangeOfPositionSpecificInformation");
        this.accessPointName = accessPointName;
        this.endUserAddress = endUserAddress;
        this.qualityOfService = qualityOfService;
        this.locationInformationGPRS = locationInformationGPRS;
        this.timeAndTimezone = timeAndTimezone;
        this.pdpInitiationType = pdpInitiationType;
        this.secondaryPDPContext = secondaryPDPContext;
    }

    public AccessPointName getAccessPointName() {
        return this.accessPointName;
    }

    public PDPInitiationType getPDPInitiationType() {
        return this.pdpInitiationType;
    }

    public boolean getSecondaryPDPContext() {
        return this.secondaryPDPContext;
    }

    public LocationInformationGPRS getLocationInformationGPRS() {
        return this.locationInformationGPRS;
    }

    public EndUserAddress getEndUserAddress() {
        return this.endUserAddress;
    }

    public QualityOfService getQualityOfService() {
        return this.qualityOfService;
    }

    public TimeAndTimezone getTimeAndTimezone() {
        return this.timeAndTimezone;
    }

    public int getTag() throws CAPException {
        return 16;
    }

    public int getTagClass() {
        return 2;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.accessPointName = null;
        this.endUserAddress = null;
        this.qualityOfService = null;
        this.locationInformationGPRS = null;
        this.timeAndTimezone = null;
        this.pdpInitiationType = null;
        this.secondaryPDPContext = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".accessPointName: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.accessPointName = new AccessPointNameImpl();
                        ((AccessPointNameImpl)this.accessPointName).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".endUserAddress: Parameter is  primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.endUserAddress = new EndUserAddressImpl();
                        ((EndUserAddressImpl)this.endUserAddress).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".qualityOfService: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qualityOfService = new QualityOfServiceImpl();
                        ((QualityOfServiceImpl)this.qualityOfService).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".locationInformationGPRS: Parameter is  primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.locationInformationGPRS = new LocationInformationGPRSImpl();
                        ((LocationInformationGPRSImpl)this.locationInformationGPRS).decodeAll(ais);
                        break;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".timeAndTimezone: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.timeAndTimezone = new TimeAndTimezoneImpl();
                        ((TimeAndTimezoneImpl)this.timeAndTimezone).decodeAll(ais);
                        break;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdpInitiationType: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.pdpInitiationType = PDPInitiationType.getInstance(i1);
                        break;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".secondaryPDPContext: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.secondaryPDPContext = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.accessPointName != null) {
                ((AccessPointNameImpl)this.accessPointName).encodeAll(asnOs, 2, 0);
            }
            if (this.endUserAddress != null) {
                ((EndUserAddressImpl)this.endUserAddress).encodeAll(asnOs, 2, 1);
            }
            if (this.qualityOfService != null) {
                ((QualityOfServiceImpl)this.qualityOfService).encodeAll(asnOs, 2, 2);
            }
            if (this.locationInformationGPRS != null) {
                ((LocationInformationGPRSImpl)this.locationInformationGPRS).encodeAll(asnOs, 2, 3);
            }
            if (this.timeAndTimezone != null) {
                ((TimeAndTimezoneImpl)this.timeAndTimezone).encodeAll(asnOs, 2, 4);
            }
            if (this.pdpInitiationType != null) {
                asnOs.writeInteger(2, 5, this.pdpInitiationType.getCode());
            }
            if (this.secondaryPDPContext) {
                asnOs.writeNull(2, 6);
            }
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.accessPointName != null) {
            sb.append("accessPointName=");
            sb.append(this.accessPointName.toString());
            sb.append(", ");
        }
        if (this.locationInformationGPRS != null) {
            sb.append("locationInformationGPRS=");
            sb.append(this.locationInformationGPRS.toString());
            sb.append(", ");
        }
        if (this.endUserAddress != null) {
            sb.append("endUserAddress=");
            sb.append(this.endUserAddress.toString());
            sb.append(", ");
        }
        if (this.qualityOfService != null) {
            sb.append("qualityOfService=");
            sb.append(this.qualityOfService.toString());
            sb.append(", ");
        }
        if (this.timeAndTimezone != null) {
            sb.append("timeAndTimezone=");
            sb.append(this.timeAndTimezone.toString());
            sb.append(", ");
        }
        if (this.pdpInitiationType != null) {
            sb.append("pdpInitiationType=");
            sb.append(this.pdpInitiationType.toString());
            sb.append(", ");
        }
        if (this.secondaryPDPContext) {
            sb.append("secondaryPDPContext=");
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

