/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap;

import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.api.CAPProvider;
import org.mobicents.protocols.ss7.cap.api.CAPStack;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;

public class CAPStackImpl
implements CAPStack {
    protected TCAPStack tcapStack = null;
    protected CAPProviderImpl capProvider = null;
    private State state = State.IDLE;
    private final String name;

    public CAPStackImpl(String name, SccpProvider sccpPprovider, int ssn) {
        this.name = name;
        this.tcapStack = new TCAPStackImpl(name, sccpPprovider, ssn);
        TCAPProvider tcapProvider = this.tcapStack.getProvider();
        this.capProvider = new CAPProviderImpl(name, tcapProvider);
        this.state = State.CONFIGURED;
    }

    public CAPStackImpl(String name, TCAPProvider tcapProvider) {
        this.name = name;
        this.capProvider = new CAPProviderImpl(name, tcapProvider);
        this.state = State.CONFIGURED;
    }

    public String getName() {
        return this.name;
    }

    public CAPProvider getCAPProvider() {
        return this.capProvider;
    }

    public void start() throws Exception {
        if (this.state != State.CONFIGURED) {
            throw new IllegalStateException("Stack has not been configured or is already running!");
        }
        if (this.tcapStack != null) {
            this.tcapStack.start();
        }
        this.capProvider.start();
        this.state = State.RUNNING;
    }

    public void stop() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stack is not running!");
        }
        this.capProvider.stop();
        if (this.tcapStack != null) {
            this.tcapStack.stop();
        }
        this.state = State.CONFIGURED;
    }

    public TCAPStack getTCAPStack() {
        return this.tcapStack;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        CONFIGURED,
        RUNNING;

    }
}

