/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.management.transceiver;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.ss7.management.transceiver.ChannelProvider;
import org.mobicents.ss7.management.transceiver.Message;
import org.mobicents.ss7.management.transceiver.ShellSelectableChannel;

public class ShellChannel
extends ShellSelectableChannel {
    protected ConcurrentLinkedQueue<Message> rxQueue = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<Message> txQueue = new ConcurrentLinkedQueue();
    public static final int BYTE_BUFFER_SIZE = 8192;
    private ByteBuffer rxBuffer = ByteBuffer.allocateDirect(8192);
    private ByteBuffer txBuffer = ByteBuffer.allocateDirect(8192);
    private ChannelProvider provider;

    protected ShellChannel(ChannelProvider provider, AbstractSelectableChannel channel) throws IOException {
        this.channel = channel;
        this.channel.configureBlocking(false);
        this.provider = provider;
        this.txBuffer.clear();
        this.txBuffer.rewind();
        this.txBuffer.flip();
        this.rxBuffer.clear();
        this.rxBuffer.rewind();
        this.rxBuffer.flip();
    }

    public static ShellChannel open() throws IOException {
        return ChannelProvider.provider().openChannel();
    }

    public Message receive() throws IOException {
        if (!this.isConnected()) {
            throw new ClosedChannelException();
        }
        return this.rxQueue.poll();
    }

    public void send(Message message) throws IOException {
        if (!this.isConnected()) {
            throw new ClosedChannelException();
        }
        this.txQueue.offer(message);
    }

    public void sendImmediate(Message message) throws IOException {
        this.txBuffer.clear();
        this.txBuffer.rewind();
        message.encode(this.txBuffer);
        this.txBuffer.flip();
        ((SocketChannel)this.channel).write(this.txBuffer);
    }

    protected boolean isReadable() {
        return !this.rxQueue.isEmpty();
    }

    protected boolean isWritable() {
        return this.txQueue.isEmpty();
    }

    protected void doRead() throws IOException {
        this.rxBuffer.clear();
        int len = ((SocketChannel)this.channel).read(this.rxBuffer);
        if (len == -1) {
            ((SocketChannel)this.channel).close();
            this.rxQueue.clear();
            return;
        }
        this.rxBuffer.flip();
        while (this.rxBuffer.position() < this.rxBuffer.limit()) {
            Message message = this.provider.getMessageFactory().createMessage(this.rxBuffer);
            if (message == null) continue;
            this.rxQueue.offer(message);
        }
    }

    protected void doWrite() throws IOException {
        if (this.txBuffer.hasRemaining()) {
            ((SocketChannel)this.channel).write(this.txBuffer);
        } else if (!this.txQueue.isEmpty()) {
            Message msg = this.txQueue.poll();
            this.txBuffer.clear();
            this.txBuffer.rewind();
            msg.encode(this.txBuffer);
            this.txBuffer.flip();
            ((SocketChannel)this.channel).write(this.txBuffer);
        }
    }

    public void bind(SocketAddress address) throws IOException {
        ((SocketChannel)this.channel).socket().bind(address);
    }

    public boolean connect(SocketAddress remote) throws IOException {
        return ((SocketChannel)this.channel).connect(remote);
    }

    public boolean finishConnect() throws IOException {
        return ((SocketChannel)this.channel).finishConnect();
    }

    public boolean isConnected() {
        return ((SocketChannel)this.channel).isConnected();
    }

    public SocketAddress getRemoteAddress() {
        return ((SocketChannel)this.channel).socket().getRemoteSocketAddress();
    }

    public boolean isConnectionPending() {
        return ((SocketChannel)this.channel).isConnectionPending();
    }

    public void close() throws IOException {
        ((SocketChannel)this.channel).close();
        ((SocketChannel)this.channel).socket().close();
    }
}

