/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.concurrent.Future;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.tc.component.InvokeClass;
import org.mobicents.protocols.ss7.tcap.api.tc.component.OperationState;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ParseException;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.GeneralProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class InvokeImpl
implements Invoke {
    private InvokeClass invokeClass = InvokeClass.Class1;
    private long invokeTimeout = -1L;
    private OperationState state = OperationState.Idle;
    private Future timerFuture;
    private OperationTimerTask operationTimerTask = new OperationTimerTask(this);
    private TCAPProviderImpl provider;
    private DialogImpl dialog;
    private Long invokeId;
    private Long linkedId;
    private Invoke linkedInvoke;
    private OperationCode operationCode;
    private Parameter parameter;

    public InvokeImpl() {
        this.invokeClass = InvokeClass.Class1;
    }

    public InvokeImpl(InvokeClass invokeClass) {
        this.invokeClass = invokeClass == null ? InvokeClass.Class1 : invokeClass;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public Long getLinkedId() {
        return this.linkedId;
    }

    public Invoke getLinkedInvoke() {
        return this.linkedInvoke;
    }

    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public void setLinkedId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.linkedId = i;
    }

    public void setLinkedInvoke(Invoke val) {
        this.linkedInvoke = val;
    }

    public void setOperationCode(OperationCode i) {
        this.operationCode = i;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public ComponentType getType() {
        return ComponentType.Invoke;
    }

    public String toString() {
        return "Invoke[invokeId=" + this.invokeId + ", linkedId=" + this.linkedId + ", operationCode=" + this.operationCode + ", parameter=" + this.parameter + ", invokeClass=" + (Object)((Object)this.invokeClass) + ", state=" + (Object)((Object)this.state) + "]";
    }

    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding Invoke: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.invokeId = localAis.readInteger();
            tag = localAis.readTag();
            if (tag == 0 && localAis.getTagClass() == 2) {
                this.linkedId = localAis.readInteger();
                tag = localAis.readTag();
            }
            if (tag != 6 && tag != 2 || localAis.getTagClass() != 0) {
                throw new ParseException(null, GeneralProblemType.MistypedComponent, "Error while decoding Invoke: bad tag or tag class for operationCode: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.operationCode = TcapFactory.createOperationCode(tag, localAis);
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            this.parameter = TcapFactory.createParameter(tag, localAis, true);
        }
        catch (IOException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while decoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while decoding Invoke: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            e.setInvokeId(this.invokeId);
            throw e;
        }
    }

    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.invokeId == null) {
            throw new EncodeException("Invoke ID not set!");
        }
        if (this.operationCode == null) {
            throw new EncodeException("Operation Code not set!");
        }
        try {
            aos.writeTag(2, false, 1);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId);
            if (this.linkedId != null) {
                aos.writeInteger(2, 0, this.linkedId);
            }
            this.operationCode.encode(aos);
            if (this.parameter != null) {
                this.parameter.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding Invoke: " + e.getMessage(), e);
        }
    }

    public InvokeClass getInvokeClass() {
        return this.invokeClass;
    }

    public long getTimeout() {
        return this.invokeTimeout;
    }

    public void setTimeout(long invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }

    public TCAPProviderImpl getProvider() {
        return this.provider;
    }

    public void setProvider(TCAPProviderImpl provider) {
        this.provider = provider;
    }

    public DialogImpl getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogImpl dialog) {
        this.dialog = dialog;
    }

    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        if (this.dialog == null) {
            return;
        }
        OperationState old = this.state;
        this.state = state;
        if (old != state) {
            switch (state) {
                case Sent: {
                    this.startTimer();
                    break;
                }
                case Idle: 
                case Reject_W: {
                    this.stopTimer();
                    this.dialog.operationEnded(this);
                }
            }
            if (state == OperationState.Sent || state == OperationState.Idle || state == OperationState.Reject_W) {
                // empty if block
            }
        }
    }

    public void onReturnResultLast() {
        this.setState(OperationState.Idle);
    }

    public void onError() {
        this.setState(OperationState.Idle);
    }

    public void onReject() {
        this.setState(OperationState.Idle);
    }

    public synchronized void startTimer() {
        if (this.dialog == null || this.dialog.getPreviewMode()) {
            return;
        }
        this.stopTimer();
        if (this.invokeTimeout > 0L) {
            this.timerFuture = this.provider.createOperationTimer(this.operationTimerTask, this.invokeTimeout);
        }
    }

    public synchronized void stopTimer() {
        if (this.timerFuture != null) {
            this.timerFuture.cancel(false);
            this.timerFuture = null;
        }
    }

    public boolean isErrorReported() {
        return this.invokeClass == InvokeClass.Class1 || this.invokeClass == InvokeClass.Class2;
    }

    public boolean isSuccessReported() {
        return this.invokeClass == InvokeClass.Class1 || this.invokeClass == InvokeClass.Class3;
    }

    private class OperationTimerTask
    implements Runnable {
        InvokeImpl invoke;

        OperationTimerTask(InvokeImpl invoke) {
            this.invoke = invoke;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InvokeImpl.this.dialog.getDialogLock().lock();
                InvokeImpl.this.timerFuture = null;
                InvokeImpl.this.setState(OperationState.Idle);
                this.invoke.dialog.operationTimedOut(this.invoke);
            }
            finally {
                InvokeImpl.this.dialog.getDialogLock().unlock();
            }
        }
    }
}

