/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.ss7.statistics.StatDataCollectionImpl;
import org.mobicents.protocols.ss7.statistics.api.LongValue;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollection;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollectorType;
import org.mobicents.protocols.ss7.statistics.api.StatResult;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCAPCounterProviderImpl
implements TCAPCounterProvider {
    private UUID sessionId = UUID.randomUUID();
    private TCAPProviderImpl provider;
    private StatDataCollection statDataCollection = new StatDataCollectionImpl();
    private AtomicLong tcUniReceivedCount = new AtomicLong();
    private AtomicLong tcUniSentCount = new AtomicLong();
    private AtomicLong tcBeginReceivedCount = new AtomicLong();
    private AtomicLong tcBeginSentCount = new AtomicLong();
    private AtomicLong tcContinueReceivedCount = new AtomicLong();
    private AtomicLong tcContinueSentCount = new AtomicLong();
    private AtomicLong tcEndReceivedCount = new AtomicLong();
    private AtomicLong tcEndSentCount = new AtomicLong();
    private AtomicLong tcPAbortReceivedCount = new AtomicLong();
    private AtomicLong tcPAbortSentCount = new AtomicLong();
    private AtomicLong tcUserAbortReceivedCount = new AtomicLong();
    private AtomicLong tcUserAbortSentCount = new AtomicLong();
    private AtomicLong invokeReceivedCount = new AtomicLong();
    private AtomicLong invokeSentCount = new AtomicLong();
    private AtomicLong returnResultReceivedCount = new AtomicLong();
    private AtomicLong returnResultSentCount = new AtomicLong();
    private AtomicLong returnResultLastReceivedCount = new AtomicLong();
    private AtomicLong returnResultLastSentCount = new AtomicLong();
    private AtomicLong returnErrorReceivedCount = new AtomicLong();
    private AtomicLong returnErrorSentCount = new AtomicLong();
    private AtomicLong rejectReceivedCount = new AtomicLong();
    private AtomicLong rejectSentCount = new AtomicLong();
    private AtomicLong dialogTimeoutCount = new AtomicLong();
    private AtomicLong dialogReleaseCount = new AtomicLong();
    private AtomicLong allEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allLocalEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allRemoteEstablishedDialogsCount = new AtomicLong();
    private AtomicLong allDialogsDuration = new AtomicLong();
    private static String OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME = "outgoingDialogsPerApplicationContextName";
    private static String INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME = "incomingDialogsPerApplicationContextName";
    private static String OUTGOING_INVOKES_PER_OPERATION_CODE = "outgoingInvokesPerOperationCode";
    private static String INCOMING_INVOKES_PER_OPERATION_CODE = "incomingInvokesPerOperationCode";
    private static String OUTGOING_ERRORS_PER_ERROR_CODE = "outgoingErrorsPerErrorCode";
    private static String INCOMING_ERRORS_PER_ERROR_CODE = "incomingErrorsPerErrorCode";
    private static String OUTGOING_REJECT_PER_PROBLEM = "outgoingRejectPerProblem";
    private static String INCOMING_REJECT_PER_PROBLEM = "incomingRejectPerProblem";
    private static String MIN_DIALOGS_COUNT = "MinDialogsCount";
    private static String MAX_DIALOGS_COUNT = "MaxDialogsCount";

    public TCAPCounterProviderImpl(TCAPProviderImpl provider) {
        this.provider = provider;
        this.statDataCollection.registerStatCounterCollector(MIN_DIALOGS_COUNT, StatDataCollectorType.MIN);
        this.statDataCollection.registerStatCounterCollector(MAX_DIALOGS_COUNT, StatDataCollectorType.MAX);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_INVOKES_PER_OPERATION_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_INVOKES_PER_OPERATION_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_ERRORS_PER_ERROR_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_ERRORS_PER_ERROR_CODE, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(OUTGOING_REJECT_PER_PROBLEM, StatDataCollectorType.StringLongMap);
        this.statDataCollection.registerStatCounterCollector(INCOMING_REJECT_PER_PROBLEM, StatDataCollectorType.StringLongMap);
    }

    @Override
    public UUID getSessionId() {
        return this.sessionId;
    }

    @Override
    public long getTcUniReceivedCount() {
        return this.tcUniReceivedCount.get();
    }

    public void updateTcUniReceivedCount() {
        this.tcUniReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcUniSentCount() {
        return this.tcUniSentCount.get();
    }

    public void updateTcUniSentCount() {
        this.tcUniSentCount.addAndGet(1L);
    }

    @Override
    public long getTcBeginReceivedCount() {
        return this.tcBeginReceivedCount.get();
    }

    public void updateTcBeginReceivedCount() {
        this.tcBeginReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcBeginSentCount() {
        return this.tcBeginSentCount.get();
    }

    public void updateTcBeginSentCount() {
        this.tcBeginSentCount.addAndGet(1L);
    }

    @Override
    public long getTcContinueReceivedCount() {
        return this.tcContinueReceivedCount.get();
    }

    public void updateTcContinueReceivedCount() {
        this.tcContinueReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcContinueSentCount() {
        return this.tcContinueSentCount.get();
    }

    public void updateTcContinueSentCount() {
        this.tcContinueSentCount.addAndGet(1L);
    }

    @Override
    public long getTcEndReceivedCount() {
        return this.tcEndReceivedCount.get();
    }

    public void updateTcEndReceivedCount() {
        this.tcEndReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcEndSentCount() {
        return this.tcEndSentCount.get();
    }

    public void updateTcEndSentCount() {
        this.tcEndSentCount.addAndGet(1L);
    }

    @Override
    public long getTcPAbortReceivedCount() {
        return this.tcPAbortReceivedCount.get();
    }

    public void updateTcPAbortReceivedCount() {
        this.tcPAbortReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcPAbortSentCount() {
        return this.tcPAbortSentCount.get();
    }

    public void updateTcPAbortSentCount() {
        this.tcPAbortSentCount.addAndGet(1L);
    }

    @Override
    public long getTcUserAbortReceivedCount() {
        return this.tcUserAbortReceivedCount.get();
    }

    public void updateTcUserAbortReceivedCount() {
        this.tcUserAbortReceivedCount.addAndGet(1L);
    }

    @Override
    public long getTcUserAbortSentCount() {
        return this.tcUserAbortSentCount.get();
    }

    public void updateTcUserAbortSentCount() {
        this.tcUserAbortSentCount.addAndGet(1L);
    }

    @Override
    public long getInvokeReceivedCount() {
        return this.invokeReceivedCount.get();
    }

    public void updateInvokeReceivedCount() {
        this.invokeReceivedCount.addAndGet(1L);
    }

    @Override
    public long getInvokeSentCount() {
        return this.invokeSentCount.get();
    }

    public void updateInvokeSentCount() {
        this.invokeSentCount.addAndGet(1L);
    }

    @Override
    public long getReturnResultReceivedCount() {
        return this.returnResultReceivedCount.get();
    }

    public void updateReturnResultReceivedCount() {
        this.returnResultReceivedCount.addAndGet(1L);
    }

    @Override
    public long getReturnResultSentCount() {
        return this.returnResultSentCount.get();
    }

    public void updateReturnResultSentCount() {
        this.returnResultSentCount.addAndGet(1L);
    }

    @Override
    public long getReturnResultLastReceivedCount() {
        return this.returnResultLastReceivedCount.get();
    }

    public void updateReturnResultLastReceivedCount() {
        this.returnResultLastReceivedCount.addAndGet(1L);
    }

    @Override
    public long getReturnResultLastSentCount() {
        return this.returnResultLastSentCount.get();
    }

    public void updateReturnResultLastSentCount() {
        this.returnResultLastSentCount.addAndGet(1L);
    }

    @Override
    public long getReturnErrorReceivedCount() {
        return this.returnErrorReceivedCount.get();
    }

    public void updateReturnErrorReceivedCount() {
        this.returnErrorReceivedCount.addAndGet(1L);
    }

    @Override
    public long getReturnErrorSentCount() {
        return this.returnErrorSentCount.get();
    }

    public void updateReturnErrorSentCount() {
        this.returnErrorSentCount.addAndGet(1L);
    }

    @Override
    public long getRejectReceivedCount() {
        return this.rejectReceivedCount.get();
    }

    public void updateRejectReceivedCount() {
        this.rejectReceivedCount.addAndGet(1L);
    }

    @Override
    public long getRejectSentCount() {
        return this.rejectSentCount.get();
    }

    public void updateRejectSentCount() {
        this.rejectSentCount.addAndGet(1L);
    }

    @Override
    public long getDialogTimeoutCount() {
        return this.dialogTimeoutCount.get();
    }

    public void updateDialogTimeoutCount() {
        this.dialogTimeoutCount.addAndGet(1L);
    }

    @Override
    public long getDialogReleaseCount() {
        return this.dialogReleaseCount.get();
    }

    public void updateDialogReleaseCount() {
        this.dialogReleaseCount.addAndGet(1L);
    }

    @Override
    public long getCurrentDialogsCount() {
        return this.provider.getCurrentDialogsCount();
    }

    @Override
    public long getAllEstablishedDialogsCount() {
        return this.allEstablishedDialogsCount.get();
    }

    public void updateAllEstablishedDialogsCount() {
        this.allEstablishedDialogsCount.addAndGet(1L);
    }

    @Override
    public long getAllLocalEstablishedDialogsCount() {
        return this.allLocalEstablishedDialogsCount.get();
    }

    public void updateAllLocalEstablishedDialogsCount() {
        this.allLocalEstablishedDialogsCount.addAndGet(1L);
    }

    @Override
    public long getAllRemoteEstablishedDialogsCount() {
        return this.allRemoteEstablishedDialogsCount.get();
    }

    public void updateAllRemoteEstablishedDialogsCount() {
        this.allRemoteEstablishedDialogsCount.addAndGet(1L);
    }

    @Override
    public Long getMinDialogsCount(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MIN_DIALOGS_COUNT, compainName);
        this.statDataCollection.updateData(MIN_DIALOGS_COUNT, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMinDialogsCount(long newVal) {
        this.statDataCollection.updateData(MIN_DIALOGS_COUNT, newVal);
    }

    @Override
    public Long getMaxDialogsCount(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(MAX_DIALOGS_COUNT, compainName);
        this.statDataCollection.updateData(MAX_DIALOGS_COUNT, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxDialogsCount(long newVal) {
        this.statDataCollection.updateData(MAX_DIALOGS_COUNT, newVal);
    }

    @Override
    public long getAllDialogsDuration() {
        return this.allDialogsDuration.get();
    }

    public void updateAllDialogsDuration(long diff) {
        this.allDialogsDuration.addAndGet(diff);
    }

    @Override
    public Map<String, LongValue> getOutgoingDialogsPerApplicatioContextName(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, compainName);
        this.statDataCollection.updateData(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingDialogsPerApplicatioContextName(String name) {
        this.statDataCollection.updateData(OUTGOING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, name);
    }

    @Override
    public Map<String, LongValue> getIncomingDialogsPerApplicatioContextName(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, compainName);
        this.statDataCollection.updateData(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingDialogsPerApplicatioContextName(String name) {
        this.statDataCollection.updateData(INCOMING_DIALOGS_PER_APPLICATION_CONTEXT_NAME, name);
    }

    @Override
    public Map<String, LongValue> getOutgoingInvokesPerOperationCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_INVOKES_PER_OPERATION_CODE, compainName);
        this.statDataCollection.updateData(OUTGOING_INVOKES_PER_OPERATION_CODE, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingInvokesPerOperationCode(String name) {
        this.statDataCollection.updateData(OUTGOING_INVOKES_PER_OPERATION_CODE, name);
    }

    @Override
    public Map<String, LongValue> getIncomingInvokesPerOperationCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_INVOKES_PER_OPERATION_CODE, compainName);
        this.statDataCollection.updateData(INCOMING_INVOKES_PER_OPERATION_CODE, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingInvokesPerOperationCode(String name) {
        this.statDataCollection.updateData(INCOMING_INVOKES_PER_OPERATION_CODE, name);
    }

    @Override
    public Map<String, LongValue> getOutgoingErrorsPerErrorCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_ERRORS_PER_ERROR_CODE, compainName);
        this.statDataCollection.updateData(OUTGOING_ERRORS_PER_ERROR_CODE, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingErrorsPerErrorCode(String name) {
        this.statDataCollection.updateData(OUTGOING_ERRORS_PER_ERROR_CODE, name);
    }

    @Override
    public Map<String, LongValue> getIncomingErrorsPerErrorCode(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_ERRORS_PER_ERROR_CODE, compainName);
        this.statDataCollection.updateData(INCOMING_ERRORS_PER_ERROR_CODE, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingErrorsPerErrorCode(String name) {
        this.statDataCollection.updateData(INCOMING_ERRORS_PER_ERROR_CODE, name);
    }

    @Override
    public Map<String, LongValue> getOutgoingRejectPerProblem(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(OUTGOING_REJECT_PER_PROBLEM, compainName);
        this.statDataCollection.updateData(OUTGOING_REJECT_PER_PROBLEM, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateOutgoingRejectPerProblem(String name) {
        this.statDataCollection.updateData(OUTGOING_REJECT_PER_PROBLEM, name);
    }

    @Override
    public Map<String, LongValue> getIncomingRejectPerProblem(String compainName) {
        StatResult res = this.statDataCollection.restartAndGet(INCOMING_REJECT_PER_PROBLEM, compainName);
        this.statDataCollection.updateData(INCOMING_REJECT_PER_PROBLEM, this.provider.getCurrentDialogsCount());
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateIncomingRejectPerProblem(String name) {
        this.statDataCollection.updateData(INCOMING_REJECT_PER_PROBLEM, name);
    }
}

