/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.pdpContextActivation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.GSNAddress;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsResponse;
import org.mobicents.protocols.ss7.map.primitives.GSNAddressImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.pdpContextActivation.PdpContextActivationMessageImpl;

public class SendRoutingInfoForGprsResponseImpl
extends PdpContextActivationMessageImpl
implements SendRoutingInfoForGprsResponse {
    protected static final int _TAG_sgsnAddress = 0;
    protected static final int _TAG_ggsnAddress = 1;
    protected static final int _TAG_mobileNotReachableReason = 2;
    protected static final int _TAG_extensionContainer = 3;
    public static final String _PrimitiveName = "SendRoutingInfoForGprsResponse";
    private GSNAddress sgsnAddress;
    private GSNAddress ggsnAddress;
    private Integer mobileNotReachableReason;
    private MAPExtensionContainer extensionContainer;

    public SendRoutingInfoForGprsResponseImpl() {
    }

    public SendRoutingInfoForGprsResponseImpl(GSNAddress sgsnAddress, GSNAddress ggsnAddress, Integer mobileNotReachableReason, MAPExtensionContainer extensionContainer) {
        this.sgsnAddress = sgsnAddress;
        this.ggsnAddress = ggsnAddress;
        this.mobileNotReachableReason = mobileNotReachableReason;
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendRoutingInfoForGprs_Response;
    }

    public int getOperationCode() {
        return 24;
    }

    public GSNAddress getSgsnAddress() {
        return this.sgsnAddress;
    }

    public GSNAddress getGgsnAddress() {
        return this.ggsnAddress;
    }

    public Integer getMobileNotReachableReason() {
        return this.mobileNotReachableReason;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.sgsnAddress = null;
        this.ggsnAddress = null;
        this.mobileNotReachableReason = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsResponse.sgsnAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.sgsnAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.sgsnAddress).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsResponse.ggsnAddress: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ggsnAddress = new GSNAddressImpl();
                        ((GSNAddressImpl)this.ggsnAddress).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsResponse.mobileNotReachableReason: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mobileNotReachableReason = (int)ais.readInteger();
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsResponse.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else {
                ais.advanceElement();
            }
            ++num;
        }
        if (this.sgsnAddress == null) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForGprsResponse: Parameter sgsnAddress is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.sgsnAddress == null) {
                throw new MAPException("sgsnAddress parameter must not be null");
            }
            ((GSNAddressImpl)this.sgsnAddress).encodeAll(asnOs, 2, 0);
            if (this.ggsnAddress != null) {
                ((GSNAddressImpl)this.ggsnAddress).encodeAll(asnOs, 2, 1);
            }
            if (this.mobileNotReachableReason != null) {
                asnOs.writeInteger(2, 2, this.mobileNotReachableReason.intValue());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendRoutingInfoForGprsResponse: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.sgsnAddress != null) {
            sb.append("sgsnAddress=");
            sb.append(this.sgsnAddress);
            sb.append(", ");
        }
        if (this.ggsnAddress != null) {
            sb.append("ggsnAddress=");
            sb.append(this.ggsnAddress);
            sb.append(", ");
        }
        if (this.mobileNotReachableReason != null) {
            sb.append("mobileNotReachableReason=");
            sb.append(this.mobileNotReachableReason);
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

