/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.CallReference;

public class CallReferenceImpl
extends AbstractISUPParameter
implements CallReference {
    private int callIdentity = 0;
    private int signalingPointCode = 0;

    public CallReferenceImpl() {
    }

    public CallReferenceImpl(int callIdentity, int signalingPointCode) {
        this.callIdentity = callIdentity;
        this.signalingPointCode = signalingPointCode;
    }

    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 5) {
            throw new ParameterException("byte[] must not be null or have length of 5");
        }
        this.callIdentity = (b[0] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[2] & 0xFF;
        this.signalingPointCode = b[3] & 0xFF | (b[4] & 0x3F) << 8;
        return 5;
    }

    public byte[] encode() throws ParameterException {
        byte[] b = new byte[]{(byte)(this.callIdentity >> 16), (byte)(this.callIdentity >> 8), (byte)this.callIdentity, (byte)this.signalingPointCode, (byte)(this.signalingPointCode >> 8 & 0x3F)};
        return b;
    }

    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return b.length;
    }

    public int getCallIdentity() {
        return this.callIdentity;
    }

    public void setCallIdentity(int callIdentity) {
        this.callIdentity = callIdentity & 0xFFFFFF;
    }

    public int getSignalingPointCode() {
        return this.signalingPointCode;
    }

    public void setSignalingPointCode(int signalingPointCode) {
        this.signalingPointCode = signalingPointCode;
    }

    public int getCode() {
        return 1;
    }
}

