/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.oam;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.ConcernedSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.Mtp3Destination;
import org.restcomm.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.RemoteSubSystem;
import org.restcomm.protocols.ss7.sccp.SccpCongestionControlAlgo;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.ss7.management.console.ShellExecutor;

public class SccpExecutor
implements ShellExecutor {
    protected static final Logger logger = Logger.getLogger(SccpExecutor.class);
    protected FastMap<String, SccpStackImpl> sccpStacks = new FastMap();
    protected SccpStackImpl sccpStack = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSccpStacks(Map<String, SccpStackImpl> sccpStacksTemp) {
        if (sccpStacksTemp != null) {
            SccpExecutor sccpExecutor = this;
            synchronized (sccpExecutor) {
                FastMap<String, SccpStackImpl> newSccpStacks = new FastMap<String, SccpStackImpl>();
                newSccpStacks.putAll(sccpStacksTemp);
                this.sccpStacks = newSccpStacks;
            }
        }
    }

    protected void setDefaultValue() {
        if (this.sccpStack == null) {
            Map.Entry<String, SccpStackImpl> sccpStacksTmp = this.sccpStacks.entrySet().iterator().next();
            this.sccpStack = sccpStacksTmp.getValue();
        }
    }

    public Map<String, SccpStackImpl> getSccpStacks() {
        return this.sccpStacks;
    }

    public String execute(String[] options) {
        if (this.sccpStacks.size() == 0) {
            logger.warn("SCCP stack not set. Command will not be executed ");
            return "Server Error";
        }
        if (options == null || options.length < 2) {
            return "Invalid Command";
        }
        String firstOption = options[1];
        if (firstOption == null) {
            return "Invalid Command";
        }
        try {
            if (firstOption.equals("rsp")) {
                return this.manageRsp(options);
            }
            if (firstOption.equals("rss")) {
                return this.manageRss(options);
            }
            if (firstOption.equals("lmr")) {
                return this.manageLmr(options);
            }
            if (firstOption.equals("sap")) {
                return this.manageSap(options);
            }
            if (firstOption.equals("dest")) {
                return this.manageDest(options);
            }
            if (firstOption.equals("csp")) {
                return this.manageConcernedSpc(options);
            }
            if (firstOption.equals("set")) {
                return this.manageSet(options);
            }
            if (firstOption.equals("get")) {
                return this.manageGet(options);
            }
        }
        catch (Throwable t) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(options)), t);
            return t.getMessage();
        }
        return "Invalid Command";
    }

    private String manageRss(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSs = Integer.parseInt(options[5]);
            int remoteSsFlag = Integer.parseInt(options[6]);
            boolean markProhibitedWhenSpcResuming = false;
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("prohibitedwhenspcresuming")) {
                    markProhibitedWhenSpcResuming = Boolean.parseBoolean(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return String.format("Remote Subsystem successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 6) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            Integer remoteSpc = null;
            Integer remoteSs = null;
            Integer remoteSsFlag = null;
            Boolean markProhibitedWhenSpcResuming = null;
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("remote-spc")) {
                    remoteSpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("remote-ssn")) {
                    remoteSs = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("rss-flag")) {
                    remoteSsFlag = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("prohibitedwhenspcresuming")) {
                    markProhibitedWhenSpcResuming = Boolean.valueOf(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyRemoteSsn(remoteSsId, remoteSpc, remoteSs, remoteSsFlag, markProhibitedWhenSpcResuming);
            return String.format("Remote Subsystem successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSsId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeRemoteSsn(remoteSsId);
            return String.format("Remote Subsystem successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int remoteSsId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    remoteSsId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (remoteSsId != -1) {
                RemoteSubSystem rss = this.sccpStack.getSccpResource().getRemoteSsn(remoteSsId);
                if (rss == null) {
                    return String.format("Remote Subsystem doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return rss.toString();
            }
            if (this.sccpStack.getSccpResource().getRemoteSsns().size() == 0) {
                return String.format("Remote Subsystem doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map<Integer, RemoteSubSystem> idVsRemoteSsn = this.sccpStack.getSccpResource().getRemoteSsns();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsRemoteSsn.keySet()) {
                RemoteSubSystem rss = idVsRemoteSsn.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rss);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageRsp(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int remoteSpc = Integer.parseInt(options[4]);
            int remoteSpcFlag = Integer.parseInt(options[5]);
            int mask = Integer.parseInt(options[6]);
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return String.format("Remote Signaling Pointcode successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 6) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            Integer remoteSpc = null;
            Integer remoteSpcFlag = null;
            Integer mask = null;
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("remote-spc")) {
                    remoteSpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("rspc-flag")) {
                    remoteSpcFlag = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("mask")) {
                    mask = Integer.valueOf(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyRemoteSpc(remoteSpcId, remoteSpc, remoteSpcFlag, mask);
            return String.format("Remote Signaling Pointcode successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int remoteSpcId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeRemoteSpc(remoteSpcId);
            return String.format("Remote Signaling Pointcode successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int remoteSpcId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    remoteSpcId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (remoteSpcId != -1) {
                RemoteSignalingPointCode rspc = this.sccpStack.getSccpResource().getRemoteSpc(remoteSpcId);
                if (rspc == null) {
                    return String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return rspc.toString();
            }
            if (this.sccpStack.getSccpResource().getRemoteSpcs().size() == 0) {
                return String.format("Remote Signaling Pointcode doesn't exist on stack=%s", this.sccpStack.getName());
            }
            StringBuffer sb = new StringBuffer();
            Map<Integer, RemoteSignalingPointCode> idVsRspc = this.sccpStack.getSccpResource().getRemoteSpcs();
            Set<Integer> rspIds = idVsRspc.keySet();
            for (Integer e : rspIds) {
                RemoteSignalingPointCode rsp = idVsRspc.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(rsp);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageLmr(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            LongMessageRuleType ruleType;
            if (options.length < 7) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int firstSpc = Integer.parseInt(options[4]);
            int lastSpc = Integer.parseInt(options[5]);
            String s1 = options[6].toLowerCase();
            if (s1.equals("udt")) {
                ruleType = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
            } else if (s1.equals("xudt")) {
                ruleType = LongMessageRuleType.XUDT_ENABLED;
            } else if (s1.equals("ludt")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED;
            } else if (s1.equals("ludt_segm")) {
                ruleType = LongMessageRuleType.LUDT_ENABLED_WITH_SEGMENTATION;
            } else {
                return "Invalid Command";
            }
            int count = 7;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return String.format("Long message rule successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 6) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            Integer firstSpc = null;
            Integer lastSpc = null;
            LongMessageRuleType ruleType = null;
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("first-spc")) {
                    firstSpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("last-spc")) {
                    lastSpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("rule-type")) {
                    String s1;
                    if ((s1 = options[count++].toLowerCase()).equals("udt")) {
                        ruleType = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
                        continue;
                    }
                    if (s1.equals("xudt")) {
                        ruleType = LongMessageRuleType.XUDT_ENABLED;
                        continue;
                    }
                    if (s1.equals("ludt")) {
                        ruleType = LongMessageRuleType.LUDT_ENABLED;
                        continue;
                    }
                    if (s1.equals("ludt_segm")) {
                        ruleType = LongMessageRuleType.LUDT_ENABLED_WITH_SEGMENTATION;
                        continue;
                    }
                    return "Invalid Command";
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyLongMessageRule(lmrId, firstSpc, lastSpc, ruleType);
            return String.format("Long message rule successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int lmrId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeLongMessageRule(lmrId);
            return String.format("Long message rule successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int lmrId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    lmrId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (lmrId != -1) {
                LongMessageRule lmr = this.sccpStack.getRouter().getLongMessageRule(lmrId);
                if (lmr == null) {
                    return String.format("Long message rule doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return lmr.toString();
            }
            if (this.sccpStack.getRouter().getLongMessageRules().size() == 0) {
                return String.format("Long message rule doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map<Integer, LongMessageRule> idVsLngmsgRule = this.sccpStack.getRouter().getLongMessageRules();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsLngmsgRule.keySet()) {
                LongMessageRule lmr = idVsLngmsgRule.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(lmr);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSap(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int mtp3Id = Integer.parseInt(options[4]);
            int opc = Integer.parseInt(options[5]);
            int ni = Integer.parseInt(options[6]);
            int count = 7;
            int networkId = 0;
            String localGtDigits = "";
            while (count < options.length - 1) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("networkid")) {
                    String networkIdS = options[count++];
                    networkId = Integer.parseInt(networkIdS);
                    continue;
                }
                if (key.equals("localgtdigits")) {
                    localGtDigits = options[count++];
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni, networkId, localGtDigits);
            return String.format("Service access point successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 6) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            Integer mtp3Id = null;
            Integer opc = null;
            Integer ni = null;
            Integer networkId = null;
            String localGtDigits = null;
            int count = 4;
            while (count < options.length - 1) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("mtp3-id")) {
                    mtp3Id = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("opc")) {
                    opc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("ni")) {
                    ni = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("networkid")) {
                    networkId = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("localgtdigits")) {
                    localGtDigits = options[count++];
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyMtp3ServiceAccessPoint(sapId, mtp3Id, opc, ni, networkId, localGtDigits);
            return String.format("Service access point successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeMtp3ServiceAccessPoint(sapId);
            return String.format("Service access point successfully deleted from sack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int sapId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    sapId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (sapId != -1) {
                Mtp3ServiceAccessPoint sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return sap.toString();
            }
            if (this.sccpStack.getRouter().getMtp3ServiceAccessPoints().size() == 0) {
                return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
            }
            Map<Integer, Mtp3ServiceAccessPoint> idVsMtp3SerAccPt = this.sccpStack.getRouter().getMtp3ServiceAccessPoints();
            StringBuffer sb = new StringBuffer();
            for (Integer e : idVsMtp3SerAccPt.keySet()) {
                Mtp3ServiceAccessPoint sap = idVsMtp3SerAccPt.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(sap);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageDest(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 10) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int firstDpc = Integer.parseInt(options[5]);
            int lastDpc = Integer.parseInt(options[6]);
            int firstSls = Integer.parseInt(options[7]);
            int lastSls = Integer.parseInt(options[8]);
            int slsMask = Integer.parseInt(options[9]);
            int count = 10;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().addMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return String.format("Destination definition successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 7) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            Integer firstDpc = null;
            Integer lastDpc = null;
            Integer firstSls = null;
            Integer lastSls = null;
            Integer slsMask = null;
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("first-dpc")) {
                    firstDpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("last-dpc")) {
                    lastDpc = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("first-sls")) {
                    firstSls = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("last-sls")) {
                    lastSls = Integer.valueOf(options[count++]);
                    continue;
                }
                if (key.equals("sls-mask")) {
                    slsMask = Integer.valueOf(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().modifyMtp3Destination(sapId, destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
            return String.format("Destination definition successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int sapId = Integer.parseInt(options[3]);
            int destId = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getRouter().removeMtp3Destination(sapId, destId);
            return String.format("Destination definition successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            Mtp3ServiceAccessPoint sap;
            int sapId = Integer.parseInt(options[3]);
            int destId = -1;
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    destId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (destId != -1) {
                sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
                if (sap == null) {
                    return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
                }
                Mtp3Destination dest = sap.getMtp3Destination(destId);
                if (dest == null) {
                    return String.format("Destination definition doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return dest.toString();
            }
            sap = this.sccpStack.getRouter().getMtp3ServiceAccessPoint(sapId);
            if (sap == null) {
                return String.format("Service access point doesn't exist on stack=%s", this.sccpStack.getName());
            }
            return sap.toString();
        }
        return "Invalid Command";
    }

    private String manageConcernedSpc(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        String command = options[2];
        if (command == null) {
            return "Invalid Command";
        }
        if (command.equals("create")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            int conSpc = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().addConcernedSpc(concernedSpcId, conSpc);
            return String.format("Concerned spc successfully added on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("modify")) {
            if (options.length < 5) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            if (this.sccpStack.getSccpResource().getConcernedSpc(concernedSpcId) == null) {
                return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
            }
            int conSpc = Integer.parseInt(options[4]);
            int count = 5;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().modifyConcernedSpc(concernedSpcId, conSpc);
            return String.format("Concerned spc successfully modified on stack=%s", this.sccpStack.getName());
        }
        if (command.equals("delete")) {
            if (options.length < 4) {
                return "Invalid Command";
            }
            int concernedSpcId = Integer.parseInt(options[3]);
            int count = 4;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            this.sccpStack.getSccpResource().removeConcernedSpc(concernedSpcId);
            return String.format("Concerned spc successfully deleted from stack=%s", this.sccpStack.getName());
        }
        if (command.equals("show")) {
            int count = 3;
            int concernedSpcId = -1;
            while (count < options.length) {
                String key;
                if ((key = options[count++]) == null) {
                    return "Invalid Command";
                }
                if (key.equals("stackname")) {
                    String m3uaStackName;
                    SccpStackImpl sccpStaclImpl;
                    if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                        return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                    }
                    this.sccpStack = sccpStaclImpl;
                    continue;
                }
                if (key.equals("id")) {
                    concernedSpcId = Integer.parseInt(options[count++]);
                    continue;
                }
                return "Invalid Command";
            }
            this.setDefaultValue();
            if (concernedSpcId != -1) {
                ConcernedSignalingPointCode conSpc = this.sccpStack.getSccpResource().getConcernedSpc(concernedSpcId);
                if (conSpc == null) {
                    return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
                }
                return conSpc.toString();
            }
            if (this.sccpStack.getSccpResource().getConcernedSpcs().size() == 0) {
                return String.format("Concerned spc doesn't exist on stack=%s", this.sccpStack.getName());
            }
            StringBuffer sb = new StringBuffer();
            Map<Integer, ConcernedSignalingPointCode> idvsCsp = this.sccpStack.getSccpResource().getConcernedSpcs();
            for (Integer e : idvsCsp.keySet()) {
                ConcernedSignalingPointCode ConcSpc = idvsCsp.get(e);
                sb.append("key=");
                sb.append(e);
                sb.append("  ");
                sb.append(ConcSpc);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "Invalid Command";
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        int count = 4;
        while (count < options.length) {
            String key;
            if ((key = options[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                SccpStackImpl sccpStaclImpl;
                if ((sccpStaclImpl = this.sccpStacks.get(m3uaStackName = options[count++])) == null) {
                    return String.format("No SCCP management bean found for passed name=%s", m3uaStackName);
                }
                this.sccpStack = sccpStaclImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        String parName = options[2].toLowerCase();
        if (parName.equals("zmarginxudtmessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setZMarginXudtMessage(val);
        } else if (parName.equals("reassemblytimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setReassemblyTimerDelay(val);
        } else if (parName.equals("maxdatamessage")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setMaxDataMessage(val);
        } else if (parName.equals("periodoflogging")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setPeriodOfLogging(val);
        } else if (parName.equals("removespc")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setRemoveSpc(val);
        } else if (parName.equals("respectpc")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setRespectPc(val);
        } else if (parName.equals("previewmode")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setPreviewMode(val);
        } else if (parName.equals("ssttimerduration_min")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Min(val);
        } else if (parName.equals("ssttimerduration_max")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setSstTimerDuration_Max(val);
        } else if (parName.equals("ssttimerduration_increasefactor")) {
            double val = Double.parseDouble(options[3]);
            this.sccpStack.setSstTimerDuration_IncreaseFactor(val);
        } else if (parName.equals("sccpprotocolversion")) {
            SccpProtocolVersion spv = Enum.valueOf(SccpProtocolVersion.class, options[3]);
            if (spv != null) {
                this.sccpStack.setSccpProtocolVersion(spv);
            }
        } else if (parName.equals("cc_timer_a")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setCongControlTIMER_A(val);
        } else if (parName.equals("cc_timer_d")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setCongControlTIMER_D(val);
        } else if (parName.equals("canrelay")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setCanRelay(val);
        } else if (parName.equals("connesttimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setConnEstTimerDelay(val);
        } else if (parName.equals("iastimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIasTimerDelay(val);
        } else if (parName.equals("iartimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIarTimerDelay(val);
        } else if (parName.equals("reltimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setRelTimerDelay(val);
        } else if (parName.equals("repeatreltimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setRepeatRelTimerDelay(val);
        } else if (parName.equals("inttimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIntTimerDelay(val);
        } else if (parName.equals("guardtimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setGuardTimerDelay(val);
        } else if (parName.equals("resettimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setResetTimerDelay(val);
        } else if (parName.equals("timerexecutors_threadcount")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setTimerExecutorsThreadCount(val);
        } else if (parName.equals("canrelay")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.sccpStack.setCanRelay(val);
        } else if (parName.equals("connesttimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setConnEstTimerDelay(val);
        } else if (parName.equals("iastimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIasTimerDelay(val);
        } else if (parName.equals("iartimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIarTimerDelay(val);
        } else if (parName.equals("reltimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setRelTimerDelay(val);
        } else if (parName.equals("repeatreltimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setRepeatRelTimerDelay(val);
        } else if (parName.equals("inttimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setIntTimerDelay(val);
        } else if (parName.equals("guardtimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setGuardTimerDelay(val);
        } else if (parName.equals("resettimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setResetTimerDelay(val);
        } else if (parName.equals("reassemblytimerdelay")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setReassemblyTimerDelay(val);
        } else if (parName.equals("timerexecutors_threadcount")) {
            int val = Integer.parseInt(options[3]);
            this.sccpStack.setTimerExecutorsThreadCount(val);
        } else if (parName.equals("cc_algo")) {
            String vals = options[3];
            SccpCongestionControlAlgo algo = Enum.valueOf(SccpCongestionControlAlgo.class, vals);
            this.sccpStack.setCongControl_Algo(algo);
        } else if (parName.equals("cc_blockingoutgoungsccpmessages")) {
            boolean valb = Boolean.parseBoolean(options[3]);
            this.sccpStack.setCongControl_blockingOutgoungSccpMessages(valb);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set on stack=%s", this.sccpStack.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("zmarginxudtmessage")) {
                sb.append(this.sccpStack.getZMarginXudtMessage());
            } else if (parName.equals("reassemblytimerdelay")) {
                sb.append(this.sccpStack.getReassemblyTimerDelay());
            } else if (parName.equals("maxdatamessage")) {
                sb.append(this.sccpStack.getMaxDataMessage());
            } else if (parName.equals("periodoflogging")) {
                sb.append(this.sccpStack.getPeriodOfLogging());
            } else if (parName.equals("removespc")) {
                sb.append(this.sccpStack.isRemoveSpc());
            } else if (parName.equals("respectpc")) {
                sb.append(this.sccpStack.isRespectPc());
            } else if (parName.equals("previewmode")) {
                sb.append(this.sccpStack.isPreviewMode());
            } else if (parName.equals("ssttimerduration_min")) {
                sb.append(this.sccpStack.getSstTimerDuration_Min());
            } else if (parName.equals("ssttimerduration_max")) {
                sb.append(this.sccpStack.getSstTimerDuration_Max());
            } else if (parName.equals("ssttimerduration_increasefactor")) {
                sb.append(this.sccpStack.getSstTimerDuration_IncreaseFactor());
            } else if (parName.equals("sccpprotocolversion")) {
                sb.append((Object)this.sccpStack.getSccpProtocolVersion());
            } else if (parName.equals("cc_timer_a")) {
                sb.append(this.sccpStack.getCongControlTIMER_A());
            } else if (parName.equals("cc_timer_d")) {
                sb.append(this.sccpStack.getCongControlTIMER_D());
            } else if (parName.equals("canrelay")) {
                sb.append(this.sccpStack.isCanRelay());
            } else if (parName.equals("connesttimerdelay")) {
                sb.append(this.sccpStack.getConnEstTimerDelay());
            } else if (parName.equals("iastimerdelay")) {
                sb.append(this.sccpStack.getIasTimerDelay());
            } else if (parName.equals("iartimerdelay")) {
                sb.append(this.sccpStack.getIarTimerDelay());
            } else if (parName.equals("reltimerdelay")) {
                sb.append(this.sccpStack.getRelTimerDelay());
            } else if (parName.equals("repeatreltimerdelay")) {
                sb.append(this.sccpStack.getRepeatRelTimerDelay());
            } else if (parName.equals("inttimerdelay")) {
                sb.append(this.sccpStack.getIntTimerDelay());
            } else if (parName.equals("guardtimerdelay")) {
                sb.append(this.sccpStack.getGuardTimerDelay());
            } else if (parName.equals("resettimerdelay")) {
                sb.append(this.sccpStack.getResetTimerDelay());
            } else if (parName.equals("timerexecutors_threadcount")) {
                sb.append(this.sccpStack.getTimerExecutorsThreadCount());
            } else if (parName.equals("cc_algo")) {
                sb.append((Object)this.sccpStack.getCongControl_Algo());
            } else if (parName.equals("cc_blockingoutgoungsccpmessages")) {
                sb.append(this.sccpStack.isCongControl_blockingOutgoungSccpMessages());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        FastCollection.Record e = this.sccpStacks.head();
        FastMap.Entry<String, SccpStackImpl> end = this.sccpStacks.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            SccpStackImpl managementImplTmp = (SccpStackImpl)((FastMap.Entry)e).getValue();
            String stackname = (String)((FastMap.Entry)e).getKey();
            sb.append("Properties for ");
            sb.append(stackname);
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("zMarginXudtMessage = ");
            sb.append(managementImplTmp.getZMarginXudtMessage());
            sb.append("\n");
            sb.append("reassemblyTimerDelay = ");
            sb.append(managementImplTmp.getReassemblyTimerDelay());
            sb.append("\n");
            sb.append("maxDataMessage = ");
            sb.append(managementImplTmp.getMaxDataMessage());
            sb.append("\n");
            sb.append("periodOfLogging = ");
            sb.append(managementImplTmp.getPeriodOfLogging());
            sb.append("\n");
            sb.append("removeSpc = ");
            sb.append(managementImplTmp.isRemoveSpc());
            sb.append("\n");
            sb.append("respectPc = ");
            sb.append(managementImplTmp.isRespectPc());
            sb.append("\n");
            sb.append("previewMode = ");
            sb.append(managementImplTmp.isPreviewMode());
            sb.append("\n");
            sb.append("sstTimerDuration_Min = ");
            sb.append(managementImplTmp.getSstTimerDuration_Min());
            sb.append("\n");
            sb.append("sstTimerDuration_Max = ");
            sb.append(managementImplTmp.getSstTimerDuration_Max());
            sb.append("\n");
            sb.append("sstTimerDuration_IncreaseFactor = ");
            sb.append(managementImplTmp.getSstTimerDuration_IncreaseFactor());
            sb.append("\n");
            sb.append("sccpprotocolversion = ");
            sb.append((Object)managementImplTmp.getSccpProtocolVersion());
            sb.append("\n");
            sb.append("cc_timer_a = ");
            sb.append(managementImplTmp.getCongControlTIMER_A());
            sb.append("\n");
            sb.append("cc_timer_d = ");
            sb.append(managementImplTmp.getCongControlTIMER_D());
            sb.append("\n");
            sb.append("cc_algo = ");
            sb.append((Object)managementImplTmp.getCongControl_Algo());
            sb.append("\n");
            sb.append("cc_blockingoutgoungsccpmessages = ");
            sb.append(managementImplTmp.isCongControl_blockingOutgoungSccpMessages());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean handles(String command) {
        return command.startsWith("sccp");
    }
}

