/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SegmentingReassemblingImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnDt1Message;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SegmentingReassembling;

public class SccpConnDt1MessageImpl
extends SccpConnSegmentableMessageImpl
implements SccpConnDt1Message {
    protected SegmentingReassembling segmentingReassembling;

    public SccpConnDt1MessageImpl(int maxDataLen, int sls, int localSsn) {
        super(maxDataLen, 6, sls, localSsn);
    }

    protected SccpConnDt1MessageImpl(int maxDataLen, int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(maxDataLen, 6, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public SegmentingReassembling getSegmentingReassembling() {
        return this.segmentingReassembling;
    }

    @Override
    public void setSegmentingReassembling(SegmentingReassembling segmentingReassembling) {
        this.segmentingReassembling = segmentingReassembling;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            SegmentingReassemblingImpl segmenting = new SegmentingReassemblingImpl();
            segmenting.decode(buffer, factory, sccpProtocolVersion);
            this.segmentingReassembling = segmenting;
            int dataPointer = in.read() & 0xFF;
            in.mark(in.available());
            in.skip(dataPointer - 1);
            int len = in.read() & 0xFF;
            buffer = new byte[len];
            in.read(buffer);
            this.userData = buffer;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            int fieldsLen;
            int availLen;
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.segmentingReassembling == null) {
                return new EncodingResultData(EncodingResult.SegmentingReassemblingMissing, null, null, null);
            }
            if (this.userData == null) {
                return new EncodingResultData(EncodingResult.DataMissed, null, null, null);
            }
            byte[] bf = new byte[]{};
            if (this.userData != null) {
                bf = this.userData;
            }
            if ((availLen = maxMtp3UserDataLength - (fieldsLen = 7)) > 256) {
                availLen = 256;
            }
            if (bf.length > availLen) {
                if (logger.isEnabledFor(Level.WARN)) {
                    logger.warn(String.format("Failure when sending a DT1 message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_NOT_SUPPORTED);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] seg = ((SegmentingReassemblingImpl)this.segmentingReassembling).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(seg);
            int len = 1;
            out.write(len);
            out.write((byte)bf.length);
            out.write(bf);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public boolean isMoreData() {
        return this.segmentingReassembling.isMoreData();
    }

    @Override
    public void setMoreData(boolean moreData) {
        this.segmentingReassembling = new SegmentingReassemblingImpl(moreData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=DT1");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" DataLen=");
        if (this.userData != null) {
            sb.append(this.userData.length);
        }
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" moreData=");
        if (this.segmentingReassembling != null) {
            sb.append(this.segmentingReassembling.isMoreData());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

