/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.api.primitives;

public enum GSNAddressAddressType {
    IPv4(0),
    IPv6(1);

    private int code;

    private GSNAddressAddressType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static GSNAddressAddressType getInstance(int code) {
        switch (code) {
            case 0: {
                return IPv4;
            }
            case 1: {
                return IPv6;
            }
        }
        return null;
    }

    public int createGSNAddressFirstByte() {
        int val = this.code << 6;
        if (this.code == 0) {
            val += 4;
        }
        if (this.code == 1) {
            val += 16;
        }
        return val;
    }

    public static GSNAddressAddressType getFromGSNAddressFirstByte(int firstByte) {
        int val1 = firstByte >> 6;
        int len = firstByte & 0x3F;
        GSNAddressAddressType res = GSNAddressAddressType.getInstance(val1);
        if (res != null) {
            switch (res) {
                case IPv4: {
                    if (len != 4) break;
                    return res;
                }
                case IPv6: {
                    if (len != 16) break;
                    return res;
                }
            }
        }
        return null;
    }
}

