/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspImpl;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.TransitionHandler;
import org.restcomm.protocols.ss7.m3ua.message.mgmt.Notify;
import org.restcomm.protocols.ss7.m3ua.parameter.Status;

public class THLocalAsInactToInact
implements TransitionHandler {
    private static final Logger logger = Logger.getLogger(THLocalAsInactToInact.class);
    private AsImpl asImpl = null;
    private FSM fsm;

    public THLocalAsInactToInact(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public boolean process(FSMState state) {
        try {
            if (this.asImpl.getFunctionality() != Functionality.IPSP) {
                AspImpl remAsp = (AspImpl)this.fsm.getAttribute("asp");
                if (remAsp == null) {
                    logger.error(String.format("No ASP found. %s", this.fsm.toString()));
                    return false;
                }
                Notify msg = this.createNotify(remAsp);
                remAsp.getAspFactory().write(msg);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(String.format("Error while translating Rem AS to INACTIVE message. %s", this.fsm.toString()), e);
            return false;
        }
    }

    private Notify createNotify(AspImpl remAsp) {
        Notify msg = (Notify)this.asImpl.getMessageFactory().createMessage(0, 1);
        Status status = this.asImpl.getParameterFactory().createStatus(1, 2);
        msg.setStatus(status);
        if (remAsp.getASPIdentifier() != null) {
            msg.setASPIdentifier(remAsp.getASPIdentifier());
        }
        if (this.asImpl.getRoutingContext() != null) {
            msg.setRoutingContext(this.asImpl.getRoutingContext());
        }
        return msg;
    }
}

