/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.protocols.ss7.m3ua.As;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.IPSPType;
import org.restcomm.protocols.ss7.m3ua.RouteAs;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AsState;
import org.restcomm.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.restcomm.protocols.ss7.m3ua.impl.fsm.FSM;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.TrafficModeTypeImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.TrafficModeType;

public class RouteAsImpl
implements XMLSerializable,
RouteAs {
    private static final String TRAFFIC_MODE_TYPE = "trafficModeType";
    private static final String AS_ARRAY = "as";
    private M3UAManagementImpl m3uaManagement;
    private As[] asArray = null;
    private TrafficModeType trafficModeType = new TrafficModeTypeImpl(2);
    private String asArraytemp = null;
    protected static final XMLFormat<RouteAsImpl> AS_XML = new XMLFormat<RouteAsImpl>(RouteAsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, RouteAsImpl routeAs) throws XMLStreamException {
            int trafficMode = xml.getAttribute(RouteAsImpl.TRAFFIC_MODE_TYPE, 2);
            routeAs.trafficModeType = new TrafficModeTypeImpl(trafficMode);
            routeAs.asArraytemp = xml.getAttribute(RouteAsImpl.AS_ARRAY, "");
        }

        @Override
        public void write(RouteAsImpl routeAs, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(RouteAsImpl.TRAFFIC_MODE_TYPE, routeAs.trafficModeType.getMode());
            As[] asList = routeAs.asArray;
            StringBuffer sb = new StringBuffer();
            for (int count = 0; count < asList.length; ++count) {
                AsImpl asImpl = (AsImpl)asList[count];
                if (asImpl == null) continue;
                sb.append(asImpl.getName()).append(",");
            }
            String value = sb.toString();
            if (!value.equals("")) {
                value = value.substring(0, value.length() - 1);
            }
            xml.setAttribute(RouteAsImpl.AS_ARRAY, value);
        }
    };

    @Override
    public TrafficModeType getTrafficModeType() {
        return this.trafficModeType;
    }

    @Override
    public void setTrafficModeType(TrafficModeType trafficModeType) {
        this.trafficModeType = trafficModeType;
    }

    protected void setM3uaManagement(M3UAManagementImpl m3uaManagement) {
        this.m3uaManagement = m3uaManagement;
    }

    protected String getAsArraytemp() {
        return this.asArraytemp;
    }

    protected void addRoute(int dpc, int opc, int si, AsImpl asImpl, int traffmode) throws Exception {
        int count;
        if (this.trafficModeType.getMode() != traffmode) {
            throw new Exception(String.format("Route already setup for dpc=%d opc=%d si=%d with trafficModeType=%d. Cannot assign new trafficModeType=%d", dpc, opc, si, this.trafficModeType.getMode(), traffmode));
        }
        if (this.asArray != null) {
            for (count = 0; count < this.asArray.length; ++count) {
                AsImpl asTemp = (AsImpl)this.asArray[count];
                if (asTemp == null || !asImpl.equals(asTemp)) continue;
                throw new Exception(String.format("As=%s already added for dpc=%d opc=%d si=%d", asImpl.getName(), dpc, opc, si));
            }
        } else {
            this.asArray = new AsImpl[this.m3uaManagement.maxAsForRoute];
        }
        for (count = 0; count < this.asArray.length; ++count) {
            if (this.asArray[count] != null) continue;
            this.asArray[count] = asImpl;
            this.m3uaManagement.store();
            return;
        }
        throw new Exception(String.format("dpc=%d opc=%d si=%d combination already has maximum possible As", dpc, opc, si));
    }

    protected void removeRoute(int dpc, int opc, int si, AsImpl asImpl) throws Exception {
        for (int count = 0; count < this.asArray.length; ++count) {
            AsImpl asTemp = (AsImpl)this.asArray[count];
            if (asTemp == null || !asImpl.equals(asTemp)) continue;
            this.asArray[count] = null;
            return;
        }
        throw new Exception(String.format("No AS=%s configured  for dpc=%d opc=%d si=%d", asImpl.getName(), dpc, opc, si));
    }

    protected AsImpl getAsForRoute(int count) {
        AsImpl asImpl;
        if (this.trafficModeType.getMode() == 1) {
            count = 0;
        }
        if (this.isAsActive(asImpl = (AsImpl)this.asArray[count])) {
            return asImpl;
        }
        for (int i = 0; i < this.m3uaManagement.getMaxAsForRoute(); ++i) {
            if (++count == this.m3uaManagement.getMaxAsForRoute()) {
                count = 0;
            }
            if (!this.isAsActive(asImpl = (AsImpl)this.asArray[count])) continue;
            return asImpl;
        }
        return null;
    }

    private boolean isAsActive(AsImpl asImpl) {
        FSM fsm = null;
        if (asImpl != null) {
            fsm = asImpl.getFunctionality() == Functionality.AS || asImpl.getFunctionality() == Functionality.SGW && asImpl.getExchangeType() == ExchangeType.DE || asImpl.getFunctionality() == Functionality.IPSP && asImpl.getExchangeType() == ExchangeType.DE || asImpl.getFunctionality() == Functionality.IPSP && asImpl.getExchangeType() == ExchangeType.SE && asImpl.getIpspType() == IPSPType.CLIENT ? asImpl.getPeerFSM() : asImpl.getLocalFSM();
            AsState asState = AsState.getState(fsm.getState().getName());
            return asState == AsState.ACTIVE;
        }
        return false;
    }

    protected boolean hasAs(AsImpl asImpl) {
        for (int count = 0; count < this.asArray.length; ++count) {
            AsImpl asTemp = (AsImpl)this.asArray[count];
            if (asTemp == null || !asTemp.equals(asImpl)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAs() {
        for (int count = 0; count < this.asArray.length; ++count) {
            AsImpl asTemp = (AsImpl)this.asArray[count];
            if (asTemp == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public As[] getAsArray() {
        return this.asArray;
    }

    protected void reset() {
        AsImpl[] asList = new AsImpl[this.m3uaManagement.getMaxAsForRoute()];
        if (this.asArraytemp != null && !this.asArraytemp.equals("")) {
            String[] asNames = this.asArraytemp.split(",");
            for (int count = 0; count < asList.length && count < asNames.length; ++count) {
                String asName = asNames[count];
                As as = this.m3uaManagement.getAs(asName);
                if (as == null) continue;
                asList[count] = (AsImpl)as;
            }
        }
        this.asArray = asList;
    }
}

