/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractGlobalTitle;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.EncodingScheme;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;

public class GlobalTitle0100Impl
extends AbstractGlobalTitle
implements GlobalTitle0100 {
    private NatureOfAddress natureOfAddress;
    private NumberingPlan numberingPlan;
    private int translationType;
    protected static final XMLFormat<GlobalTitle0100Impl> XML = new XMLFormat<GlobalTitle0100Impl>(GlobalTitle0100Impl.class){
        private final ParameterFactoryImpl factory = new ParameterFactoryImpl();

        @Override
        public void write(GlobalTitle0100Impl ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("tt", ai.translationType);
            xml.setAttribute("es", ai.encodingScheme.getSchemeCode());
            xml.setAttribute("np", ai.numberingPlan.getValue());
            xml.setAttribute("nai", ai.natureOfAddress.getValue());
            xml.setAttribute("digits", ai.digits);
        }

        @Override
        public void read(XMLFormat.InputElement xml, GlobalTitle0100Impl ai) throws XMLStreamException {
            try {
                ai.translationType = xml.getAttribute("tt").toInt();
                byte esCode = (byte)xml.getAttribute("es").toInt();
                ai.encodingScheme = this.factory.createEncodingScheme(esCode);
                ai.numberingPlan = NumberingPlan.valueOf(xml.getAttribute("np").toInt());
                ai.natureOfAddress = NatureOfAddress.valueOf(xml.getAttribute("nai").toInt());
                ai.digits = xml.getAttribute("digits").toString();
            }
            catch (Exception e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public GlobalTitle0100Impl() {
    }

    public GlobalTitle0100Impl(String digits, int translationType, EncodingScheme encodingScheme, NumberingPlan numberingPlan, NatureOfAddress natureOfAddress) {
        if (digits == null) {
            throw new IllegalArgumentException();
        }
        if (encodingScheme == null) {
            throw new IllegalArgumentException();
        }
        if (numberingPlan == null) {
            throw new IllegalArgumentException();
        }
        if (natureOfAddress == null) {
            throw new IllegalArgumentException();
        }
        this.encodingScheme = encodingScheme;
        this.translationType = translationType;
        this.natureOfAddress = natureOfAddress;
        this.numberingPlan = numberingPlan;
        this.digits = digits;
    }

    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS;
    }

    public EncodingScheme getEncodingScheme() {
        return this.encodingScheme;
    }

    public int getTranslationType() {
        return this.translationType;
    }

    public NatureOfAddress getNatureOfAddress() {
        return this.natureOfAddress;
    }

    public NumberingPlan getNumberingPlan() {
        return this.numberingPlan;
    }

    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            this.translationType = in.read() & 0xFF;
            int b = in.read() & 0xFF;
            this.encodingScheme = factory.createEncodingScheme((byte)(b & 0xF));
            this.numberingPlan = NumberingPlan.valueOf((b & 0xF0) >> 4);
            b = in.read() & 0xFF;
            this.natureOfAddress = NatureOfAddress.valueOf(b);
            this.digits = this.encodingScheme.decode(in);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.digits == null) {
                throw new IllegalStateException();
            }
            out.write(this.translationType);
            out.write(this.numberingPlan.getValue() << 4 | this.encodingScheme.getSchemeCode());
            out.write(this.natureOfAddress.getValue());
            this.encodingScheme.encode(this.digits, out);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.decode(new ByteArrayInputStream(b), factory, sccpProtocolVersion);
    }

    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos, removeSpc, sccpProtocolVersion);
        return baos.toByteArray();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.natureOfAddress == null ? 0 : this.natureOfAddress.hashCode());
        result = 31 * result + (this.numberingPlan == null ? 0 : this.numberingPlan.hashCode());
        result = 31 * result + this.translationType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTitle0100Impl other = (GlobalTitle0100Impl)obj;
        if (this.natureOfAddress != other.natureOfAddress) {
            return false;
        }
        if (this.numberingPlan != other.numberingPlan) {
            return false;
        }
        return this.translationType == other.translationType;
    }

    public String toString() {
        return "GlobalTitle0100Impl [digits=" + this.digits + ", natureOfAddress=" + (Object)((Object)this.natureOfAddress) + ", numberingPlan=" + (Object)((Object)this.numberingPlan) + ", translationType=" + this.translationType + ", encodingScheme=" + this.encodingScheme + "]";
    }
}

