/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.parameter;

import java.nio.ByteBuffer;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.DestinationPointCodeImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.LocalRKIdentifierImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.NetworkAppearanceImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.OPCListImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.RoutingContextImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ServiceIndicatorsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.TrafficModeTypeImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.DestinationPointCode;
import org.mobicents.protocols.ss7.m3ua.parameter.LocalRKIdentifier;
import org.mobicents.protocols.ss7.m3ua.parameter.NetworkAppearance;
import org.mobicents.protocols.ss7.m3ua.parameter.OPCList;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingKey;
import org.mobicents.protocols.ss7.m3ua.parameter.ServiceIndicators;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;

public class RoutingKeyImpl
extends ParameterImpl
implements RoutingKey,
XMLSerializable {
    private static final String LOCAL_RK_ID = "localRkId";
    private static final String ROUTING_CONTEXT = "rc";
    private static final String TRAFFIC_MODE = "trafficMode";
    private static final String NETWORK_APPEARANCE = "netAppearance";
    private static final String DPCS = "dpcs";
    private static final String DPC_ARRAY_SIZE = "dpcsSize";
    private static final String SIS = "sis";
    private static final String SI_ARRAY_SIZE = "sisSize";
    private static final String OPC_LIST = "opcList";
    private static final String OPC_ARRAY_SIZE = "opcSize";
    private LocalRKIdentifier localRkId;
    private RoutingContext rc;
    private TrafficModeType trafMdTy;
    private NetworkAppearance netApp;
    private DestinationPointCode[] dpc;
    private ServiceIndicators[] servInds;
    private OPCList[] opcList;
    private ByteBuffer buffer = ByteBuffer.allocate(256);
    private byte[] value;
    protected static final XMLFormat<RoutingKeyImpl> RC_XML = new XMLFormat<RoutingKeyImpl>(RoutingKeyImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, RoutingKeyImpl routingKey) throws XMLStreamException {
            int i;
            int dpcArraySize = xml.getAttribute(RoutingKeyImpl.DPC_ARRAY_SIZE).toInt();
            int opcArraySize = xml.getAttribute(RoutingKeyImpl.OPC_ARRAY_SIZE).toInt();
            int siArraySize = xml.getAttribute(RoutingKeyImpl.SI_ARRAY_SIZE).toInt();
            routingKey.localRkId = (LocalRKIdentifier)xml.get(RoutingKeyImpl.LOCAL_RK_ID);
            routingKey.rc = (RoutingContext)xml.get(RoutingKeyImpl.ROUTING_CONTEXT);
            routingKey.trafMdTy = (TrafficModeType)xml.get(RoutingKeyImpl.TRAFFIC_MODE);
            routingKey.netApp = (NetworkAppearance)xml.get(RoutingKeyImpl.NETWORK_APPEARANCE);
            if (dpcArraySize != -1) {
                RoutingKeyImpl.access$402(routingKey, new DestinationPointCodeImpl[dpcArraySize]);
                for (i = 0; i < dpcArraySize; ++i) {
                    ((RoutingKeyImpl)routingKey).dpc[i] = (DestinationPointCode)xml.get(RoutingKeyImpl.DPCS);
                }
            }
            if (opcArraySize != -1) {
                RoutingKeyImpl.access$502(routingKey, new OPCList[opcArraySize]);
                for (i = 0; i < opcArraySize; ++i) {
                    ((RoutingKeyImpl)routingKey).opcList[i] = (OPCList)xml.get(RoutingKeyImpl.OPC_LIST);
                }
            }
            if (siArraySize != -1) {
                RoutingKeyImpl.access$602(routingKey, new ServiceIndicators[siArraySize]);
                for (i = 0; i < siArraySize; ++i) {
                    ((RoutingKeyImpl)routingKey).servInds[i] = (ServiceIndicators)xml.get(RoutingKeyImpl.SIS);
                }
            }
            routingKey.encode();
        }

        @Override
        public void write(RoutingKeyImpl routingKey, XMLFormat.OutputElement xml) throws XMLStreamException {
            int i;
            if (routingKey.dpc != null) {
                xml.setAttribute(RoutingKeyImpl.DPC_ARRAY_SIZE, routingKey.dpc.length);
            } else {
                xml.setAttribute(RoutingKeyImpl.DPC_ARRAY_SIZE, -1);
            }
            if (routingKey.opcList != null) {
                xml.setAttribute(RoutingKeyImpl.OPC_ARRAY_SIZE, routingKey.opcList.length);
            } else {
                xml.setAttribute(RoutingKeyImpl.OPC_ARRAY_SIZE, -1);
            }
            if (routingKey.servInds != null) {
                xml.setAttribute(RoutingKeyImpl.SI_ARRAY_SIZE, routingKey.servInds.length);
            } else {
                xml.setAttribute(RoutingKeyImpl.SI_ARRAY_SIZE, -1);
            }
            xml.add(routingKey.localRkId, RoutingKeyImpl.LOCAL_RK_ID);
            xml.add(routingKey.rc, RoutingKeyImpl.ROUTING_CONTEXT);
            xml.add(routingKey.trafMdTy, RoutingKeyImpl.TRAFFIC_MODE);
            xml.add(routingKey.netApp, RoutingKeyImpl.NETWORK_APPEARANCE);
            if (routingKey.dpc != null) {
                for (i = 0; i < routingKey.dpc.length; ++i) {
                    xml.add(routingKey.dpc[i], RoutingKeyImpl.DPCS);
                }
            }
            if (routingKey.opcList != null) {
                for (i = 0; i < routingKey.opcList.length; ++i) {
                    xml.add(routingKey.opcList[i], RoutingKeyImpl.OPC_LIST);
                }
            }
            if (routingKey.servInds != null) {
                for (i = 0; i < routingKey.servInds.length; ++i) {
                    xml.add(routingKey.servInds[i], RoutingKeyImpl.SIS);
                }
            }
        }
    };

    public RoutingKeyImpl() {
        this.tag = (short)519;
    }

    protected RoutingKeyImpl(byte[] value) {
        this.tag = (short)519;
        this.value = value;
        this.decode(value);
        this.value = value;
    }

    protected RoutingKeyImpl(LocalRKIdentifier localRkId, RoutingContext rc, TrafficModeType trafMdTy, NetworkAppearance netApp, DestinationPointCode[] dpc, ServiceIndicators[] servInds, OPCList[] opcList) {
        this.tag = (short)519;
        this.localRkId = localRkId;
        this.rc = rc;
        this.trafMdTy = trafMdTy;
        this.netApp = netApp;
        this.dpc = dpc;
        this.servInds = servInds;
        this.opcList = opcList;
        this.encode();
    }

    private void decode(byte[] data) {
        FastList<DestinationPointCodeImpl> dpcList = new FastList<DestinationPointCodeImpl>();
        FastList<ServiceIndicatorsImpl> serIndList = new FastList<ServiceIndicatorsImpl>();
        FastList<OPCListImpl> opcListList = new FastList<OPCListImpl>();
        block9: for (int pos = 0; pos < data.length; pos += pos % 4) {
            short tag = (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
            short len = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF);
            byte[] value = new byte[len - 4];
            System.arraycopy(data, pos + 4, value, 0, value.length);
            pos += len;
            switch (tag) {
                case 522: {
                    this.localRkId = new LocalRKIdentifierImpl(value);
                    continue block9;
                }
                case 6: {
                    this.rc = new RoutingContextImpl(value);
                    continue block9;
                }
                case 11: {
                    this.trafMdTy = new TrafficModeTypeImpl(value);
                    continue block9;
                }
                case 512: {
                    this.netApp = new NetworkAppearanceImpl(value);
                    continue block9;
                }
                case 523: {
                    dpcList.add(new DestinationPointCodeImpl(value));
                    continue block9;
                }
                case 524: {
                    serIndList.add(new ServiceIndicatorsImpl(value));
                    continue block9;
                }
                case 526: {
                    opcListList.add(new OPCListImpl(value));
                }
            }
        }
        this.dpc = new DestinationPointCode[dpcList.size()];
        this.dpc = dpcList.toArray(this.dpc);
        if (serIndList.size() > 0) {
            this.servInds = new ServiceIndicators[serIndList.size()];
            this.servInds = serIndList.toArray(this.servInds);
        }
        if (opcListList.size() > 0) {
            this.opcList = new OPCList[opcListList.size()];
            this.opcList = opcListList.toArray(this.opcList);
        }
    }

    private void encode() {
        if (this.localRkId != null) {
            ((LocalRKIdentifierImpl)this.localRkId).write(this.buffer);
        }
        if (this.rc != null) {
            ((RoutingContextImpl)this.rc).write(this.buffer);
        }
        if (this.trafMdTy != null) {
            ((TrafficModeTypeImpl)this.trafMdTy).write(this.buffer);
        }
        if (this.netApp != null) {
            ((NetworkAppearanceImpl)this.netApp).write(this.buffer);
        }
        for (int i = 0; i < this.dpc.length; ++i) {
            ((DestinationPointCodeImpl)this.dpc[i]).write(this.buffer);
            if (this.servInds != null) {
                ((ServiceIndicatorsImpl)this.servInds[i]).write(this.buffer);
            }
            if (this.opcList == null) continue;
            ((OPCListImpl)this.opcList[i]).write(this.buffer);
        }
        this.value = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(this.value);
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public DestinationPointCode[] getDestinationPointCodes() {
        return this.dpc;
    }

    @Override
    public LocalRKIdentifier getLocalRKIdentifier() {
        return this.localRkId;
    }

    @Override
    public NetworkAppearance getNetworkAppearance() {
        return this.netApp;
    }

    @Override
    public OPCList[] getOPCLists() {
        return this.opcList;
    }

    @Override
    public RoutingContext getRoutingContext() {
        return this.rc;
    }

    @Override
    public ServiceIndicators[] getServiceIndicators() {
        return this.servInds;
    }

    @Override
    public TrafficModeType getTrafficModeType() {
        return this.trafMdTy;
    }

    public String toString() {
        TextBuilder tb = TextBuilder.newInstance();
        tb.append("RoutingKey(");
        if (this.localRkId != null) {
            tb.append(this.localRkId.toString());
        }
        if (this.rc != null) {
            tb.append(this.rc.toString());
        }
        if (this.trafMdTy != null) {
            tb.append(this.trafMdTy.toString());
        }
        if (this.netApp != null) {
            tb.append(this.netApp.toString());
        }
        if (this.dpc != null) {
            tb.append(this.dpc.toString());
        }
        if (this.servInds != null) {
            tb.append(this.servInds.toString());
        }
        if (this.opcList != null) {
            tb.append(this.opcList.toString());
        }
        tb.append(")");
        return tb.toString();
    }

    static /* synthetic */ DestinationPointCode[] access$402(RoutingKeyImpl x0, DestinationPointCode[] x1) {
        x0.dpc = x1;
        return x1;
    }

    static /* synthetic */ OPCList[] access$502(RoutingKeyImpl x0, OPCList[] x1) {
        x0.opcList = x1;
        return x1;
    }

    static /* synthetic */ ServiceIndicators[] access$602(RoutingKeyImpl x0, ServiceIndicators[] x1) {
        x0.servInds = x1;
        return x1;
    }
}

